/*
 * Decompiled with CFR 0.152.
 */
package processing.app.contrib;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import processing.app.Base;
import processing.app.Library;
import processing.app.Messages;
import processing.app.Util;
import processing.app.contrib.ExamplesContribution;
import processing.app.contrib.LocalContribution;
import processing.app.contrib.ModeContribution;
import processing.app.contrib.StatusPanel;
import processing.app.contrib.ToolContribution;
import processing.app.ui.Editor;
import processing.core.PApplet;
import processing.data.StringDict;

public enum ContributionType {
    LIBRARY,
    MODE,
    TOOL,
    EXAMPLES;


    public String toString() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case LIBRARY -> "library";
            case MODE -> "mode";
            case TOOL -> "tool";
            case EXAMPLES -> "examples";
        };
    }

    public String getTitle() {
        String lower = this.toString();
        return Character.toUpperCase(lower.charAt(0)) + lower.substring(1);
    }

    public String getPropertiesName() {
        return this + ".properties";
    }

    public StringDict loadProperties(File contribFolder) {
        File propertiesFile = new File(contribFolder, this.getPropertiesName());
        if (propertiesFile.exists()) {
            return Util.readSettings(propertiesFile, false);
        }
        System.err.println("Not found: " + propertiesFile);
        return null;
    }

    public File createTempFolder() throws IOException {
        return Util.createTempFolder(this.toString(), "tmp", this.getSketchbookFolder());
    }

    public boolean isTempFolderName(String name) {
        return name.startsWith(this.toString()) && name.endsWith("tmp");
    }

    public static ContributionType fromName(String s) {
        if (s != null) {
            if ("library".equalsIgnoreCase(s)) {
                return LIBRARY;
            }
            if ("mode".equalsIgnoreCase(s)) {
                return MODE;
            }
            if ("tool".equalsIgnoreCase(s)) {
                return TOOL;
            }
            if ("examples".equalsIgnoreCase(s)) {
                return EXAMPLES;
            }
        }
        return null;
    }

    public static ContributionType fromFilePath(String path) {
        String filename = path.substring(path.lastIndexOf(47) + 1);
        for (ContributionType type : ContributionType.values()) {
            if (!filename.equals(type.getPropertiesName())) continue;
            return type;
        }
        return null;
    }

    public File getSketchbookFolder() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case LIBRARY -> Base.getSketchbookLibrariesFolder();
            case TOOL -> Base.getSketchbookToolsFolder();
            case MODE -> Base.getSketchbookModesFolder();
            case EXAMPLES -> Base.getSketchbookExamplesFolder();
        };
    }

    public boolean isCandidate(File potential) {
        return potential.isDirectory() && new File(potential, this.toString()).exists() && !this.isTempFolderName(potential.getName()) && this.isCompatible(potential);
    }

    private boolean isCompatible(File contribFolder) {
        StringDict properties = this.loadProperties(contribFolder);
        if (properties != null) {
            int revisionNum = Base.getRevision();
            int minRevision = 0;
            String minRev = properties.get("minRevision");
            if (minRev != null) {
                minRevision = PApplet.parseInt((String)minRev, (int)0);
            }
            int maxRevision = 0;
            String maxRev = properties.get("maxRevision");
            if (maxRev != null) {
                maxRevision = PApplet.parseInt((String)maxRev, (int)0);
            }
            return (maxRevision == 0 || revisionNum <= maxRevision) && revisionNum >= minRevision;
        }
        return true;
    }

    public File[] listCandidates(File folder) {
        return folder.listFiles(this::isCandidate);
    }

    File findCandidate(File folder) {
        File[] folders = this.listCandidates(folder);
        if (folders.length == 0) {
            return null;
        }
        if (folders.length > 1) {
            Messages.log("More than one " + this + " found inside " + folder.getAbsolutePath());
        }
        return folders[0];
    }

    boolean requiresRestart() {
        return this == TOOL || this == MODE;
    }

    LocalContribution load(Base base, File folder) {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case LIBRARY -> Library.load(folder);
            case TOOL -> ToolContribution.load(folder);
            case MODE -> ModeContribution.load(base, folder);
            case EXAMPLES -> ExamplesContribution.load(folder);
        };
    }

    List<LocalContribution> listContributions(Base base, Editor editor) {
        ArrayList<LocalContribution> contribs = new ArrayList<LocalContribution>();
        switch (this) {
            case LIBRARY: {
                if (editor == null) break;
                contribs.addAll(editor.getMode().contribLibraries);
                break;
            }
            case TOOL: {
                contribs.addAll(base.getContribTools());
                break;
            }
            case MODE: {
                contribs.addAll(base.getContribModes());
                break;
            }
            case EXAMPLES: {
                contribs.addAll(base.getContribExamples());
            }
        }
        return contribs;
    }

    File getBackupFolder() {
        return new File(this.getSketchbookFolder(), "old");
    }

    File createBackupFolder(StatusPanel status) {
        File backupFolder = this.getBackupFolder();
        if (!backupFolder.exists() && !backupFolder.mkdirs()) {
            status.setErrorMessage("Could not create a backup folder in the sketchbook " + this + " folder.");
            return null;
        }
        return backupFolder;
    }
}

