/*
 * Decompiled with CFR 0.152.
 */
package processing.app.contrib;

import java.awt.Dimension;
import java.awt.Font;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextPane;
import javax.swing.LayoutStyle;
import javax.swing.event.HyperlinkEvent;
import javax.swing.text.html.HTMLDocument;
import processing.app.Language;
import processing.app.Platform;
import processing.app.Util;
import processing.app.contrib.Contribution;
import processing.app.contrib.ContributionListing;
import processing.app.contrib.ContributionTab;
import processing.app.contrib.ManagerFrame;
import processing.app.contrib.StatusDetail;
import processing.app.laf.PdeButtonUI;
import processing.app.laf.PdeProgressBarUI;
import processing.app.ui.Theme;
import processing.app.ui.Toolkit;

class StatusPanel
extends JPanel {
    static final int LABEL_WIDTH = Toolkit.zoom(480);
    static final int BUTTON_WIDTH = Toolkit.zoom(150);
    Icon foundationIcon;
    String detailStyle;
    JTextPane label;
    JButton installButton;
    JProgressBar progressBar;
    JLabel updateLabel;
    JButton updateButton;
    JButton removeButton;
    GroupLayout layout;
    JLabel iconLabel;
    ContributionTab contributionTab;
    private static final String REMOVE_RESTART_MESSAGE = String.format("<i>%s</i>", Language.text("contrib.messages.remove_restart"));
    private static final String INSTALL_RESTART_MESSAGE = String.format("<i>%s</i>", Language.text("contrib.messages.install_restart"));
    private static final String UPDATE_RESTART_MESSAGE = String.format("<i>%s</i>", Language.text("contrib.messages.update_restart"));

    public StatusPanel(ContributionTab contributionTab) {
        this.contributionTab = contributionTab;
        this.buildLayout();
    }

    protected void buildLayout() {
        this.iconLabel = new JLabel();
        this.iconLabel.setHorizontalAlignment(0);
        this.label = new JTextPane();
        this.label.setEditable(false);
        this.label.setOpaque(false);
        this.label.setContentType("text/html");
        this.label.addHyperlinkListener(e -> {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED && e.getURL() != null) {
                Platform.openURL(e.getURL().toString());
            }
        });
        this.installButton = new JButton("Install");
        this.installButton.setHorizontalAlignment(2);
        this.installButton.addActionListener(e -> {
            this.installButton.setEnabled(false);
            StatusDetail currentDetail = this.contributionTab.listPanel.getSelectedDetail();
            currentDetail.installContrib(this.contributionTab.listPanel);
            this.applyDetail(currentDetail);
        });
        this.buildProgressBar();
        this.updateLabel = new JLabel(" ");
        this.updateLabel.setHorizontalAlignment(0);
        this.updateButton = new JButton("Update");
        this.updateButton.setHorizontalAlignment(2);
        this.updateButton.addActionListener(e -> {
            this.updateButton.setEnabled(false);
            StatusDetail currentDetail = this.contributionTab.listPanel.getSelectedDetail();
            currentDetail.updateContrib(this.contributionTab.listPanel);
            this.applyDetail(currentDetail);
        });
        this.removeButton = new JButton("Remove");
        this.removeButton.setHorizontalAlignment(2);
        this.removeButton.addActionListener(e -> {
            this.removeButton.setEnabled(false);
            StatusDetail currentPanel = this.contributionTab.listPanel.getSelectedDetail();
            currentPanel.removeContrib();
            this.applyDetail(currentPanel);
        });
        this.layout = new GroupLayout(this);
        this.setLayout(this.layout);
        this.layout.setAutoCreateContainerGaps(true);
        this.layout.setAutoCreateGaps(true);
        this.layout.setHorizontalGroup(this.layout.createSequentialGroup().addGap(0).addComponent(this.iconLabel, ManagerFrame.STATUS_WIDTH, ManagerFrame.STATUS_WIDTH, ManagerFrame.STATUS_WIDTH).addGap(0).addComponent(this.label, LABEL_WIDTH, LABEL_WIDTH, LABEL_WIDTH).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -2, Short.MAX_VALUE).addGroup(this.layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.installButton, BUTTON_WIDTH, BUTTON_WIDTH, BUTTON_WIDTH).addComponent(this.progressBar).addComponent(this.updateLabel, BUTTON_WIDTH, BUTTON_WIDTH, BUTTON_WIDTH).addComponent(this.updateButton).addComponent(this.removeButton)).addGap(12));
        this.layout.setVerticalGroup(this.layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.iconLabel).addComponent(this.label).addGroup(this.layout.createSequentialGroup().addComponent(this.installButton).addGroup(this.layout.createParallelGroup().addComponent(this.progressBar).addComponent(this.updateLabel)).addComponent(this.updateButton).addComponent(this.removeButton)));
        this.layout.linkSize(0, this.installButton, this.progressBar, this.updateButton, this.removeButton);
        this.installButton.setEnabled(false);
        this.updateButton.setEnabled(false);
        this.removeButton.setEnabled(false);
        this.updateLabel.setVisible(true);
        this.layout.setHonorsVisibility(this.updateLabel, false);
    }

    protected void buildProgressBar() {
        this.progressBar = new JProgressBar();
        this.progressBar.setStringPainted(true);
        this.progressBar.setAlignmentX(0.5f);
        this.resetProgressBar();
        int high = this.progressBar.getPreferredSize().height;
        Dimension dim = new Dimension(BUTTON_WIDTH, high);
        this.progressBar.setPreferredSize(dim);
        this.progressBar.setMaximumSize(dim);
        this.progressBar.setMinimumSize(dim);
    }

    protected void resetProgressBar() {
        this.progressBar.setString(Language.text("contrib.progress.starting"));
        this.progressBar.setIndeterminate(false);
        this.progressBar.setValue(0);
        this.progressBar.setVisible(false);
    }

    protected void updateTheme() {
        this.setBackground(Theme.getColor("manager.panel.background.color"));
        Font detailFont = Theme.getFont("manager.panel.font");
        this.detailStyle = "body {   margin: 0;   padding: 0;  font-family: " + detailFont.getName() + ", sans-serif;  font-size: " + detailFont.getSize() + "px;  color: " + Theme.get("manager.panel.text.color") + ";}a {   color: " + Theme.get("manager.panel.link.color") + ";  text-decoration: none;}";
        this.updateLabel.setForeground(Theme.getColor("manager.panel.text.color"));
        this.foundationIcon = Toolkit.renderIcon("manager/foundation", Theme.get("manager.panel.foundation.color"), 32);
        StatusPanel.updateButtonTheme(this.installButton, "install");
        StatusPanel.updateButtonTheme(this.updateButton, "update");
        StatusPanel.updateButtonTheme(this.removeButton, "remove");
        StatusDetail currentDetail = this.contributionTab.listPanel.getSelectedDetail();
        if (currentDetail != null) {
            this.applyDetail(currentDetail);
            currentDetail.updateTheme();
        }
        if (this.progressBar.getUI() instanceof PdeProgressBarUI) {
            ((PdeProgressBarUI)this.progressBar.getUI()).updateTheme();
        } else {
            this.progressBar.setUI(new PdeProgressBarUI("manager.progress"));
        }
    }

    protected static void updateButtonTheme(JButton button, String name) {
        if (button.getUI() instanceof PdeButtonUI) {
            ((PdeButtonUI)button.getUI()).updateTheme();
        } else {
            button.setUI(new PdeButtonUI("manager.button"));
        }
        button.setIcon(Toolkit.renderIcon("manager/panel-" + name, Theme.get("manager.button.enabled.icon.color"), 16));
        button.setPressedIcon(Toolkit.renderIcon("manager/panel-" + name, Theme.get("manager.button.pressed.icon.color"), 16));
        button.setDisabledIcon(Toolkit.renderIcon("manager/panel-" + name, Theme.get("manager.button.disabled.icon.color"), 16));
    }

    void setErrorMessage(String message) {
        if (this.label != null) {
            this.label.setText(message);
            this.label.repaint();
        }
    }

    void clearMessage() {
        if (this.label != null) {
            this.label.setText(null);
            this.label.repaint();
        }
    }

    static String updateDescription(Contribution contrib) {
        String fontFace = "<font face=\"" + Toolkit.getSansFontName() + "\">";
        StringBuilder desc = new StringBuilder();
        desc.append("<html><body>");
        desc.append(fontFace);
        if (contrib.getUrl() == null) {
            desc.append(contrib.getName());
        } else {
            desc.append("<a href=\"");
            desc.append(contrib.getUrl());
            desc.append("\">");
            desc.append(contrib.getName());
            desc.append("</a>");
        }
        desc.append("</font> ");
        String prettyVersion = contrib.getPrettyVersion();
        if (prettyVersion != null) {
            desc.append(prettyVersion);
        }
        desc.append(" <br/>");
        String authorList = contrib.getAuthorList();
        if (authorList != null && !authorList.isEmpty()) {
            desc.append(Util.markDownLinksToHtml(contrib.getAuthorList()));
        }
        desc.append("<br/><br/>");
        if (contrib.isDeletionFlagged()) {
            desc.append(REMOVE_RESTART_MESSAGE);
        } else if (contrib.isRestartFlagged()) {
            desc.append(INSTALL_RESTART_MESSAGE);
        } else if (contrib.isUpdateFlagged()) {
            desc.append(UPDATE_RESTART_MESSAGE);
        } else {
            Object sentence = contrib.getSentence();
            if (sentence == null || ((String)sentence).isEmpty()) {
                sentence = "<i>" + Language.text("contrib.errors.description_unavailable") + "</i>";
            } else {
                sentence = Util.sanitizeHtmlTags((String)sentence);
                sentence = Util.markDownLinksToHtml((String)sentence);
            }
            desc.append((String)sentence);
        }
        long lastUpdatedUTC = contrib.getLastUpdated();
        if (lastUpdatedUTC != 0L) {
            DateFormat dateFormatter = DateFormat.getDateInstance(2);
            Date lastUpdatedDate = new Date(lastUpdatedUTC);
            if (prettyVersion != null) {
                desc.append(", ");
            }
            desc.append("Last Updated on ");
            desc.append(dateFormatter.format(lastUpdatedDate));
        }
        desc.append("</body></html>");
        return desc.toString();
    }

    protected void applyDetail(StatusDetail detail) {
        Contribution contrib = detail.getContrib();
        this.iconLabel.setIcon(contrib.isFoundation() ? this.foundationIcon : null);
        this.label.setText(StatusPanel.updateDescription(contrib));
        ((HTMLDocument)this.label.getDocument()).getStyleSheet().addRule(this.detailStyle);
        ContributionListing listing = ContributionListing.getInstance();
        this.updateButton.setEnabled(listing.hasUpdates(contrib) && !contrib.isUpdateFlagged() && !detail.updateInProgress);
        String latestVersion = listing.getLatestPrettyVersion(contrib);
        String currentVersion = contrib.getPrettyVersion();
        this.installButton.setEnabled(!contrib.isInstalled() && contrib.isCompatible() && !detail.installInProgress);
        if (contrib.isCompatible()) {
            if (this.installButton.isEnabled()) {
                if (latestVersion != null) {
                    this.updateLabel.setText(latestVersion + " available");
                } else {
                    this.updateLabel.setText("Available");
                }
            } else if (currentVersion != null) {
                this.updateLabel.setText(currentVersion + " installed");
            } else {
                this.updateLabel.setText("Installed");
            }
        } else if (currentVersion != null) {
            this.updateLabel.setText(currentVersion + " not compatible");
        } else {
            this.updateLabel.setText("Not compatible");
        }
        if (this.updateButton.isEnabled() && latestVersion != null) {
            this.updateButton.setText("Update to " + latestVersion);
        } else {
            this.updateButton.setText("Update");
        }
        this.removeButton.setEnabled(contrib.isInstalled() && !detail.removeInProgress);
        if (detail.updateInProgress || detail.installInProgress || detail.removeInProgress) {
            this.progressBar.setVisible(true);
            this.updateLabel.setVisible(false);
        } else {
            this.progressBar.setVisible(false);
            this.updateLabel.setVisible(true);
        }
        detail.setProgressBar(this.progressBar);
    }
}

