/*
 * Decompiled with CFR 0.152.
 */
package processing.app.laf;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.CellRendererPane;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.ListCellRenderer;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.basic.BasicComboBoxUI;
import processing.app.ui.Theme;
import processing.app.ui.Toolkit;

public class PdeComboBoxUI
extends BasicComboBoxUI {
    final String prefix;
    Color enabledFgColor;
    Color enabledBgColor;
    Color disabledFgColor;
    Color disabledBgColor;
    Color selectedFgColor;
    Color selectedBgColor;

    public PdeComboBoxUI(String prefix) {
        this.prefix = prefix;
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.comboBox.setBorder(null);
    }

    @Override
    protected JButton createArrowButton() {
        JButton button = new JButton();
        button.setBorder(null);
        return button;
    }

    @Override
    protected ListCellRenderer<Object> createRenderer() {
        return new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JComponent c;
                Container popup;
                Container scrollPane;
                Container viewport;
                Container crp;
                Container parent = this.getParent();
                if (parent instanceof CellRendererPane && (crp = parent.getParent()) instanceof JComponent && (viewport = crp.getParent()) instanceof JViewport && (scrollPane = viewport.getParent()) instanceof JScrollPane && (popup = scrollPane.getParent()) instanceof JComponent && !((c = (JComponent)popup).getBorder() instanceof EmptyBorder)) {
                    c.setBorder(new EmptyBorder(0, 0, 0, 0));
                }
                this.setBorder(new EmptyBorder(2, index == -1 ? 0 : 6, 2, 2));
                if (isSelected) {
                    this.setForeground(PdeComboBoxUI.this.selectedFgColor);
                    this.setBackground(PdeComboBoxUI.this.selectedBgColor);
                } else {
                    this.setForeground(PdeComboBoxUI.this.enabledFgColor);
                    this.setBackground(PdeComboBoxUI.this.enabledBgColor);
                }
                this.setText(String.valueOf(value));
                return this;
            }
        };
    }

    @Override
    public void paintCurrentValue(Graphics g, Rectangle bounds, boolean hasFocus) {
        Component c;
        ListCellRenderer<Object> renderer = this.comboBox.getRenderer();
        if (hasFocus && !this.isPopupVisible(this.comboBox)) {
            c = renderer.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, true, false);
        } else {
            c = renderer.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, false, false);
            c.setBackground(this.enabledBgColor);
        }
        c.setFont(this.comboBox.getFont());
        if (this.comboBox.isEnabled()) {
            c.setForeground(this.enabledFgColor);
            c.setBackground(this.enabledBgColor);
        } else {
            c.setForeground(this.disabledFgColor);
            c.setBackground(this.disabledBgColor);
        }
        boolean shouldValidate = c instanceof JPanel;
        int x = bounds.x;
        int y = bounds.y;
        int w = bounds.width;
        int h = bounds.height;
        if (this.padding != null) {
            x = bounds.x + this.padding.left;
            y = bounds.y + this.padding.top;
            w = bounds.width - (this.padding.left + this.padding.right);
            h = bounds.height - (this.padding.top + this.padding.bottom);
        }
        this.currentValuePane.paintComponent(g, c, this.comboBox, x, y, w, h, shouldValidate);
    }

    @Override
    public void paintCurrentValueBackground(Graphics g, Rectangle bounds, boolean hasFocus) {
        Color t = g.getColor();
        if (this.comboBox.isEnabled()) {
            g.setColor(this.enabledBgColor);
        } else {
            g.setColor(this.disabledBgColor);
        }
        g.fillRect(bounds.x, bounds.y, bounds.width, bounds.height);
        g.setColor(t);
    }

    public void updateTheme() {
        this.enabledFgColor = Theme.getColor(this.prefix + ".enabled.fgcolor");
        this.enabledBgColor = Theme.getColor(this.prefix + ".enabled.bgcolor");
        this.disabledFgColor = Theme.getColor(this.prefix + ".disabled.fgcolor");
        this.disabledBgColor = Theme.getColor(this.prefix + ".disabled.bgcolor");
        this.selectedFgColor = Theme.getColor(this.prefix + ".selected.fgcolor");
        this.selectedBgColor = Theme.getColor(this.prefix + ".selected.bgcolor");
        if (this.arrowButton.isEnabled()) {
            this.arrowButton.setBackground(this.enabledBgColor);
            this.arrowButton.setForeground(this.enabledFgColor);
            this.arrowButton.setIcon(Toolkit.renderIcon("manager/chevron", Theme.get(this.prefix + ".enabled.fgcolor"), 16));
        } else {
            this.arrowButton.setBackground(this.disabledBgColor);
            this.arrowButton.setForeground(this.disabledFgColor);
            this.arrowButton.setIcon(Toolkit.renderIcon("manager/chevron", Theme.get(this.prefix + ".disabled.fgcolor"), 16));
        }
    }
}

