/*
 * Decompiled with CFR 0.152.
 */
package processing.app.laf;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.plaf.basic.BasicScrollBarUI;
import processing.app.ui.Theme;

public class PdeScrollBarUI
extends BasicScrollBarUI {
    private final Dimension NONE = new Dimension();
    private final String backgroundAttr;
    private final String pressedAttr;
    private final String rolloverAttr;
    private final String enabledAttr;
    private Color backgroundColor;
    private Color pressedColor;
    private Color rolloverColor;
    private Color enabledColor;

    public PdeScrollBarUI(String prefix) {
        this.backgroundAttr = prefix + ".color";
        this.pressedAttr = prefix + ".thumb.pressed.color";
        this.rolloverAttr = prefix + ".thumb.rollover.color";
        this.enabledAttr = prefix + ".thumb.enabled.color";
    }

    public void updateTheme() {
        this.backgroundColor = Theme.getColor(this.backgroundAttr);
        this.pressedColor = Theme.getColor(this.pressedAttr);
        this.rolloverColor = Theme.getColor(this.rolloverAttr);
        this.enabledColor = Theme.getColor(this.enabledAttr);
    }

    @Override
    protected JButton createDecreaseButton(int orientation) {
        return new JButton(){

            @Override
            public Dimension getPreferredSize() {
                return PdeScrollBarUI.this.NONE;
            }
        };
    }

    @Override
    protected JButton createIncreaseButton(int orientation) {
        return new JButton(){

            @Override
            public Dimension getPreferredSize() {
                return PdeScrollBarUI.this.NONE;
            }
        };
    }

    @Override
    protected void paintTrack(Graphics g, JComponent c, Rectangle r) {
        g.setColor(this.backgroundColor);
        g.fillRect(0, 0, c.getWidth(), c.getHeight());
    }

    @Override
    protected void paintThumb(Graphics g, JComponent c, Rectangle r) {
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        JScrollBar sb = (JScrollBar)c;
        if (sb.isEnabled()) {
            Color color = this.isDragging ? this.pressedColor : (this.isThumbRollover() ? this.rolloverColor : this.enabledColor);
            g2.setPaint(color);
            int inset = 3;
            int arc = Math.min(c.getWidth(), c.getHeight()) - inset * 2;
            g2.fillRoundRect(r.x + inset, r.y + inset, r.width - inset * 2, r.height - inset * 2, arc, arc);
            g2.dispose();
        }
    }

    @Override
    protected void setThumbBounds(int x, int y, int width, int height) {
        super.setThumbBounds(x, y, width, height);
        this.scrollbar.repaint();
    }
}

