/*
 * Decompiled with CFR 0.152.
 */
package processing.app.laf;

import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.awt.font.TextHitInfo;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import javax.swing.JComponent;

class SwingUtilities2 {
    private static final int CHAR_BUFFER_SIZE = 100;
    private static final Object charsBufferLock = new Object();
    private static char[] charsBuffer = new char[100];
    public static final FontRenderContext DEFAULT_FRC = new FontRenderContext(null, false, false);

    SwingUtilities2() {
    }

    private static int syncCharsBuffer(String s) {
        int length = s.length();
        if (charsBuffer == null || charsBuffer.length < length) {
            charsBuffer = s.toCharArray();
        } else {
            s.getChars(0, length, charsBuffer, 0);
        }
        return length;
    }

    public static final boolean isComplexLayout(char[] text, int start, int limit) {
        return false;
    }

    public static FontMetrics getFontMetrics(JComponent c, Graphics g) {
        return SwingUtilities2.getFontMetrics(c, g, g.getFont());
    }

    public static FontMetrics getFontMetrics(JComponent c, Graphics g, Font font) {
        if (c != null) {
            return c.getFontMetrics(font);
        }
        return Toolkit.getDefaultToolkit().getFontMetrics(font);
    }

    public static int stringWidth(JComponent c, FontMetrics fm, String string) {
        return (int)SwingUtilities2.stringWidth(c, fm, string, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static float stringWidth(JComponent c, FontMetrics fm, String string, boolean useFPAPI) {
        boolean needsTextLayout;
        if (string == null || string.isEmpty()) {
            return 0.0f;
        }
        boolean bl = needsTextLayout = c != null && c.getClientProperty(TextAttribute.NUMERIC_SHAPING) != null;
        if (needsTextLayout) {
            Object object = charsBufferLock;
            synchronized (object) {
                int length = SwingUtilities2.syncCharsBuffer(string);
                needsTextLayout = SwingUtilities2.isComplexLayout(charsBuffer, 0, length);
            }
        }
        if (needsTextLayout) {
            TextLayout layout = SwingUtilities2.createTextLayout(c, string, fm.getFont(), fm.getFontRenderContext());
            return layout.getAdvance();
        }
        return SwingUtilities2.getFontStringWidth(string, fm, useFPAPI);
    }

    public static float getFontStringWidth(String data, FontMetrics fm, boolean useFPAPI) {
        if (useFPAPI) {
            Rectangle2D bounds = fm.getFont().getStringBounds(data, fm.getFontRenderContext());
            return (float)bounds.getWidth();
        }
        return fm.stringWidth(data);
    }

    private static TextLayout createTextLayout(JComponent c, String s, Font f, FontRenderContext frc) {
        Object shaper;
        Object object = shaper = c == null ? null : c.getClientProperty(TextAttribute.NUMERIC_SHAPING);
        if (shaper == null) {
            return new TextLayout(s, f, frc);
        }
        HashMap<TextAttribute, Object> a = new HashMap<TextAttribute, Object>();
        a.put(TextAttribute.FONT, f);
        a.put(TextAttribute.NUMERIC_SHAPING, shaper);
        return new TextLayout(s, a, frc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawString(JComponent c, Graphics g, String text, float x, float y, boolean useFPAPI) {
        if (text == null || text.length() <= 0) {
            return;
        }
        if (g instanceof Graphics2D) {
            Object aaHint;
            boolean needsTextLayout;
            Graphics2D g2 = (Graphics2D)g;
            boolean bl = needsTextLayout = c != null && c.getClientProperty(TextAttribute.NUMERIC_SHAPING) != null;
            if (needsTextLayout) {
                Object object = charsBufferLock;
                synchronized (object) {
                    int length = SwingUtilities2.syncCharsBuffer(text);
                    needsTextLayout = SwingUtilities2.isComplexLayout(charsBuffer, 0, length);
                }
            }
            Object object = aaHint = c == null ? null : c.getClientProperty(RenderingHints.KEY_TEXT_ANTIALIASING);
            if (aaHint != null) {
                Object oldContrast = null;
                Object oldAAValue = g2.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
                if (aaHint != oldAAValue) {
                    g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, aaHint);
                } else {
                    oldAAValue = null;
                }
                Object lcdContrastHint = c.getClientProperty(RenderingHints.KEY_TEXT_LCD_CONTRAST);
                if (lcdContrastHint != null) {
                    oldContrast = g2.getRenderingHint(RenderingHints.KEY_TEXT_LCD_CONTRAST);
                    if (lcdContrastHint.equals(oldContrast)) {
                        oldContrast = null;
                    } else {
                        g2.setRenderingHint(RenderingHints.KEY_TEXT_LCD_CONTRAST, lcdContrastHint);
                    }
                }
                if (needsTextLayout) {
                    TextLayout layout = SwingUtilities2.createTextLayout(c, text, g2.getFont(), g2.getFontRenderContext());
                    layout.draw(g2, x, y);
                } else {
                    g2.drawString(text, x, y);
                }
                if (oldAAValue != null) {
                    g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, oldAAValue);
                }
                if (oldContrast != null) {
                    g2.setRenderingHint(RenderingHints.KEY_TEXT_LCD_CONTRAST, oldContrast);
                }
                return;
            }
            if (needsTextLayout) {
                TextLayout layout = SwingUtilities2.createTextLayout(c, text, g2.getFont(), g2.getFontRenderContext());
                layout.draw(g2, x, y);
                return;
            }
        }
        g.drawString(text, (int)x, (int)y);
    }

    public static void drawStringUnderlineCharAt(JComponent c, Graphics g, String text, int underlinedIndex, int x, int y) {
        SwingUtilities2.drawStringUnderlineCharAt(c, g, text, underlinedIndex, x, y, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawStringUnderlineCharAt(JComponent c, Graphics g, String text, int underlinedIndex, float x, float y, boolean useFPAPI) {
        if (text == null || text.length() <= 0) {
            return;
        }
        SwingUtilities2.drawString(c, g, text, x, y, useFPAPI);
        int textLength = text.length();
        if (underlinedIndex >= 0 && underlinedIndex < textLength) {
            float underlineRectY = y;
            int underlineRectHeight = 1;
            float underlineRectX = 0.0f;
            int underlineRectWidth = 0;
            boolean needsTextLayout = false;
            if (!needsTextLayout) {
                Object object = charsBufferLock;
                synchronized (object) {
                    SwingUtilities2.syncCharsBuffer(text);
                    needsTextLayout = SwingUtilities2.isComplexLayout(charsBuffer, 0, textLength);
                }
            }
            if (!needsTextLayout) {
                FontMetrics fm = g.getFontMetrics();
                underlineRectX = x + (float)SwingUtilities2.stringWidth(c, fm, text.substring(0, underlinedIndex));
                underlineRectWidth = fm.charWidth(text.charAt(underlinedIndex));
            } else {
                Graphics2D g2d = SwingUtilities2.getGraphics2D(g);
                if (g2d != null) {
                    TextLayout layout = SwingUtilities2.createTextLayout(c, text, g2d.getFont(), g2d.getFontRenderContext());
                    TextHitInfo leading = TextHitInfo.leading(underlinedIndex);
                    TextHitInfo trailing = TextHitInfo.trailing(underlinedIndex);
                    Shape shape = layout.getVisualHighlightShape(leading, trailing);
                    Rectangle rect = shape.getBounds();
                    underlineRectX = x + (float)rect.x;
                    underlineRectWidth = rect.width;
                }
            }
            g.fillRect((int)underlineRectX, (int)underlineRectY + 1, underlineRectWidth, underlineRectHeight);
        }
    }

    public static Graphics2D getGraphics2D(Graphics g) {
        if (g instanceof Graphics2D) {
            return (Graphics2D)g;
        }
        return null;
    }

    public static FontRenderContext getFontRenderContext(Component c) {
        assert (c != null);
        if (c == null) {
            return DEFAULT_FRC;
        }
        return c.getFontMetrics(c.getFont()).getFontRenderContext();
    }
}

