/*
 * Decompiled with CFR 0.152.
 */
package processing.app.syntax;

import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.KeyStroke;
import processing.app.syntax.InputHandler;

public class DefaultInputHandler
extends InputHandler {
    private final Map<KeyStroke, ActionListener> bindings;

    public DefaultInputHandler() {
        this.bindings = new HashMap<KeyStroke, ActionListener>();
    }

    @Override
    public void addDefaultKeyBindings() {
        this.addKeyBinding("BACK_SPACE", BACKSPACE);
        this.addKeyBinding("C+BACK_SPACE", BACKSPACE_WORD);
        this.addKeyBinding("DELETE", DELETE);
        this.addKeyBinding("C+DELETE", DELETE_WORD);
        this.addKeyBinding("ENTER", INSERT_BREAK);
        this.addKeyBinding("TAB", INSERT_TAB);
        this.addKeyBinding("INSERT", OVERWRITE);
        this.addKeyBinding("HOME", HOME);
        this.addKeyBinding("END", END);
        this.addKeyBinding("S+HOME", SELECT_HOME);
        this.addKeyBinding("S+END", SELECT_END);
        this.addKeyBinding("C+HOME", DOCUMENT_HOME);
        this.addKeyBinding("C+END", DOCUMENT_END);
        this.addKeyBinding("CS+HOME", SELECT_DOC_HOME);
        this.addKeyBinding("CS+END", SELECT_DOC_END);
        this.addKeyBinding("PAGE_UP", PREV_PAGE);
        this.addKeyBinding("PAGE_DOWN", NEXT_PAGE);
        this.addKeyBinding("S+PAGE_UP", SELECT_PREV_PAGE);
        this.addKeyBinding("S+PAGE_DOWN", SELECT_NEXT_PAGE);
        this.addKeyBinding("LEFT", PREV_CHAR);
        this.addKeyBinding("S+LEFT", SELECT_PREV_CHAR);
        this.addKeyBinding("C+LEFT", PREV_WORD);
        this.addKeyBinding("CS+LEFT", SELECT_PREV_WORD);
        this.addKeyBinding("RIGHT", NEXT_CHAR);
        this.addKeyBinding("S+RIGHT", SELECT_NEXT_CHAR);
        this.addKeyBinding("C+RIGHT", NEXT_WORD);
        this.addKeyBinding("CS+RIGHT", SELECT_NEXT_WORD);
        this.addKeyBinding("UP", PREV_LINE);
        this.addKeyBinding("S+UP", SELECT_PREV_LINE);
        this.addKeyBinding("DOWN", NEXT_LINE);
        this.addKeyBinding("S+DOWN", SELECT_NEXT_LINE);
        this.addKeyBinding("C+ENTER", REPEAT);
    }

    @Override
    public void addKeyBinding(String keyBinding, ActionListener action) {
        KeyStroke keyStroke = DefaultInputHandler.parseKeyStroke(keyBinding);
        if (keyStroke != null) {
            this.bindings.put(keyStroke, action);
        }
    }

    @Override
    public void removeKeyBinding(String keyBinding) {
        throw new InternalError("Not yet implemented");
    }

    @Override
    public void removeAllKeyBindings() {
        this.bindings.clear();
    }

    @Override
    public InputHandler copy() {
        return new DefaultInputHandler(this);
    }

    @Override
    public void keyPressed(KeyEvent evt) {
        KeyStroke keyStroke;
        int keyCode = evt.getKeyCode();
        int modifiers = evt.getModifiersEx();
        modifiers &= 0xFFFFE3FF;
        if (keyCode == 17 || keyCode == 16 || keyCode == 18 || keyCode == 157) {
            return;
        }
        if ((modifiers & 0x100) != 0 && this.bindings.get(keyStroke = KeyStroke.getKeyStroke(keyCode, modifiers)) == null) {
            return;
        }
        if ((modifiers & 0xFFFFFFBF) != 0 || evt.isActionKey() || keyCode == 8 || keyCode == 127 || keyCode == 10 || keyCode == 9 || keyCode == 27) {
            if (this.grabAction != null) {
                this.handleGrabAction(evt);
                return;
            }
            keyStroke = KeyStroke.getKeyStroke(keyCode, modifiers);
            ActionListener o = this.bindings.get(keyStroke);
            if (o != null) {
                this.executeAction(o, evt.getSource(), null);
                evt.consume();
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent evt) {
        int modifiers = evt.getModifiersEx();
        char c = evt.getKeyChar();
        if ((modifiers & 0x100) != 0) {
            return;
        }
        if ((modifiers & 0x80) != 0 && c == '/') {
            return;
        }
        if (c != '\uffff' && c >= ' ' && c != '\u007f') {
            KeyStroke keyStroke = KeyStroke.getKeyStroke(Character.toUpperCase(c));
            ActionListener o = this.bindings.get(keyStroke);
            if (o != null) {
                this.executeAction(o, evt.getSource(), String.valueOf(c));
                return;
            }
            if (this.grabAction != null) {
                this.handleGrabAction(evt);
                return;
            }
            if (this.repeat && Character.isDigit(c)) {
                this.repeatCount *= 10;
                this.repeatCount += c - 48;
                return;
            }
            this.executeAction(INSERT_CHAR, evt.getSource(), String.valueOf(evt.getKeyChar()));
            this.repeatCount = 0;
            this.repeat = false;
        }
    }

    public static KeyStroke parseKeyStroke(String keyStroke) {
        String key;
        if (keyStroke == null) {
            return null;
        }
        int modifiers = 0;
        int index = keyStroke.indexOf(43);
        if (index != -1) {
            block8: for (int i = 0; i < index; ++i) {
                switch (Character.toUpperCase(keyStroke.charAt(i))) {
                    case 'A': {
                        modifiers |= 0x200;
                        continue block8;
                    }
                    case 'C': {
                        modifiers |= 0x80;
                        continue block8;
                    }
                    case 'M': {
                        modifiers |= 0x100;
                        continue block8;
                    }
                    case 'S': {
                        modifiers |= 0x40;
                    }
                }
            }
        }
        if ((key = keyStroke.substring(index + 1)).length() == 1) {
            char ch = Character.toUpperCase(key.charAt(0));
            if (modifiers == 0) {
                return KeyStroke.getKeyStroke(ch);
            }
            return KeyStroke.getKeyStroke((int)ch, modifiers);
        }
        if (key.length() == 0) {
            System.err.println("Invalid key stroke: " + keyStroke);
            return null;
        }
        try {
            int ch = KeyEvent.class.getField("VK_".concat(key)).getInt(null);
            return KeyStroke.getKeyStroke(ch, modifiers);
        }
        catch (Exception e) {
            System.err.println("Invalid key stroke: " + keyStroke);
            return null;
        }
    }

    private DefaultInputHandler(DefaultInputHandler copy) {
        this.bindings = copy.bindings;
    }
}

