/*
 * Decompiled with CFR 0.152.
 */
package processing.app.syntax;

import java.awt.Cursor;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.HashMap;
import java.util.Map;
import processing.app.laf.PdeScrollBarUI;
import processing.app.syntax.InputHandler;
import processing.app.syntax.JEditTextArea;
import processing.app.syntax.PdeTextAreaPainter;
import processing.app.syntax.TextAreaDefaults;
import processing.app.syntax.TextAreaPainter;
import processing.app.ui.Editor;
import processing.app.ui.Theme;

public class PdeTextArea
extends JEditTextArea {
    protected final Editor editor;
    protected Image gutterGradient;
    public static final String BREAK_MARKER = "<>";
    public static final String STEP_MARKER = "->";
    protected final Map<Integer, String> gutterText = new HashMap<Integer, String>();
    protected final MouseMotionAdapter gutterCursorMouseAdapter = new MouseMotionAdapter(){
        private int lastX;

        @Override
        public void mouseMoved(MouseEvent me) {
            if (me.getX() < Editor.LEFT_GUTTER) {
                if (this.lastX >= Editor.LEFT_GUTTER) {
                    PdeTextArea.this.painter.setCursor(new Cursor(0));
                }
            } else if (this.lastX < Editor.LEFT_GUTTER) {
                PdeTextArea.this.painter.setCursor(new Cursor(2));
            }
            this.lastX = me.getX();
        }
    };

    public PdeTextArea(TextAreaDefaults defaults, InputHandler inputHandler, Editor editor) {
        super(defaults, inputHandler);
        this.editor = editor;
        this.painter.addMouseMotionListener(this.gutterCursorMouseAdapter);
        this.updateTheme();
    }

    @Override
    protected TextAreaPainter createPainter(TextAreaDefaults defaults) {
        return new PdeTextAreaPainter(this, defaults);
    }

    public Image getGutterGradient() {
        return this.gutterGradient;
    }

    @Override
    public void updateTheme() {
        this.painter.updateTheme();
        this.gutterGradient = Theme.makeGradient("editor", Editor.LEFT_GUTTER, 500);
        if (this.vertical.getUI() instanceof PdeScrollBarUI) {
            ((PdeScrollBarUI)this.vertical.getUI()).updateTheme();
            ((PdeScrollBarUI)this.horizontal.getUI()).updateTheme();
        } else {
            this.vertical.setUI(new PdeScrollBarUI("editor.scrollbar"));
            this.horizontal.setUI(new PdeScrollBarUI("editor.scrollbar"));
        }
        this.repaint();
    }

    public void setGutterText(int lineIdx, String text) {
        this.gutterText.put(lineIdx, text);
        this.painter.invalidateLine(lineIdx);
    }

    public void clearGutterText(int lineIdx) {
        this.gutterText.remove(lineIdx);
        this.painter.invalidateLine(lineIdx);
    }

    public void clearGutterText() {
        for (int lineIdx : this.gutterText.keySet()) {
            this.painter.invalidateLine(lineIdx);
        }
        this.gutterText.clear();
    }

    public String getGutterText(int lineIdx) {
        return this.gutterText.get(lineIdx);
    }

    @Override
    public int _offsetToX(int line, int offset) {
        return super._offsetToX(line, offset) + Editor.LEFT_GUTTER;
    }

    @Override
    public int xToOffset(int line, int x) {
        return super.xToOffset(line, x - Editor.LEFT_GUTTER);
    }

    public Editor getEditor() {
        return this.editor;
    }
}

