/*
 * Decompiled with CFR 0.152.
 */
package processing.app.syntax;

import java.awt.Color;
import java.util.StringTokenizer;

public class SyntaxStyle {
    private final Color color;
    private final boolean bold;

    public SyntaxStyle(Color color, boolean bold) {
        this.color = color;
        this.bold = bold;
    }

    public static SyntaxStyle fromString(String str) {
        StringTokenizer st = new StringTokenizer(str, ",");
        String s = st.nextToken();
        if (s.indexOf("#") == 0) {
            s = s.substring(1);
        }
        Color color = new Color(Integer.parseInt(s, 16));
        s = st.nextToken();
        boolean bold = s.contains("bold");
        return new SyntaxStyle(color, bold);
    }

    public Color getColor() {
        return this.color;
    }

    public boolean isBold() {
        return this.bold;
    }

    public String toString() {
        return this.getClass().getName() + "[color=" + this.color + (this.bold ? ",bold" : "") + "]";
    }
}

