/*
 * Decompiled with CFR 0.152.
 */
package processing.app.tools;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintWriter;
import javax.swing.JOptionPane;
import processing.app.Base;
import processing.app.Language;
import processing.app.Messages;
import processing.app.Platform;
import processing.app.tools.Tool;
import processing.app.ui.Editor;
import processing.core.PApplet;
import processing.data.StringList;

public class InstallCommander
implements Tool {
    Base base;

    @Override
    public String getMenuTitle() {
        return Language.text("menu.tools.install_processing_java");
    }

    @Override
    public void init(Base base) {
        this.base = base;
    }

    @Override
    public void run() {
        try {
            Editor editor = this.base.getActiveEditor();
            String primary = "Install processing-java for all users?";
            String secondary = "This will install the processing-java program, which is capable of building and running Java Mode sketches from the command line. Click \u201cYes\u201d to install it for all users (an administrator password is required), or \u201cNo\u201d to place the program in your home directory. If you rename or move Processing.app, you'll need to reinstall the tool.";
            int result = JOptionPane.showConfirmDialog(editor, "<html> <head> <style type=\"text/css\">b { font: 13pt \"Lucida Grande\" }p { font: 11pt \"Lucida Grande\"; margin-top: 8px; width: 300px }</style> </head><b>Install processing-java for all users?</b><p>This will install the processing-java program, which is capable of building and running Java Mode sketches from the command line. Click \u201cYes\u201d to install it for all users (an administrator password is required), or \u201cNo\u201d to place the program in your home directory. If you rename or move Processing.app, you'll need to reinstall the tool.</p>", "Commander", 1, 3);
            if (result == 2) {
                return;
            }
            File file = File.createTempFile("processing", "commander");
            PrintWriter writer = PApplet.createWriter((File)file);
            writer.print("#!/bin/sh\n\n");
            writer.print("# Prevents processing-java from stealing focus, see:\n# https://github.com/processing/processing/issues/3996.\nOPTION_FOR_HEADLESS_RUN=\"\"\nfor ARG in \"$@\"\ndo\n    if [ \"$ARG\" = \"--build\" ]; then\n        OPTION_FOR_HEADLESS_RUN=\"-Djava.awt.headless=true\"\n    fi\ndone\n\n");
            String javaRoot = Platform.getContentFile(".").getCanonicalPath();
            StringList jarList = new StringList();
            InstallCommander.addJarList(jarList, new File(javaRoot));
            InstallCommander.addJarList(jarList, new File(javaRoot, "core/library"));
            InstallCommander.addJarList(jarList, new File(javaRoot, "modes/java/mode"));
            String classPath = jarList.join(":").replaceAll(javaRoot + "\\/?", "");
            writer.println("cd \"" + javaRoot + "\" && " + Platform.getJavaPath().replaceAll(" ", "\\\\ ") + " -Djna.nosys=true $OPTION_FOR_HEADLESS_RUN -cp \"" + classPath + "\" processing.mode.java.Commander \"$@\"");
            writer.flush();
            writer.close();
            file.setExecutable(true);
            String sourcePath = file.getAbsolutePath();
            if (result == 0) {
                String targetPath = "/usr/local/bin/processing-java";
                String oldPath = "/usr/bin/processing-java";
                String shellScript = "/bin/rm -f " + oldPath + " && /bin/mkdir -p /usr/local/bin && /bin/mv " + sourcePath + " " + targetPath;
                String appleScript = "do shell script \"" + shellScript + "\" with administrator privileges";
                PApplet.exec((String[])new String[]{"osascript", "-e", appleScript});
            } else if (result == 1) {
                File targetFile = new File(System.getProperty("user.home"), "processing-java");
                String targetPath = targetFile.getAbsolutePath();
                if (targetFile.exists()) {
                    Messages.showWarning("File Already Exists", "The processing-java program already exists at:\n" + targetPath + "\nPlease remove it and try again.");
                } else {
                    PApplet.exec((String[])new String[]{"mv", sourcePath, targetPath});
                }
            }
            editor.statusNotice("Finished.");
        }
        catch (IOException e) {
            Messages.showWarning("Error while installing", "An error occurred and the tool was not installed.", e);
        }
    }

    private static void addJarList(StringList list, File dir) {
        File[] jars;
        for (File jar : jars = dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase().endsWith(".jar") && !name.startsWith(".");
            }
        })) {
            list.append(jar.getAbsolutePath());
        }
    }
}

