/*
 * Decompiled with CFR 0.152.
 */
package processing.app.tools;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import processing.app.Base;
import processing.app.Messages;
import processing.app.Platform;
import processing.app.Preferences;
import processing.app.Util;
import processing.app.laf.PdeComboBoxUI;
import processing.app.tools.Tool;
import processing.app.ui.Editor;
import processing.app.ui.Theme;
import processing.app.ui.Toolkit;
import processing.core.PApplet;
import processing.data.StringDict;

public class ThemeSelector
extends JFrame
implements Tool {
    static final String HOWTO_URL = "https://github.com/processing/processing4/wiki/Themes";
    static final String ORDER_FILENAME = "order.txt";
    String miniSvgXml;
    List<ThemeSet> sets;
    String defaultTheme;
    File sketchbookFile;
    ThemeSet currentSet;
    int currentIndex;
    JComboBox<String> setSelector;
    ColorfulPanel selector;
    JLabel howtoLabel;
    JLabel reloadTheme;
    Base base;
    static final int ROW_H_GAP = 7;
    static final int ROW_V_GAP = 0;

    @Override
    public String getMenuTitle() {
        return "Theme Selector";
    }

    @Override
    public void init(final Base base) {
        this.base = base;
        try {
            File themeFolder = Theme.getThemeFolder();
            File[] setFolders = themeFolder.listFiles(file -> {
                if (file.isDirectory()) {
                    File orderFile = new File(file, ORDER_FILENAME);
                    return orderFile.exists();
                }
                return false;
            });
            if (setFolders == null) {
                Messages.showWarning("Could not load themes", "The themes directory could not be read.\nPlease reinstall Processing.");
                return;
            }
            File miniFile = new File(themeFolder, "mini.svg");
            this.miniSvgXml = Util.loadFile(miniFile);
            this.sets = new ArrayList<ThemeSet>();
            for (File folder : setFolders) {
                this.sets.add(new ThemeSet(folder));
            }
            this.currentSet = this.sets.get(0);
            this.defaultTheme = this.getDefaultTheme();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        Container pane = this.getContentPane();
        Box axis = Box.createVerticalBox();
        String[] setNames = new String[this.sets.size()];
        for (int i = 0; i < this.sets.size(); ++i) {
            setNames[i] = this.sets.get((int)i).name;
        }
        this.setSelector = new JComboBox<String>(setNames);
        this.setSelector.addItemListener(e -> {
            this.currentSet = this.sets.get(this.setSelector.getSelectedIndex());
            this.updateCurrentIndex();
            this.repaint();
        });
        ThemeSelector.addRow(axis, this.setSelector);
        axis.add(Box.createVerticalStrut(13));
        this.selector = new ColorfulPanel();
        axis.add(this.selector);
        axis.add(Box.createVerticalStrut(13));
        Component[] componentArray = new Component[1];
        this.howtoLabel = new JLabel();
        componentArray[0] = this.howtoLabel;
        ThemeSelector.addRow(axis, componentArray);
        this.howtoLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                Platform.openURL(ThemeSelector.HOWTO_URL);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                ThemeSelector.this.setCursor(Cursor.getPredefinedCursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                ThemeSelector.this.setCursor(Cursor.getPredefinedCursor(0));
            }
        });
        axis.add(Box.createVerticalStrut(6));
        Component[] componentArray2 = new Component[1];
        this.reloadTheme = new JLabel();
        componentArray2[0] = this.reloadTheme;
        ThemeSelector.addRow(axis, componentArray2);
        this.reloadTheme.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (!ThemeSelector.this.sketchbookFile.exists()) {
                    Theme.save();
                    ThemeSelector.this.updateTheme();
                } else {
                    ThemeSelector.this.reloadTheme();
                    Editor activeEditor = base.getActiveEditor();
                    if (activeEditor != null) {
                        activeEditor.statusNotice("Finished updating theme.");
                    }
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                ThemeSelector.this.setCursor(Cursor.getPredefinedCursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                ThemeSelector.this.setCursor(Cursor.getPredefinedCursor(0));
            }
        });
        axis.setBorder(new EmptyBorder(20, 20, 20, 20));
        pane.add(axis);
        Toolkit.registerWindowCloseKeys(this.getRootPane(), e -> this.setVisible(false));
        this.setTitle(this.getMenuTitle());
        this.setResizable(false);
        this.updateTheme();
        this.pack();
        this.setLocationRelativeTo(null);
    }

    private static void addRow(Container axis, Component ... components) {
        JPanel row = new JPanel(new FlowLayout(0, 7, 0));
        row.setOpaque(false);
        for (Component comp : components) {
            row.add(comp);
        }
        axis.add(row);
    }

    @Override
    public void run() {
        this.sketchbookFile = Theme.getSketchbookFile();
        this.updateTheme();
        this.updateCurrentIndex();
        this.setVisible(true);
    }

    private void updateTheme() {
        this.getContentPane().setBackground(Theme.getColor("theme_selector.window.color"));
        if (this.setSelector.getUI() instanceof PdeComboBoxUI) {
            ((PdeComboBoxUI)this.setSelector.getUI()).updateTheme();
        } else {
            this.setSelector.setUI(new PdeComboBoxUI("theme_selector.combo_box"));
        }
        String labelStyle = "body {   color: " + Theme.get("theme_selector.text.color") + ";} a {   color: " + Theme.get("theme_selector.link.color") + ";  text-decoration: none;}";
        String prefix = "<html><head><style type='text/css'>" + labelStyle + "</style></head><body>";
        this.howtoLabel.setText(prefix + "&rarr; <a href=\"\">Read</a> about how to create your own themes");
        if (Theme.getSketchbookFile().exists()) {
            this.reloadTheme.setText(prefix + "&rarr; <a href=\"\">Reload</a> theme.txt to update the current theme");
        } else {
            this.reloadTheme.setText(prefix + "&rarr; <a href=\"\">Save</a> theme.txt to sketchbook for editing");
        }
    }

    private String getCurrentTheme() {
        if (this.sketchbookFile.exists()) {
            return Util.loadFile(this.sketchbookFile);
        }
        return this.defaultTheme;
    }

    private String getDefaultTheme() {
        try {
            return Util.loadFile(Base.getLibFile("theme.txt"));
        }
        catch (IOException e) {
            e.printStackTrace();
            return this.sets.get((int)0).themes[0];
        }
    }

    private boolean userModifiedTheme() {
        if (!this.sketchbookFile.exists()) {
            return false;
        }
        String currentTheme = this.getCurrentTheme();
        for (ThemeSet set : this.sets) {
            if (set.getIndex(currentTheme) == -1) continue;
            return false;
        }
        return true;
    }

    private void setCurrentIndex(int index) {
        boolean success;
        this.currentIndex = index;
        if (this.userModifiedTheme() && !(success = Theme.archiveCurrent())) {
            Messages.showWarning("Could not back up theme", "Could not save a backup of theme.txt in your sketchbook folder.\nRename it manually and try setting the theme again.");
            return;
        }
        this.setSelector.repaint();
        Preferences.set("theme", this.currentSet.getPath(index));
        Preferences.save();
        this.reloadTheme();
    }

    private void reloadTheme() {
        Theme.reload();
        this.base.updateTheme();
        this.updateTheme();
    }

    private void updateCurrentIndex() {
        String currentTheme = this.getCurrentTheme();
        this.currentIndex = this.currentSet.getIndex(currentTheme);
    }

    class ThemeSet {
        final String name;
        private int count;
        private String[] paths;
        private String[] themes;
        private Image[] images;
        private Map<String, Integer> indices;

        ThemeSet(File dir) {
            this.name = dir.getName();
            File orderFile = new File(dir, ThemeSelector.ORDER_FILENAME);
            String[] lines = PApplet.loadStrings((File)orderFile);
            if (lines != null) {
                this.count = Math.min(16, lines.length);
                if (this.count < lines.length) {
                    System.err.println("Only using the first 16 themes inside " + orderFile);
                }
                this.paths = new String[this.count];
                this.themes = new String[this.count];
                this.images = new Image[this.count];
                this.indices = new HashMap<String, Integer>(this.count);
                for (int i = 0; i < this.count; ++i) {
                    String filename = lines[i] + ".txt";
                    File file = new File(dir, filename);
                    String theme = Util.loadFile(file);
                    this.indices.put(theme, i);
                    this.paths[i] = this.name + "/" + filename;
                    this.themes[i] = theme;
                    this.images[i] = this.renderImage(file.getName(), theme);
                }
            }
        }

        private Image renderImage(String filename, String theme) {
            StringDict entries = Util.readSettings(filename, PApplet.split((String)theme, (char)'\n'), true);
            StringDict replacements = new StringDict((String[][])new String[][]{{"#000000", entries.get("console.color")}, {"#111111", entries.get("editor.gutter.highlight.color")}, {"#222222", entries.get("footer.gradient.top")}, {"#444444", entries.get("mode.background.color")}, {"#555555", entries.get("toolbar.button.enabled.glyph")}, {"#666666", entries.get("editor.gradient.top")}, {"#777777", entries.get("editor.gradient.bottom")}, {"#888888", entries.get("toolbar.button.selected.field")}, {"#CCCCCC", entries.get("toolbar.button.enabled.field")}, {"#DDDDDD", entries.get("editor.line.highlight.color")}, {"#EEEEEE", entries.get("toolbar.button.selected.glyph")}, {"#FFFFFF", entries.get("editor.bgcolor")}});
            return Toolkit.svgToImageMult(ThemeSelector.this.miniSvgXml, 80, 80, replacements);
        }

        String getPath(int index) {
            return this.paths[index];
        }

        int getIndex(String theme) {
            return this.indices.getOrDefault(theme, -1);
        }
    }

    class ColorfulPanel
    extends JPanel {
        static final int OUTSET = 5;
        static final int OUTLINE = 3;
        static final int DIM = 80;
        static final int BETWEEN = 25;
        static final int EACH = 105;
        static final int MARGIN = 7;
        static final int SIZE = 409;

        ColorfulPanel() {
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    ColorfulPanel.this.handleMouse(e);
                }
            });
            this.addMouseMotionListener(new MouseMotionAdapter(){

                @Override
                public void mouseDragged(MouseEvent e) {
                    ColorfulPanel.this.handleMouse(e);
                }
            });
            this.setOpaque(false);
        }

        private void handleMouse(MouseEvent e) {
            int index;
            int col = this.constrain((e.getX() - 7) / 105);
            int colEx = this.constrain((e.getX() - 7) % 105);
            int row = this.constrain((e.getY() - 7) / 105);
            int rowEx = this.constrain((e.getY() - 7) % 105);
            if (colEx < 80 && rowEx < 80 && (index = row * 4 + col) < ThemeSelector.this.currentSet.count && index != ThemeSelector.this.currentIndex) {
                ThemeSelector.this.setCurrentIndex(index);
                this.repaint();
            }
        }

        private int constrain(int value) {
            return Math.max(0, Math.min(value, 3));
        }

        @Override
        public void paintComponent(Graphics g) {
            int row;
            int col;
            for (int i = 0; i < ThemeSelector.this.currentSet.count; ++i) {
                col = i % 4;
                row = i / 4;
                int x = 7 + col * 105;
                int y = 7 + row * 105;
                g.drawImage(ThemeSelector.this.currentSet.images[i], x, y, 80, 80, null);
            }
            Graphics2D g2 = (Graphics2D)g;
            g2.setStroke(new BasicStroke(3.0f));
            g2.setColor(Color.GRAY);
            if (ThemeSelector.this.currentIndex != -1) {
                col = ThemeSelector.this.currentIndex % 4;
                row = ThemeSelector.this.currentIndex / 4;
                g2.drawRect(7 + 105 * col - 5, 7 + 105 * row - 5, 90, 90);
            }
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(409, 409);
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }
    }
}

