/*
 * Decompiled with CFR 0.152.
 */
package processing.app.ui;

import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.font.FontRenderContext;
import java.awt.geom.Ellipse2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JPanel;
import processing.app.Mode;
import processing.app.Sketch;
import processing.app.contrib.ContributionManager;
import processing.app.ui.Editor;
import processing.app.ui.Theme;
import processing.app.ui.Toolkit;
import processing.data.StringDict;

public class EditorFooter
extends Box {
    static final int HIGH = Toolkit.zoom(32);
    static final int CURVE_RADIUS = Toolkit.zoom(6);
    static final int TAB_TOP = Toolkit.zoom(0);
    static final int TAB_BOTTOM = Toolkit.zoom(26);
    static final int TAB_BETWEEN = Toolkit.zoom(2);
    static final int MARGIN = Toolkit.zoom(8);
    static final int ICON_WIDTH = Toolkit.zoom(14);
    static final int ICON_HEIGHT = Toolkit.zoom(14);
    static final int ICON_TOP = Toolkit.zoom(5);
    static final int ICON_SIDE = Toolkit.zoom(7);
    static final int ENABLED = 0;
    static final int SELECTED = 1;
    Color[] textColor = new Color[2];
    Color[] tabColor = new Color[2];
    Editor editor;
    List<Tab> tabs = new ArrayList<Tab>();
    Font font;
    int fontAscent;
    Image gradient;
    Color bgColor;
    JPanel cardPanel;
    CardLayout cardLayout;
    Controller controller;
    int updateCount;

    public EditorFooter(Editor eddie) {
        super(1);
        this.editor = eddie;
        this.cardLayout = new CardLayout();
        this.cardPanel = new JPanel(this.cardLayout);
        this.add(this.cardPanel);
        this.controller = new Controller();
        this.add(this.controller);
        this.updateTheme();
    }

    public void addPanel(Component comp, String name) {
        this.addPanel(comp, name, null);
    }

    public void addPanel(Component comp, String name, String icon) {
        this.tabs.add(new Tab(comp, name, icon));
        this.cardPanel.add(name, comp);
    }

    public void setPanel(Component comp) {
        for (Tab tab : this.tabs) {
            if (tab.comp != comp) continue;
            this.cardLayout.show(this.cardPanel, tab.title);
            this.repaint();
        }
    }

    public void setNotification(Component comp, boolean note) {
        for (Tab tab : this.tabs) {
            if (tab.comp != comp) continue;
            tab.notification = note;
            this.repaint();
        }
    }

    public void setUpdateCount(int count) {
        this.updateCount = count;
        this.repaint();
    }

    public void updateTheme() {
        this.textColor[1] = Theme.getColor("footer.text.selected.color");
        this.textColor[0] = Theme.getColor("footer.text.enabled.color");
        this.font = Theme.getFont("footer.text.font");
        this.tabColor[1] = Theme.getColor("footer.tab.selected.color");
        this.tabColor[0] = Theme.getColor("footer.tab.enabled.color");
        this.gradient = Theme.makeGradient("footer", 400, HIGH);
        this.bgColor = Theme.getColor("footer.gradient.bottom");
        this.setBackground(this.bgColor);
        for (Tab tab : this.tabs) {
            tab.updateTheme();
        }
        this.controller.updateTheme();
    }

    class Controller
    extends JComponent {
        Color updatesTextColor;
        Color indicatorFieldColor;
        Color indicatorTextColor;
        int updateLeft;

        Controller() {
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    int x = e.getX();
                    for (Tab tab : EditorFooter.this.tabs) {
                        if (!tab.contains(x)) continue;
                        EditorFooter.this.cardLayout.show(EditorFooter.this.cardPanel, tab.title);
                        Controller.this.repaint();
                    }
                    if (EditorFooter.this.updateCount > 0 && x > Controller.this.updateLeft) {
                        ContributionManager.openUpdates();
                    }
                }
            });
        }

        void updateTheme() {
            this.updatesTextColor = Theme.getColor("footer.updates.text.color");
            this.indicatorFieldColor = Theme.getColor("footer.updates.indicator.field.color");
            this.indicatorTextColor = Theme.getColor("footer.updates.indicator.text.color");
            this.repaint();
        }

        @Override
        public void paintComponent(Graphics g) {
            if (g == null) {
                return;
            }
            Sketch sketch = EditorFooter.this.editor.getSketch();
            if (sketch == null) {
                return;
            }
            g.setFont(EditorFooter.this.font);
            if (EditorFooter.this.fontAscent == 0) {
                EditorFooter.this.fontAscent = (int)Toolkit.getAscent(g);
            }
            Graphics2D g2 = Toolkit.prepareGraphics(g);
            g.setColor(EditorFooter.this.tabColor[1]);
            g.drawImage(EditorFooter.this.gradient, 0, 0, this.getWidth(), this.getHeight(), this);
            for (Tab tab : EditorFooter.this.tabs) {
                tab.textWidth = (int)EditorFooter.this.font.getStringBounds(tab.title, g2.getFontRenderContext()).getWidth();
            }
            this.drawTabs(g2, Editor.LEFT_GUTTER);
            this.drawUpdates(g2);
        }

        private void drawTabs(Graphics2D g, int left) {
            int x = left;
            for (Tab tab : EditorFooter.this.tabs) {
                tab.left = x;
                x += MARGIN;
                if (tab.hasIcon()) {
                    x += ICON_WIDTH + MARGIN;
                }
                tab.right = x += tab.textWidth + MARGIN;
                tab.draw(g);
                x += TAB_BETWEEN;
            }
        }

        private void drawUpdates(Graphics2D g2) {
            if (EditorFooter.this.updateCount != 0) {
                FontRenderContext frc = g2.getFontRenderContext();
                int GAP = Toolkit.zoom(5);
                String updateLabel = "Updates";
                String updatesStr = " " + EditorFooter.this.updateCount + " ";
                double countWidth = EditorFooter.this.font.getStringBounds(updatesStr, frc).getWidth();
                double countHeight = EditorFooter.this.font.getStringBounds(updatesStr, frc).getHeight();
                if ((double)EditorFooter.this.fontAscent > countWidth) {
                    countWidth = EditorFooter.this.fontAscent;
                }
                float CIRCULAR_PADDING = 1.5f;
                float diameter = (float)(2.0 * (Math.max(countHeight, countWidth) / 2.0 + 1.5));
                float ex = (float)(this.getWidth() - Editor.RIGHT_GUTTER) - diameter;
                float ey = ((float)this.getHeight() - diameter) / 2.0f;
                g2.setColor(this.indicatorFieldColor);
                g2.fill(new Ellipse2D.Float(ex, ey, diameter, diameter));
                g2.setColor(this.indicatorTextColor);
                int baseline = (this.getHeight() + EditorFooter.this.fontAscent) / 2;
                g2.drawString(updatesStr, (int)((double)ex + ((double)diameter - countWidth) / 2.0), baseline);
                double updatesWidth = EditorFooter.this.font.getStringBounds("Updates", frc).getWidth();
                g2.setColor(this.updatesTextColor);
                this.updateLeft = (int)((double)ex - updatesWidth - (double)GAP);
                g2.drawString("Updates", this.updateLeft, baseline);
            }
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(Toolkit.zoom(300), HIGH);
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getMaximumSize() {
            return new Dimension(super.getMaximumSize().width, HIGH);
        }
    }

    class Tab {
        String title;
        String icon;
        Component comp;
        boolean notification;
        Image enabledIcon;
        Image selectedIcon;
        int left;
        int right;
        int textWidth;

        Tab(Component comp, String title, String icon) {
            this.comp = comp;
            this.title = title;
            this.icon = icon;
            this.updateTheme();
        }

        protected void updateTheme() {
            if (this.icon != null) {
                this.enabledIcon = this.renderImage("enabled");
                this.selectedIcon = this.renderImage("selected");
                if (this.selectedIcon == null) {
                    this.selectedIcon = this.enabledIcon;
                }
            }
        }

        protected Image renderImage(String state) {
            Mode mode = EditorFooter.this.editor.getMode();
            String xmlOrig = mode.loadString(this.icon + ".svg");
            if (xmlOrig == null) {
                return mode.loadImageX(this.icon + "-" + state);
            }
            StringDict replacements = new StringDict((String[][])new String[][]{{"silver", Theme.get("footer.icon." + state + ".color")}});
            return Toolkit.svgToImageMult(xmlOrig, ICON_WIDTH, ICON_HEIGHT, replacements);
        }

        boolean contains(int x) {
            return x >= this.left && x <= this.right;
        }

        boolean isCurrent() {
            return this.comp.isVisible();
        }

        int getTextLeft() {
            int links = this.left;
            if (this.enabledIcon != null) {
                links += ICON_WIDTH + ICON_SIDE;
            }
            return links + (this.right - links - this.textWidth) / 2;
        }

        boolean hasIcon() {
            return this.enabledIcon != null;
        }

        void draw(Graphics2D g2) {
            int state = this.isCurrent() ? 1 : 0;
            g2.setColor(EditorFooter.this.tabColor[state]);
            g2.fill(Toolkit.createRoundRect(this.left, TAB_TOP, this.right, TAB_BOTTOM, 0.0f, 0.0f, CURVE_RADIUS, CURVE_RADIUS));
            if (this.hasIcon()) {
                Image icon = this.isCurrent() || this.notification ? this.selectedIcon : this.enabledIcon;
                g2.drawImage(icon, this.left + MARGIN, ICON_TOP, ICON_WIDTH, ICON_HEIGHT, null);
            }
            int textLeft = this.getTextLeft();
            if (this.notification && state == 0) {
                g2.setColor(EditorFooter.this.textColor[1]);
            } else {
                g2.setColor(EditorFooter.this.textColor[state]);
            }
            int tabHeight = TAB_BOTTOM - TAB_TOP;
            int baseline = TAB_TOP + (tabHeight + EditorFooter.this.fontAscent) / 2;
            g2.drawString(this.title, textLeft, baseline);
        }
    }
}

