/*
 * Decompiled with CFR 0.152.
 */
package processing.app.ui;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.ImageIcon;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import processing.app.Platform;
import processing.app.Preferences;
import processing.app.ui.Editor;
import processing.app.ui.Theme;
import processing.app.ui.Toolkit;
import processing.core.PApplet;

public class EditorStatus
extends BasicSplitPaneDivider {
    static final int HIGH = Toolkit.zoom(28);
    static final int ICON_SIZE = Toolkit.zoom(16);
    static final int LEFT_MARGIN = Editor.LEFT_GUTTER;
    static final int RIGHT_MARGIN = Toolkit.zoom(20);
    Color[] fgColor;
    Color[] bgColor;
    public static final int ERROR = 1;
    public static final int CURSOR_LINE_ERROR = 2;
    public static final int WARNING = 3;
    public static final int CURSOR_LINE_WARNING = 4;
    public static final int NOTICE = 0;
    Editor editor;
    int mode;
    String message = "";
    int messageRight;
    String url;
    static final int NONE = 0;
    static final int URL_ROLLOVER = 1;
    static final int URL_PRESSED = 2;
    static final int COLLAPSE_ROLLOVER = 3;
    static final int COLLAPSE_PRESSED = 4;
    static final int CLIPBOARD_ROLLOVER = 5;
    static final int CLIPBOARD_PRESSED = 6;
    int mouseState;
    Font font;
    FontMetrics metrics;
    int ascent;
    boolean shiftDown;
    ImageIcon[] clipboardIcon;
    ImageIcon[] searchIcon;
    ImageIcon[] collapseIcon;
    ImageIcon[] expandIcon;
    float btnEnabledAlpha;
    float btnRolloverAlpha;
    float btnPressedAlpha;
    int urlEnabledAlpha;
    int urlRolloverAlpha;
    int urlPressedAlpha;
    int sizeW;
    int sizeH;
    int buttonEach;
    boolean collapsed = false;
    boolean indeterminate;
    Thread thread;

    public EditorStatus(BasicSplitPaneUI ui, Editor editor) {
        super(ui);
        this.editor = editor;
        this.empty();
        this.updateTheme();
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                EditorStatus.this.updateMouse(e, false);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                EditorStatus.this.updateMouse(e, true);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (EditorStatus.this.mouseState == 2) {
                    Platform.openURL(EditorStatus.this.url);
                } else if (EditorStatus.this.mouseState == 6) {
                    if (e.isShiftDown()) {
                        String fmt = Preferences.get("search.format");
                        Platform.openURL(String.format(fmt, PApplet.urlEncode((String)EditorStatus.this.message)));
                    } else {
                        Clipboard clipboard = EditorStatus.this.getToolkit().getSystemClipboard();
                        clipboard.setContents(new StringSelection(EditorStatus.this.message), null);
                        System.out.println("Copied to the clipboard. Use shift-click to search the web instead.");
                    }
                } else if (EditorStatus.this.mouseState == 4) {
                    EditorStatus.this.setCollapsed(!EditorStatus.this.collapsed);
                }
                EditorStatus.this.updateMouse(e, false);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                EditorStatus.this.updateMouse(null, false);
            }
        });
        this.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                EditorStatus.this.setCollapsed(false);
                EditorStatus.this.updateMouse(e, true);
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                EditorStatus.this.updateMouse(e, false);
            }
        });
        editor.getTextArea().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (EditorStatus.this.shiftDown != e.isShiftDown()) {
                    EditorStatus.this.shiftDown = e.isShiftDown();
                    EditorStatus.this.repaint();
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (EditorStatus.this.shiftDown != e.isShiftDown()) {
                    EditorStatus.this.shiftDown = e.isShiftDown();
                    EditorStatus.this.repaint();
                }
            }
        });
    }

    void setCollapsed(boolean newState) {
        if (this.collapsed != newState) {
            this.collapsed = newState;
            this.editor.footer.setVisible(!newState);
            this.splitPane.resetToPreferredSizes();
        }
    }

    void updateMouse(MouseEvent e, boolean pressed) {
        this.mouseState = 0;
        this.shiftDown = false;
        if (e != null) {
            int mouseX = e.getX();
            this.shiftDown = e.isShiftDown();
            if (mouseX > this.sizeW - this.buttonEach && mouseX < this.sizeW) {
                this.mouseState = pressed ? 4 : 3;
            } else if (this.message != null && !this.message.isEmpty()) {
                if (this.sizeW - 2 * this.buttonEach < mouseX) {
                    this.mouseState = pressed ? 6 : 5;
                } else if (this.url != null && mouseX > LEFT_MARGIN && mouseX < this.messageRight) {
                    this.mouseState = pressed ? 2 : 1;
                }
            }
        }
        switch (this.mouseState) {
            case 1: 
            case 5: {
                this.setCursor(Cursor.getPredefinedCursor(12));
                break;
            }
            case 3: {
                this.setCursor(Cursor.getPredefinedCursor(0));
                break;
            }
            case 0: {
                this.setCursor(Cursor.getPredefinedCursor(13));
            }
        }
        this.repaint();
    }

    static String findURL(String message) {
        String[] m = PApplet.match((String)message, (String)"http\\S+");
        if (m != null) {
            return m[0];
        }
        return null;
    }

    protected void updateTheme() {
        this.urlEnabledAlpha = 255 * Theme.getInteger("status.url.enabled.alpha") / 100;
        this.urlRolloverAlpha = 255 * Theme.getInteger("status.url.rollover.alpha") / 100;
        this.urlPressedAlpha = 255 * Theme.getInteger("status.url.pressed.alpha") / 100;
        String[] stateColors = new String[]{Theme.get("status.notice.fgcolor"), Theme.get("status.error.fgcolor"), Theme.get("status.error.fgcolor"), Theme.get("status.warning.fgcolor"), Theme.get("status.warning.fgcolor")};
        this.clipboardIcon = EditorStatus.renderIcons("status/copy-to-clipboard", stateColors);
        this.searchIcon = EditorStatus.renderIcons("status/search", stateColors);
        this.collapseIcon = EditorStatus.renderIcons("status/console-collapse", stateColors);
        this.expandIcon = EditorStatus.renderIcons("status/console-expand", stateColors);
        this.btnEnabledAlpha = (float)Theme.getInteger("status.button.enabled.alpha") / 100.0f;
        this.btnRolloverAlpha = (float)Theme.getInteger("status.button.rollover.alpha") / 100.0f;
        this.btnPressedAlpha = (float)Theme.getInteger("status.button.pressed.alpha") / 100.0f;
        this.fgColor = new Color[]{Theme.getColor("status.notice.fgcolor"), Theme.getColor("status.error.fgcolor"), Theme.getColor("status.error.fgcolor"), Theme.getColor("status.warning.fgcolor"), Theme.getColor("status.warning.fgcolor")};
        this.bgColor = new Color[]{Theme.getColor("status.notice.bgcolor"), Theme.getColor("status.error.bgcolor"), Theme.getColor("status.error.bgcolor"), Theme.getColor("status.warning.bgcolor"), Theme.getColor("status.warning.bgcolor")};
        this.font = Theme.getFont("status.font");
        this.metrics = null;
    }

    private static ImageIcon[] renderIcons(String path, String[] hexColors) {
        int count = hexColors.length;
        ImageIcon[] outgoing = new ImageIcon[count];
        for (int i = 0; i < count; ++i) {
            outgoing[i] = Toolkit.renderIcon(path, hexColors[i], ICON_SIZE);
        }
        return outgoing;
    }

    public void empty() {
        this.mode = 0;
        this.message = "";
        this.url = null;
        this.repaint();
    }

    public void message(String message, int mode) {
        this.message = message;
        this.mode = mode;
        this.url = EditorStatus.findURL(message);
        this.repaint();
    }

    public void notice(String message) {
        this.message(message, 0);
    }

    public void warning(String message) {
        this.message(message, 3);
    }

    public void error(String message) {
        this.message(message, 1);
    }

    public void startIndeterminate() {
        this.indeterminate = true;
        this.thread = new Thread("Editor Status"){

            @Override
            public void run() {
                while (Thread.currentThread() == EditorStatus.this.thread) {
                    EditorStatus.this.repaint();
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        };
        this.thread.start();
    }

    public void stopIndeterminate() {
        this.indeterminate = false;
        this.thread = null;
        this.repaint();
    }

    @Override
    public void paint(Graphics g) {
        Toolkit.prepareGraphics(g);
        this.sizeW = this.getWidth();
        this.buttonEach = this.sizeH = this.getHeight();
        g.setFont(this.font);
        if (this.metrics == null) {
            this.metrics = g.getFontMetrics();
            this.ascent = this.metrics.getAscent();
        }
        g.setColor(this.bgColor[this.mode]);
        g.fillRect(0, 0, this.sizeW, this.sizeH);
        this.messageRight = LEFT_MARGIN;
        if (this.message != null) {
            g.setFont(this.font);
            this.messageRight += g.getFontMetrics().stringWidth(this.message);
            int alpha = 255;
            if (this.url != null) {
                alpha = this.mouseState == 1 ? this.urlRolloverAlpha : (this.mouseState == 2 ? this.urlPressedAlpha : this.urlEnabledAlpha);
            }
            if (alpha == 255) {
                g.setColor(this.fgColor[this.mode]);
            } else {
                g.setColor(new Color(alpha << 24 | this.fgColor[this.mode].getRGB() & 0xFFFFFF, true));
            }
            g.drawString(this.message, LEFT_MARGIN, this.sizeH / 2 + this.ascent / 4 + 1);
        }
        if (this.indeterminate) {
            int w = Toolkit.getButtonWidth();
            int x = this.getWidth() - Math.max(RIGHT_MARGIN, (int)((double)this.buttonEach * 1.2)) - w;
            int y = this.sizeH / 3;
            int h = this.sizeH / 3;
            g.setColor(new Color(Integer.MIN_VALUE, true));
            g.drawRect(x, y, w, h);
            for (int i = 0; i < 10; ++i) {
                int r = (int)((double)x + Math.random() * (double)w);
                g.drawLine(r, y, r, y + h);
            }
        } else if (this.message != null && !this.message.isEmpty()) {
            ImageIcon glyph = this.shiftDown ? this.searchIcon[this.mode] : this.clipboardIcon[this.mode];
            float alpha = this.mouseState == 5 ? this.btnRolloverAlpha : (this.mouseState == 6 ? this.btnPressedAlpha : this.btnEnabledAlpha);
            this.drawButton(g, 1, glyph, alpha);
            g.setFont(this.font);
        }
        ImageIcon glyph = this.collapsed ? this.expandIcon[this.mode] : this.collapseIcon[this.mode];
        float alpha = this.mouseState == 3 ? this.btnRolloverAlpha : (this.mouseState == 4 ? this.btnPressedAlpha : this.btnEnabledAlpha);
        this.drawButton(g, 0, glyph, alpha);
    }

    private void drawButton(Graphics g, int pos, ImageIcon icon, float alpha) {
        int left = this.sizeW - (pos + 1) * this.buttonEach;
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setComposite(AlphaComposite.SrcAtop.derive(alpha));
        icon.paintIcon(this, g2, left + (this.buttonEach - icon.getIconWidth()) / 2, (this.buttonEach - icon.getIconHeight()) / 2);
        g2.dispose();
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(Toolkit.zoom(300), HIGH);
    }

    @Override
    public Dimension getMaximumSize() {
        return new Dimension(super.getMaximumSize().width, HIGH);
    }
}

