/*
 * Decompiled with CFR 0.152.
 */
package processing.app.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.DisplayMode;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import processing.app.Base;
import processing.app.Language;
import processing.app.Messages;
import processing.app.Platform;
import processing.app.Preferences;
import processing.app.SketchName;
import processing.app.ui.ColorChooser;
import processing.app.ui.Editor;
import processing.app.ui.Splash;
import processing.app.ui.Theme;
import processing.app.ui.Toolkit;
import processing.awt.ShimAWT;
import processing.core.PApplet;
import processing.data.StringList;

public class PreferencesFrame {
    JFrame frame;
    static final int ROW_H_GAP = 5;
    static final int ROW_V_GAP = 3;
    static final Integer[] FONT_SIZES = new Integer[]{10, 12, 14, 18, 24, 36, 48};
    JTextField sketchbookLocationField;
    JComboBox<String> namingSelectionBox;
    JTextField presentColor;
    JCheckBox memoryOverrideBox;
    JTextField memoryField;
    JCheckBox checkUpdatesBox;
    JComboBox<Integer> fontSizeField;
    JComboBox<Integer> consoleFontSizeField;
    JCheckBox inputMethodBox;
    JCheckBox autoAssociateBox;
    ColorChooser selector;
    JCheckBox errorCheckerBox;
    JCheckBox warningsCheckerBox;
    JCheckBox codeCompletionBox;
    JCheckBox importSuggestionsBox;
    JComboBox<String> zoomSelectionBox;
    JCheckBox zoomAutoBox;
    JCheckBox hidpiDisableBox;
    JCheckBox syncSketchNameBox;
    JComboBox<String> displaySelectionBox;
    JComboBox<String> languageSelectionBox;
    Map<String, String> languageToCode = new HashMap<String, String>();
    int displayCount;
    int defaultDisplayNum;
    String[] monoFontFamilies;
    JComboBox<String> fontSelectionBox;
    Map<String, Boolean> restartMap = new HashMap<String, Boolean>();
    JLabel restartLabel;
    JButton okButton;
    Base base;

    public PreferencesFrame(Base base) {
        JLabel preferencePathLabel;
        this.base = base;
        this.frame = new JFrame(Language.text("preferences"));
        Container pain = this.frame.getContentPane();
        JLabel sketchbookLocationLabel = new JLabel(Language.text("preferences.sketchbook_location"));
        this.sketchbookLocationField = new JTextField(25);
        JButton browseButton = new JButton(UIManager.getIcon("Tree.closedIcon"));
        browseButton.addActionListener(e -> {
            File defaultLocation = new File(this.sketchbookLocationField.getText());
            ShimAWT.selectFolder((String)Language.text("preferences.sketchbook_location.popup"), (String)"sketchbookCallback", (File)defaultLocation, (Object)this);
        });
        this.sketchbookLocationField.putClientProperty("JTextField.trailingComponent", browseButton);
        JLabel namingLabel = new JLabel(Language.text("preferences.sketch_naming"));
        this.namingSelectionBox = new JComboBox<String>(SketchName.getOptions());
        JLabel languageLabel = new JLabel(Language.text("preferences.language"));
        this.languageSelectionBox = new JComboBox();
        Map<String, String> languages = Language.getLanguages();
        String[] languageSelection = new String[languages.size()];
        StringList codeList = new StringList(languages.keySet());
        for (String code : codeList) {
            this.languageToCode.put(languages.get(code), code);
        }
        String currentCode = Language.getLanguage();
        languageSelection[0] = languages.get(currentCode);
        codeList.removeValue(currentCode);
        codeList.sort();
        int i = 1;
        for (String code : codeList) {
            languageSelection[i++] = languages.get(code);
        }
        this.languageSelectionBox.setModel(new DefaultComboBoxModel<String>(languageSelection));
        this.languageSelectionBox.addItemListener(e -> this.updateRestart("language", this.languageSelectionBox.getSelectedIndex() != 0));
        this.languageSelectionBox.setRenderer(new LanguageRenderer());
        JLabel fontLabel = new JLabel(Language.text("preferences.editor_and_console_font"));
        String fontTip = "<html>" + Language.text("preferences.editor_and_console_font.tip");
        fontLabel.setToolTipText(fontTip);
        this.fontSelectionBox = new JComboBox<String>(new String[]{Toolkit.getMonoFontName()});
        this.fontSelectionBox.setToolTipText(fontTip);
        this.fontSelectionBox.setEnabled(false);
        JLabel fontSizeLabel = new JLabel(Language.text("preferences.editor_font_size"));
        this.fontSizeField = new JComboBox<Integer>(FONT_SIZES);
        this.fontSizeField.setSelectedItem(Preferences.getInteger("editor.font.size"));
        JLabel consoleFontSizeLabel = new JLabel(Language.text("preferences.console_font_size"));
        this.consoleFontSizeField = new JComboBox<Integer>(FONT_SIZES);
        this.consoleFontSizeField.setSelectedItem(Preferences.getInteger("console.font.size"));
        this.fontSizeField.setEditable(true);
        this.consoleFontSizeField.setEditable(true);
        JLabel zoomLabel = new JLabel(Language.text("preferences.interface_scale"));
        this.zoomAutoBox = new JCheckBox(Language.text("preferences.interface_scale.auto"));
        this.zoomAutoBox.addChangeListener(e -> {
            this.zoomSelectionBox.setEnabled(!this.zoomAutoBox.isSelected());
            this.updateZoomRestartRequired();
        });
        this.zoomSelectionBox = new JComboBox();
        this.zoomSelectionBox.setModel(new DefaultComboBoxModel<String>(Toolkit.zoomOptions.toArray()));
        this.zoomSelectionBox.addActionListener(e -> this.updateZoomRestartRequired());
        this.hidpiDisableBox = new JCheckBox("Disable HiDPI Scaling");
        this.hidpiDisableBox.addChangeListener(e -> this.updateRestart("hidpi", this.hidpiDisableBox.isSelected() != Splash.getDisableHiDPI()));
        this.syncSketchNameBox = new JCheckBox("Keep sketch name and main tab in sync");
        this.syncSketchNameBox.setToolTipText("<html>This removes the requirement for the sketch name to be<br>the same as the main tab, which makes it easier to use<br>Processing sketches with version control systems like Git.<br>This is experimental: save often and report any issues!");
        JLabel backgroundColorLabel = new JLabel(Language.text("preferences.background_color"));
        String colorTip = "<html>" + Language.text("preferences.background_color.tip");
        backgroundColorLabel.setToolTipText(colorTip);
        this.presentColor = new JTextField("      ");
        this.presentColor.setOpaque(true);
        this.presentColor.setEnabled(true);
        this.presentColor.setEditable(false);
        CompoundBorder cb = new CompoundBorder(BorderFactory.createMatteBorder(1, 1, 0, 0, new Color(195, 195, 195)), BorderFactory.createMatteBorder(0, 0, 1, 1, new Color(54, 54, 54)));
        this.presentColor.setBorder(cb);
        this.presentColor.setBackground(Preferences.getColor("run.present.bgcolor"));
        this.selector = new ColorChooser(this.frame, false, Preferences.getColor("run.present.bgcolor"), Language.text("prompt.ok"), e -> {
            String colorValue = this.selector.getHexColor().substring(1);
            this.presentColor.setBackground(new Color(PApplet.unhex((String)colorValue)));
            this.selector.hide();
        });
        this.presentColor.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e) {
                PreferencesFrame.this.frame.setCursor(Cursor.getPredefinedCursor(0));
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                PreferencesFrame.this.frame.setCursor(Cursor.getPredefinedCursor(12));
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                PreferencesFrame.this.selector.show();
            }
        });
        this.inputMethodBox = new JCheckBox(Language.text("preferences.enable_complex_text"));
        this.inputMethodBox.setToolTipText("<html>" + Language.text("preferences.enable_complex_text.tip"));
        this.inputMethodBox.addChangeListener(e -> this.updateRestart("input_method", this.inputMethodBox.isSelected() != Preferences.getBoolean("editor.input_method_support")));
        this.errorCheckerBox = new JCheckBox(Language.text("preferences.continuously_check"));
        this.errorCheckerBox.addItemListener(e -> this.warningsCheckerBox.setEnabled(this.errorCheckerBox.isSelected()));
        this.warningsCheckerBox = new JCheckBox(Language.text("preferences.show_warnings"));
        this.codeCompletionBox = new JCheckBox(Language.text("preferences.code_completion") + " Ctrl-" + Language.text("preferences.cmd_space"));
        this.importSuggestionsBox = new JCheckBox(Language.text("preferences.suggest_imports"));
        this.memoryOverrideBox = new JCheckBox(Language.text("preferences.increase_max_memory"));
        this.memoryField = new JTextField(4);
        this.memoryOverrideBox.addChangeListener(e -> this.memoryField.setEnabled(this.memoryOverrideBox.isSelected()));
        JLabel mbLabel = new JLabel("MB");
        this.checkUpdatesBox = new JCheckBox(Language.text("preferences.check_for_updates_on_startup"));
        JLabel displayLabel = new JLabel(Language.text("preferences.run_sketches_on_display"));
        String tip = "<html>" + Language.text("preferences.run_sketches_on_display.tip");
        displayLabel.setToolTipText(tip);
        this.displaySelectionBox = new JComboBox();
        this.updateDisplayList();
        this.autoAssociateBox = new JCheckBox(Language.text("preferences.automatically_associate_pde_files"));
        final JLabel morePreferenceLabel = new JLabel(Language.text("preferences.file"));
        morePreferenceLabel.setForeground(UIManager.getColor("Label.disabledForeground"));
        morePreferenceLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                Platform.openURL("https://github.com/processing/processing4/wiki/Preferences");
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                PreferencesFrame.this.frame.setCursor(Cursor.getPredefinedCursor(12));
                morePreferenceLabel.setForeground(Theme.getColor("laf.accent.color"));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                PreferencesFrame.this.frame.setCursor(Cursor.getPredefinedCursor(0));
                morePreferenceLabel.setForeground(UIManager.getColor("Label.disabledForeground"));
            }
        });
        final JLabel clickable = preferencePathLabel = new JLabel(Preferences.getPreferencesPath());
        preferencePathLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                Platform.openFolder(Base.getSettingsFolder());
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                PreferencesFrame.this.frame.setCursor(Cursor.getPredefinedCursor(12));
                clickable.setForeground(Theme.getColor("laf.accent.color"));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                PreferencesFrame.this.frame.setCursor(Cursor.getPredefinedCursor(0));
                clickable.setForeground(UIManager.getColor("Label.foreground"));
            }
        });
        JLabel preferenceHintLabel = new JLabel(Language.text("preferences.file.hint"));
        preferenceHintLabel.setEnabled(false);
        this.restartLabel = new JLabel(Language.text("preferences.restart_required"));
        this.okButton = new JButton(Language.getPrompt("ok"));
        this.okButton.addActionListener(e -> {
            this.applyFrame();
            this.disposeFrame();
        });
        JButton cancelButton = new JButton(Language.getPrompt("cancel"));
        cancelButton.addActionListener(e -> this.disposeFrame());
        Box axis = Box.createVerticalBox();
        PreferencesFrame.addRow(axis, sketchbookLocationLabel, this.sketchbookLocationField);
        PreferencesFrame.addRow(axis, namingLabel, this.namingSelectionBox);
        JPanel layoutPanel = new JPanel();
        layoutPanel.setBorder(new TitledBorder("Interface and Fonts"));
        layoutPanel.setLayout(new BoxLayout(layoutPanel, 1));
        PreferencesFrame.addRow(layoutPanel, fontLabel, this.fontSelectionBox);
        PreferencesFrame.addRow(layoutPanel, fontSizeLabel, this.fontSizeField, consoleFontSizeLabel, this.consoleFontSizeField);
        PreferencesFrame.addRow(layoutPanel, zoomLabel, this.zoomAutoBox, this.zoomSelectionBox);
        if (Platform.isWindows()) {
            PreferencesFrame.addRow(layoutPanel, this.hidpiDisableBox);
        }
        axis.add(layoutPanel);
        PreferencesFrame.addRow(layoutPanel, languageLabel, this.languageSelectionBox, this.inputMethodBox);
        JPanel codingPanel = new JPanel();
        codingPanel.setBorder(new TitledBorder("Coding"));
        codingPanel.setLayout(new BoxLayout(codingPanel, 1));
        PreferencesFrame.addRow(codingPanel, this.errorCheckerBox, this.warningsCheckerBox);
        PreferencesFrame.addRow(codingPanel, this.codeCompletionBox, this.importSuggestionsBox);
        axis.add(codingPanel);
        JPanel runningPanel = new JPanel();
        runningPanel.setBorder(new TitledBorder("Running"));
        runningPanel.setLayout(new BoxLayout(runningPanel, 1));
        PreferencesFrame.addRow(runningPanel, displayLabel, this.displaySelectionBox);
        PreferencesFrame.addRow(runningPanel, backgroundColorLabel, this.presentColor);
        PreferencesFrame.addRow(runningPanel, this.memoryOverrideBox, this.memoryField, mbLabel);
        axis.add(runningPanel);
        PreferencesFrame.addRow(axis, this.checkUpdatesBox);
        PreferencesFrame.addRow(axis, this.syncSketchNameBox);
        if (Platform.isWindows()) {
            PreferencesFrame.addRow(axis, this.autoAssociateBox);
        }
        Box blurb = Box.createVerticalBox();
        blurb.add(morePreferenceLabel);
        blurb.add(preferencePathLabel);
        blurb.add(preferenceHintLabel);
        PreferencesFrame.addRow(axis, blurb);
        Box row = Box.createHorizontalBox();
        row.add(Box.createHorizontalStrut(5));
        row.add(this.restartLabel);
        row.add(Box.createHorizontalGlue());
        row.add(this.okButton);
        row.add(Box.createHorizontalStrut(5));
        row.add(cancelButton);
        axis.add(row);
        axis.setBorder(new EmptyBorder(13, 13, 13, 13));
        pain.add(axis);
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                PreferencesFrame.this.disposeFrame();
            }
        });
        ActionListener disposer = actionEvent -> this.disposeFrame();
        Toolkit.registerWindowCloseKeys(this.frame.getRootPane(), disposer);
        this.updateTheme();
        Toolkit.setIcon(this.frame);
        this.frame.setResizable(false);
        this.frame.pack();
        this.frame.setLocationRelativeTo(null);
        pain.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                KeyStroke wc = Toolkit.WINDOW_CLOSE_KEYSTROKE;
                if (e.getKeyCode() == 27 || KeyStroke.getKeyStrokeForEvent(e).equals(wc)) {
                    PreferencesFrame.this.disposeFrame();
                }
            }
        });
    }

    private static void addRow(Container axis, Component ... components) {
        JPanel row = new JPanel(new FlowLayout(0, 5, 3));
        for (Component comp : components) {
            row.add(comp);
        }
        axis.add(row);
    }

    private void updateRestart(String key, boolean value) {
        this.restartMap.put(key, value);
        this.restartLabel.setVisible(this.restartMap.containsValue(true));
    }

    private void updateZoomRestartRequired() {
        this.updateRestart("zoom", this.zoomAutoBox.isSelected() != Preferences.getBoolean("editor.zoom.auto") || !Preferences.get("editor.zoom").equals(String.valueOf(this.zoomSelectionBox.getSelectedItem())));
    }

    public void sketchbookCallback(File file) {
        if (file != null) {
            this.sketchbookLocationField.setText(file.getAbsolutePath());
        }
    }

    protected void disposeFrame() {
        this.frame.dispose();
    }

    protected void applyFrame() {
        Object selection;
        String oldPath = Preferences.getSketchbookPath();
        String newPath = this.sketchbookLocationField.getText();
        if (!newPath.equals(oldPath)) {
            this.base.setSketchbookFolder(new File(newPath));
        }
        Preferences.set("sketch.name.approach", (String)this.namingSelectionBox.getSelectedItem());
        Preferences.setBoolean("update.check", this.checkUpdatesBox.isSelected());
        if (this.languageSelectionBox.getSelectedIndex() != 0) {
            Language.saveLanguage(this.languageToCode.get((String)this.languageSelectionBox.getSelectedItem()));
        }
        if (this.displaySelectionBox.isEnabled()) {
            int oldDisplayNum = Preferences.getInteger("run.display");
            int displayNum = -1;
            for (int d = 0; d < this.displaySelectionBox.getItemCount(); ++d) {
                if (this.displaySelectionBox.getSelectedIndex() != d) continue;
                displayNum = d == this.defaultDisplayNum - 1 ? -1 : d + 1;
            }
            if (displayNum != oldDisplayNum) {
                Preferences.setInteger("run.display", displayNum);
                for (Editor editor : this.base.getEditors()) {
                    editor.setSketchLocation(null);
                }
            }
        }
        Preferences.setBoolean("run.options.memory", this.memoryOverrideBox.isSelected());
        int memoryMin = Preferences.getInteger("run.options.memory.initial");
        int memoryMax = Preferences.getInteger("run.options.memory.maximum");
        try {
            memoryMax = Integer.parseInt(this.memoryField.getText().trim());
            if (memoryMax < memoryMin) {
                memoryMax = memoryMin;
            }
            Preferences.setInteger("run.options.memory.maximum", memoryMax);
        }
        catch (NumberFormatException e) {
            System.err.println("Ignoring bad memory setting");
        }
        if (this.fontSelectionBox.isEnabled()) {
            String fontFamily = (String)this.fontSelectionBox.getSelectedItem();
            if (Toolkit.getMonoFontName().equals(fontFamily)) {
                fontFamily = "processing.mono";
            }
            Preferences.set("editor.font.family", fontFamily);
        }
        try {
            selection = this.fontSizeField.getSelectedItem();
            if (selection instanceof String) {
                selection = Integer.parseInt((String)selection);
            }
            Preferences.set("editor.font.size", String.valueOf(selection));
        }
        catch (NumberFormatException e) {
            Messages.log("Ignoring invalid font size " + this.fontSizeField);
            this.fontSizeField.setSelectedItem(Preferences.getInteger("editor.font.size"));
        }
        try {
            selection = this.consoleFontSizeField.getSelectedItem();
            if (selection instanceof String) {
                selection = Integer.parseInt((String)selection);
            }
            Preferences.set("console.font.size", String.valueOf(selection));
        }
        catch (NumberFormatException e) {
            Messages.log("Ignoring invalid font size " + this.consoleFontSizeField);
            this.consoleFontSizeField.setSelectedItem(Preferences.getInteger("console.font.size"));
        }
        Preferences.setBoolean("editor.zoom.auto", this.zoomAutoBox.isSelected());
        Preferences.set("editor.zoom", String.valueOf(this.zoomSelectionBox.getSelectedItem()));
        if (Platform.isWindows()) {
            Splash.setDisableHiDPI(this.hidpiDisableBox.isSelected());
        }
        Preferences.setBoolean("editor.sync_folder_and_filename", this.syncSketchNameBox.isSelected());
        Preferences.setColor("run.present.bgcolor", this.presentColor.getBackground());
        Preferences.setBoolean("editor.input_method_support", this.inputMethodBox.isSelected());
        if (this.autoAssociateBox != null) {
            Preferences.setBoolean("platform.auto_file_type_associations", this.autoAssociateBox.isSelected());
        }
        Preferences.setBoolean("pdex.errorCheckEnabled", this.errorCheckerBox.isSelected());
        Preferences.setBoolean("pdex.warningsEnabled", this.warningsCheckerBox.isSelected());
        Preferences.setBoolean("pdex.completion", this.codeCompletionBox.isSelected());
        Preferences.setBoolean("pdex.suggest.imports", this.importSuggestionsBox.isSelected());
        for (Editor editor : this.base.getEditors()) {
            editor.applyPreferences();
        }
        Preferences.save();
    }

    public void showFrame() {
        String zoomSel;
        int zoomIndex;
        this.inputMethodBox.setSelected(Preferences.getBoolean("editor.input_method_support"));
        this.errorCheckerBox.setSelected(Preferences.getBoolean("pdex.errorCheckEnabled"));
        this.warningsCheckerBox.setSelected(Preferences.getBoolean("pdex.warningsEnabled"));
        this.warningsCheckerBox.setEnabled(this.errorCheckerBox.isSelected());
        this.codeCompletionBox.setSelected(Preferences.getBoolean("pdex.completion"));
        this.importSuggestionsBox.setSelected(Preferences.getBoolean("pdex.suggest.imports"));
        this.sketchbookLocationField.setText(Preferences.getSketchbookPath());
        this.namingSelectionBox.setSelectedItem(Preferences.get("sketch.name.approach"));
        if (this.namingSelectionBox.getSelectedIndex() < 0) {
            this.namingSelectionBox.setSelectedItem("Classic (sketch_220809a)");
            Preferences.set("sketch.name.approach", "Classic (sketch_220809a)");
        }
        this.checkUpdatesBox.setSelected(Preferences.getBoolean("update.check"));
        this.defaultDisplayNum = this.updateDisplayList();
        int displayNum = Preferences.getInteger("run.display");
        if (displayNum < 1 || displayNum > this.displayCount) {
            displayNum = this.defaultDisplayNum;
        }
        this.displaySelectionBox.setSelectedIndex(displayNum - 1);
        new Thread(this::initFontList).start();
        this.fontSizeField.setSelectedItem(Preferences.getInteger("editor.font.size"));
        this.consoleFontSizeField.setSelectedItem(Preferences.getInteger("console.font.size"));
        boolean zoomAuto = Preferences.getBoolean("editor.zoom.auto");
        if (zoomAuto) {
            this.zoomAutoBox.setSelected(true);
            this.zoomSelectionBox.setEnabled(false);
        }
        if ((zoomIndex = Toolkit.zoomOptions.index(zoomSel = Preferences.get("editor.zoom"))) != -1) {
            this.zoomSelectionBox.setSelectedIndex(zoomIndex);
        } else {
            this.zoomSelectionBox.setSelectedIndex(0);
        }
        if (Platform.isWindows()) {
            this.hidpiDisableBox.setSelected(Splash.getDisableHiDPI());
        }
        this.syncSketchNameBox.setSelected(Preferences.getBoolean("editor.sync_folder_and_filename"));
        this.presentColor.setBackground(Preferences.getColor("run.present.bgcolor"));
        this.memoryOverrideBox.setSelected(Preferences.getBoolean("run.options.memory"));
        this.memoryField.setText(Preferences.get("run.options.memory.maximum"));
        this.memoryField.setEnabled(this.memoryOverrideBox.isSelected());
        if (this.autoAssociateBox != null) {
            this.autoAssociateBox.setSelected(Preferences.getBoolean("platform.auto_file_type_associations"));
        }
        this.frame.getRootPane().setDefaultButton(this.okButton);
        this.sketchbookLocationField.select(0, 0);
        this.okButton.requestFocusInWindow();
        this.frame.pack();
        this.frame.setVisible(true);
    }

    public void updateTheme() {
        SwingUtilities.updateComponentTreeUI(this.frame);
        this.restartLabel.setForeground(Theme.getColor("laf.accent.color"));
    }

    void initFontList() {
        if (this.monoFontFamilies == null) {
            this.monoFontFamilies = Toolkit.getMonoFontFamilies();
            EventQueue.invokeLater(() -> {
                this.fontSelectionBox.setModel(new DefaultComboBoxModel<String>(this.monoFontFamilies));
                String family = Preferences.get("editor.font.family");
                String defaultName = Toolkit.getMonoFontName();
                if ("processing.mono".equals(family)) {
                    family = defaultName;
                }
                this.fontSelectionBox.setSelectedItem(defaultName);
                this.fontSelectionBox.setSelectedItem(family);
                this.fontSelectionBox.setEnabled(true);
            });
        }
    }

    int updateDisplayList() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice defaultDevice = ge.getDefaultScreenDevice();
        GraphicsDevice[] devices = ge.getScreenDevices();
        int defaultNum = -1;
        this.displayCount = devices.length;
        String[] items = new String[this.displayCount];
        for (int i = 0; i < this.displayCount; ++i) {
            DisplayMode mode = devices[i].getDisplayMode();
            Object title = String.format("%d (%d \u00d7 %d)", i + 1, mode.getWidth(), mode.getHeight());
            if (devices[i] == defaultDevice) {
                title = (String)title + " default";
                defaultNum = i + 1;
            }
            items[i] = title;
        }
        this.displaySelectionBox.setModel(new DefaultComboBoxModel<String>(items));
        this.displaySelectionBox.setEnabled(this.displayCount != 1);
        return defaultNum;
    }

    class LanguageRenderer
    extends JLabel
    implements ListCellRenderer<String> {
        final int fontSize;
        final Font sansFont;
        final Font fallbackFont;

        LanguageRenderer() {
            this.fontSize = PreferencesFrame.this.languageSelectionBox.getFont().getSize();
            this.sansFont = Toolkit.getSansFont(this.fontSize, 0);
            this.fallbackFont = new Font("Dialog", 0, this.fontSize);
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends String> list, String text, int index, boolean isSelected, boolean cellHasFocus) {
            if (this.sansFont.canDisplayUpTo(text) == -1) {
                this.setFont(this.sansFont);
            } else {
                this.setFont(this.fallbackFont);
            }
            this.setText(text);
            return this;
        }
    }
}

