/*
 * Decompiled with CFR 0.152.
 */
package processing.app.ui;

import java.awt.Color;
import java.awt.Font;
import java.awt.Image;
import java.awt.SystemColor;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import processing.app.Base;
import processing.app.Messages;
import processing.app.Preferences;
import processing.app.Settings;
import processing.app.syntax.SyntaxStyle;
import processing.core.PApplet;

public class Theme {
    static final String DEFAULT_PATH = "Minerals/kyanite.txt";
    static Settings theme;
    static final double REF_X = 95.047;
    static final double REF_Y = 100.0;
    static final double REF_Z = 108.883;

    public static void init() {
        try {
            File inputFile = Theme.getDefaultFile();
            if (!inputFile.exists()) {
                System.err.println("Missing required file (theme.txt), please reinstall Processing.");
            }
            theme = new Settings(inputFile);
            theme.setColor("run.window.bgcolor", SystemColor.control);
            if (Preferences.get("theme") == null) {
                Preferences.set("theme", DEFAULT_PATH);
                if (Theme.getSketchbookFile().exists()) {
                    Theme.archiveCurrent();
                }
            }
            Theme.reload();
        }
        catch (IOException e) {
            Messages.showError("Problem loading theme.txt", "Could not load theme.txt, please re-install Processing", e);
        }
    }

    public static void reload() {
        if (!Theme.loadSketchbookFile()) {
            String prefTheme = Preferences.get("theme");
            try {
                File prefFile = new File(Theme.getThemeFolder(), prefTheme);
                if (prefFile.exists()) {
                    theme.load(prefFile);
                }
            }
            catch (IOException e) {
                Messages.showWarning("Theme Reload Problem", "Error while reloading the theme. Please report.", e);
            }
        }
    }

    public static boolean loadSketchbookFile() {
        File sketchbookTheme = Theme.getSketchbookFile();
        if (sketchbookTheme.exists()) {
            theme.load(sketchbookTheme);
            return true;
        }
        return false;
    }

    public static void save() {
        theme.save(Theme.getSketchbookFile());
    }

    public static File getThemeFolder() throws IOException {
        return Base.getLibFile("theme");
    }

    public static File getDefaultFile() throws IOException {
        return new File(Theme.getThemeFolder(), "theme.txt");
    }

    public static File getSketchbookFile() {
        return new File(Base.getSketchbookFolder(), "theme.txt");
    }

    public static boolean archiveCurrent() {
        File backupFile = Theme.nextArchiveFile();
        return Theme.getSketchbookFile().renameTo(backupFile);
    }

    private static File nextArchiveFile() {
        File backupFile;
        int index = 0;
        while ((backupFile = new File(Base.getSketchbookFolder(), String.format("theme.%03d", ++index))).exists()) {
        }
        return backupFile;
    }

    public static void print() {
        theme.print();
    }

    public static String get(String attribute) {
        return theme.get(attribute);
    }

    public static boolean getBoolean(String attribute) {
        return theme.getBoolean(attribute);
    }

    public static int getInteger(String attribute) {
        return theme.getInteger(attribute);
    }

    public static Color getColor(String attribute) {
        return theme.getColor(attribute);
    }

    public static Font getFont(String attribute) {
        return theme.getFont(attribute);
    }

    public static SyntaxStyle getStyle(String attribute) {
        String str = theme.get("editor.token." + attribute + ".style");
        if (str == null) {
            throw new IllegalArgumentException("No style found for " + attribute);
        }
        return SyntaxStyle.fromString(str);
    }

    public static Image makeGradient(String attribute, int wide, int high) {
        if ("lab".equals(Preferences.get("theme.gradient.method"))) {
            return Theme.makeGradientLab(attribute, wide, high);
        }
        return Theme.makeGradientRGB(attribute, wide, high);
    }

    private static Image makeGradientRGB(String attribute, int wide, int high) {
        int top = Theme.getColor(attribute + ".gradient.top").getRGB();
        int bot = Theme.getColor(attribute + ".gradient.bottom").getRGB();
        BufferedImage outgoing = new BufferedImage(wide, high, 1);
        int[] row = new int[wide];
        WritableRaster wr = outgoing.getRaster();
        for (int i = 0; i < high; ++i) {
            int rgb = PApplet.lerpColor((int)top, (int)bot, (float)((float)i / (float)(high - 1)), (int)1);
            Arrays.fill(row, rgb);
            wr.setDataElements(0, i, wide, 1, row);
        }
        return outgoing;
    }

    private static Image makeGradientLab(String attribute, int wide, int high) {
        double[] top = Theme.xyzToLab(Theme.rgbToXyz(Theme.getColor(attribute + ".gradient.top")));
        double[] bot = Theme.xyzToLab(Theme.rgbToXyz(Theme.getColor(attribute + ".gradient.bottom")));
        double diffL = bot[0] - top[0];
        double diffA = bot[1] - top[1];
        double diffB = bot[2] - top[2];
        BufferedImage outgoing = new BufferedImage(wide, high, 1);
        int[] row = new int[wide];
        WritableRaster wr = outgoing.getRaster();
        for (int i = 0; i < high; ++i) {
            double amt = (double)i / ((double)high - 1.0);
            double el = top[0] + amt * diffL;
            double ay = top[1] + amt * diffA;
            double be = top[2] + amt * diffB;
            int rgb = Theme.argb(Theme.xzyToRgb(Theme.labToXyz(el, ay, be)));
            Arrays.fill(row, rgb);
            wr.setDataElements(0, i, wide, 1, row);
        }
        return outgoing;
    }

    private static double[] rgbToXyz(Color color) {
        double var_R = (double)color.getRed() / 255.0;
        double var_G = (double)color.getGreen() / 255.0;
        double var_B = (double)color.getBlue() / 255.0;
        var_R = 100.0 * (var_R > 0.04045 ? Math.pow((var_R + 0.055) / 1.055, 2.4) : var_R / 12.92);
        var_G = 100.0 * (var_G > 0.04045 ? Math.pow((var_G + 0.055) / 1.055, 2.4) : var_G / 12.92);
        var_B = 100.0 * (var_B > 0.04045 ? Math.pow((var_B + 0.055) / 1.055, 2.4) : var_B / 12.92);
        return new double[]{var_R * 0.4124 + var_G * 0.3576 + var_B * 0.1805, var_R * 0.2126 + var_G * 0.7152 + var_B * 0.0722, var_R * 0.0193 + var_G * 0.1192 + var_B * 0.9505};
    }

    private static double[] xyzToLab(double[] xyz) {
        double var_X = xyz[0] / 95.047;
        double var_Y = xyz[1] / 100.0;
        double var_Z = xyz[2] / 108.883;
        var_X = var_X > 0.008856 ? Math.pow(var_X, 0.3333333333333333) : 7.787 * var_X + 0.13793103448275862;
        var_Y = var_Y > 0.008856 ? Math.pow(var_Y, 0.3333333333333333) : 7.787 * var_Y + 0.13793103448275862;
        var_Z = var_Z > 0.008856 ? Math.pow(var_Z, 0.3333333333333333) : 7.787 * var_Z + 0.13793103448275862;
        return new double[]{116.0 * var_Y - 16.0, 500.0 * (var_X - var_Y), 200.0 * (var_Y - var_Z)};
    }

    private static double[] labToXyz(double el, double ay, double be) {
        double var_Y = (el + 16.0) / 116.0;
        double var_X = ay / 500.0 + var_Y;
        double var_Z = var_Y - be / 200.0;
        double amt = Math.pow(0.008856, 0.3333333333333333);
        var_Y = var_Y > amt ? Math.pow(var_Y, 3.0) : (var_Y - 0.13793103448275862) / 7.787;
        var_X = var_X > amt ? Math.pow(var_X, 3.0) : (var_X - 0.13793103448275862) / 7.787;
        var_Z = var_Z > amt ? Math.pow(var_Z, 3.0) : (var_Z - 0.13793103448275862) / 7.787;
        return new double[]{95.047 * var_X, 100.0 * var_Y, 108.883 * var_Z};
    }

    private static double[] xzyToRgb(double[] xyz) {
        double var_X = xyz[0] / 100.0;
        double var_Y = xyz[1] / 100.0;
        double var_Z = xyz[2] / 100.0;
        double var_R = var_X * 3.2406 + var_Y * -1.5372 + var_Z * -0.4986;
        double var_G = var_X * -0.9689 + var_Y * 1.8758 + var_Z * 0.0415;
        double var_B = var_X * 0.0557 + var_Y * -0.204 + var_Z * 1.057;
        var_R = var_R > 0.0031308 ? 1.055 * Math.pow(var_R, 0.4166666666666667) - 0.055 : 12.92 * var_R;
        var_G = var_G > 0.0031308 ? 1.055 * Math.pow(var_G, 0.4166666666666667) - 0.055 : 12.92 * var_G;
        var_B = var_B > 0.0031308 ? 1.055 * Math.pow(var_B, 0.4166666666666667) - 0.055 : 12.92 * var_B;
        return new double[]{var_R * 255.0, var_G * 255.0, var_B * 255.0};
    }

    private static int bounded(double amount) {
        return Math.max(0, Math.min((int)Math.round(amount), 255));
    }

    private static int argb(double[] rgb) {
        return 0xFF000000 | Theme.bounded(rgb[0]) << 16 | Theme.bounded(rgb[1]) << 8 | Theme.bounded(rgb[2]);
    }
}

