/*
 * Decompiled with CFR 0.152.
 */
package processing.app.ui;

import java.awt.Color;
import java.awt.EventQueue;
import java.io.File;
import java.io.IOException;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.border.EmptyBorder;
import processing.app.Base;
import processing.app.Platform;
import processing.app.Preferences;
import processing.app.ui.Toolkit;
import processing.app.ui.WebFrame;

public class Welcome {
    Base base;
    WebFrame view;

    public Welcome(final Base base) throws IOException {
        this.base = base;
        Box panel = Box.createHorizontalBox();
        panel.setBackground(Color.WHITE);
        panel.setOpaque(true);
        panel.setBorder(new EmptyBorder(15, 20, 15, 20));
        JCheckBox checkbox = new JCheckBox("Show this message on startup");
        checkbox.setSelected("true".equals(Preferences.get("welcome.four.show")));
        checkbox.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                Preferences.setBoolean("welcome.four.show", true);
            } else if (e.getStateChange() == 2) {
                Preferences.setBoolean("welcome.four.show", false);
            }
        });
        panel.add(checkbox);
        panel.add(Box.createHorizontalGlue());
        JButton button = new JButton("Get Started");
        button.setFont(Toolkit.getSansFont(14, 0));
        button.addActionListener(e -> this.view.handleClose());
        panel.add(button);
        File indexFile = Welcome.getIndexFile();
        if (indexFile == null) {
            return;
        }
        this.view = new WebFrame(Welcome.getIndexFile(), 420, panel){

            @Override
            public void handleLink(String link) {
                if (link.endsWith("#examples")) {
                    base.getDefaultMode().showExamplesFrame();
                } else if (link.endsWith("#mouse")) {
                    this.openExample("Basics/Input/Mouse2D/Mouse2D.pde");
                } else if (link.endsWith("#arctan")) {
                    this.openExample("Basics/Math/Arctangent/Arctangent.pde");
                } else if (link.endsWith("#flocking")) {
                    this.openExample("Topics/Simulate/Flocking/Flocking.pde");
                } else if (link.endsWith("#rotating")) {
                    this.openExample("Demos/Graphics/RotatingArcs/RotatingArcs.pde");
                } else {
                    super.handleLink(link);
                }
            }

            private void openExample(String examplePath) {
                File examplesFolder = Platform.getContentFile("modes/java/examples");
                File pdeFile = new File(examplesFolder, examplePath);
                base.handleOpen(pdeFile.getAbsolutePath());
            }

            @Override
            public void handleClose() {
                Preferences.setBoolean("welcome.four.seen", true);
                Preferences.save();
                super.handleClose();
            }
        };
        this.view.setVisible(true);
    }

    private static File getIndexFile() {
        String filename = "welcome/index.html";
        File htmlFile = new File("build/shared/lib/" + filename);
        if (htmlFile.exists()) {
            return htmlFile;
        }
        try {
            return Base.getLibFile(filename);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void main(String[] args) {
        Platform.init();
        try {
            Platform.setLookAndFeel();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Preferences.init();
        EventQueue.invokeLater(() -> {
            try {
                new Welcome(null);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
    }
}

