/*
 * Decompiled with CFR 0.152.
 */
package processing.mode.java;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.IntStream;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.Type;
import processing.app.Messages;

public class ASTUtils {
    public static ASTNode getASTNodeAt(ASTNode root, int startJavaOffset, int stopJavaOffset) {
        Messages.log((String)"* getASTNodeAt");
        int length = stopJavaOffset - startJavaOffset;
        NodeFinder f = new NodeFinder(root, startJavaOffset, length);
        ASTNode node = f.getCoveredNode();
        if (node == null) {
            node = f.getCoveringNode();
        }
        if (node == null) {
            Messages.log((String)"no node found");
        } else {
            Messages.log((String)("found " + node.getClass().getSimpleName()));
        }
        return node;
    }

    public static SimpleName getSimpleNameAt(ASTNode root, int startJavaOffset, int stopJavaOffset) {
        Messages.log((String)"* getSimpleNameAt");
        ASTNode node = ASTUtils.getASTNodeAt(root, startJavaOffset, stopJavaOffset);
        SimpleName result = null;
        if (node != null) {
            if (node.getNodeType() == 42) {
                result = (SimpleName)node;
            } else {
                List<SimpleName> simpleNames = ASTUtils.getSimpleNameChildren(node);
                if (!simpleNames.isEmpty()) {
                    int[] coverages = simpleNames.stream().mapToInt(name -> {
                        int start = name.getStartPosition();
                        int stop = start + name.getLength();
                        return Math.min(stop, stopJavaOffset) - Math.max(startJavaOffset, start);
                    }).toArray();
                    int maxIndex = IntStream.range(0, simpleNames.size()).filter(i -> coverages[i] >= 0).reduce((i, j) -> coverages[i] > coverages[j] ? i : j).orElse(-1);
                    if (maxIndex == -1) {
                        return null;
                    }
                    result = simpleNames.get(maxIndex);
                }
            }
        }
        if (result == null) {
            Messages.log((String)"no simple name found");
        } else {
            Messages.log((String)("found " + node));
        }
        return result;
    }

    public static List<SimpleName> getSimpleNameChildren(ASTNode node) {
        final ArrayList<SimpleName> simpleNames = new ArrayList<SimpleName>();
        node.accept(new ASTVisitor(){

            public boolean visit(SimpleName simpleName) {
                simpleNames.add(simpleName);
                return super.visit(simpleName);
            }
        });
        return simpleNames;
    }

    public static IBinding resolveBinding(SimpleName node) {
        IBinding binding = node.resolveBinding();
        if (binding == null) {
            return null;
        }
        if (binding.getKind() == 2) {
            SimpleName context = node;
            while (ASTUtils.isNameOrType((ASTNode)context) && !context.getLocationInParent().getId().equals("typeArguments")) {
                context = context.getParent();
            }
            switch (context.getNodeType()) {
                case 31: {
                    MethodDeclaration decl = (MethodDeclaration)context;
                    if (!decl.isConstructor()) break;
                    binding = decl.resolveBinding();
                    break;
                }
                case 14: {
                    ClassInstanceCreation cic = (ClassInstanceCreation)context;
                    binding = cic.resolveConstructorBinding();
                }
            }
        }
        if (binding == null) {
            return null;
        }
        switch (binding.getKind()) {
            case 2: {
                ITypeBinding type = (ITypeBinding)binding;
                if (!type.isParameterizedType() && !type.isRawType()) break;
                binding = type.getErasure();
                break;
            }
            case 4: {
                IMethodBinding method = (IMethodBinding)binding;
                ITypeBinding declaringClass = method.getDeclaringClass();
                if (declaringClass.isParameterizedType() || declaringClass.isRawType()) {
                    IMethodBinding[] methods = declaringClass.getErasure().getDeclaredMethods();
                    IMethodBinding generic = Arrays.stream(methods).filter(arg_0 -> ((IMethodBinding)method).overrides(arg_0)).findAny().orElse(null);
                    if (generic != null) {
                        method = generic;
                    }
                }
                if (method.isParameterizedMethod() || method.isRawMethod()) {
                    method = method.getMethodDeclaration();
                }
                binding = method;
            }
        }
        return binding;
    }

    public static boolean isNameOrType(ASTNode node) {
        return node instanceof Name || node instanceof Type;
    }

    public static List<SimpleName> findAllOccurrences(ASTNode root, final String bindingKey) {
        final ArrayList<SimpleName> occurrences = new ArrayList<SimpleName>();
        root.getRoot().accept(new ASTVisitor(){

            public boolean visit(SimpleName name) {
                IBinding binding = ASTUtils.resolveBinding(name);
                if (binding != null && bindingKey.equals(binding.getKey())) {
                    occurrences.add(name);
                }
                return super.visit(name);
            }
        });
        return occurrences;
    }
}

