/*
 * Decompiled with CFR 0.152.
 */
package processing.mode.java;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import processing.app.Base;
import processing.app.Mode;
import processing.app.Platform;
import processing.app.Preferences;
import processing.app.RunnerListener;
import processing.app.Sketch;
import processing.app.SketchException;
import processing.app.Util;
import processing.app.contrib.ModeContribution;
import processing.core.PApplet;
import processing.data.StringDict;
import processing.mode.java.JavaBuild;
import processing.mode.java.JavaMode;
import processing.mode.java.runner.Runner;

public class Commander
implements RunnerListener {
    static final String helpArg = "--help";
    static final String buildArg = "--build";
    static final String runArg = "--run";
    static final String presentArg = "--present";
    static final String sketchArg = "--sketch=";
    static final String forceArg = "--force";
    static final String outputArg = "--output=";
    static final String exportApplicationArg = "--export";
    static final String noJavaArg = "--no-java";
    static final String variantArg = "--variant=";
    static final int HELP = -1;
    static final int BUILD = 1;
    static final int RUN = 2;
    static final int PRESENT = 3;
    static final int EXPORT = 4;
    Sketch sketch;
    PrintStream systemOut;
    PrintStream systemErr;

    public Commander(String[] args) {
        String sketchPath = null;
        File sketchFolder = null;
        String pdePath = null;
        String outputPath = null;
        File outputFolder = null;
        boolean outputSet = false;
        boolean force = false;
        String variant = Platform.getVariant();
        int task = -1;
        boolean embedJava = true;
        if (Platform.isWindows()) {
            this.systemOut = new PrintStream(System.out, true);
            this.systemErr = new PrintStream(System.err, true);
        } else {
            this.systemOut = new PrintStream((OutputStream)System.out, true, StandardCharsets.UTF_8);
            this.systemErr = new PrintStream((OutputStream)System.err, true, StandardCharsets.UTF_8);
        }
        int argOffset = 0;
        for (String arg : args) {
            ++argOffset;
            if (arg.length() == 0 || arg.equals(helpArg)) continue;
            if (arg.equals(buildArg)) {
                task = 1;
                break;
            }
            if (arg.equals(runArg)) {
                task = 2;
                break;
            }
            if (arg.equals(presentArg)) {
                task = 3;
                break;
            }
            if (arg.equals(exportApplicationArg)) {
                task = 4;
                break;
            }
            if (arg.equals(noJavaArg)) {
                embedJava = false;
                continue;
            }
            if (arg.startsWith("--platform")) {
                this.complainAndQuit("Use --variant instead of --platform with Processing 4.", true);
                continue;
            }
            if (arg.startsWith(variantArg)) {
                variant = arg.substring(variantArg.length());
                continue;
            }
            if (arg.startsWith(sketchArg)) {
                File pdeFile;
                sketchPath = arg.substring(sketchArg.length());
                sketchFolder = new File(sketchPath);
                if (!sketchFolder.exists()) {
                    this.complainAndQuit(sketchFolder + " does not exist.", false);
                }
                if (!(pdeFile = new File(sketchFolder, sketchFolder.getName() + ".pde")).exists()) {
                    this.complainAndQuit("Not a valid sketch folder. " + pdeFile + " does not exist.", true);
                }
                pdePath = pdeFile.getAbsolutePath();
                continue;
            }
            if (arg.startsWith(outputArg)) {
                outputSet = true;
                outputPath = arg.substring(outputArg.length());
                continue;
            }
            if (arg.equals(forceArg)) {
                force = true;
                continue;
            }
            this.complainAndQuit("I don't know anything about " + arg + ".", true);
        }
        String[] sketchArgs = PApplet.subset((String[])args, (int)argOffset);
        if (task == -1) {
            Commander.printCommandLine(this.systemOut);
            System.exit(0);
        }
        if (outputSet) {
            if (outputPath == null) {
                this.complainAndQuit("An output path must be specified.", true);
            }
            if ((outputFolder = new File(outputPath)).exists()) {
                if (force) {
                    Util.removeDir((File)outputFolder);
                } else {
                    this.complainAndQuit("The output folder already exists. Use --force to remove it.", false);
                }
            }
            if (!outputFolder.mkdirs()) {
                this.complainAndQuit("Could not create the output folder.", false);
            }
        }
        Preferences.init();
        Base.locateSketchbookFolder();
        if (sketchPath == null) {
            this.complainAndQuit("No sketch path specified.", true);
        } else {
            if (outputSet && outputPath.equals(sketchPath)) {
                this.complainAndQuit("The sketch path and output path cannot be identical.", false);
            }
            boolean success = false;
            JavaMode javaMode = (JavaMode)ModeContribution.load(null, (File)Platform.getContentFile((String)"modes/java"), (String)"processing.mode.java.JavaMode").getMode();
            try {
                this.sketch = new Sketch(pdePath, (Mode)javaMode);
                if (!outputSet) {
                    outputFolder = this.sketch.makeTempFolder();
                }
                if (task == 1 || task == 2 || task == 3) {
                    build = new JavaBuild(this.sketch);
                    File srcFolder = new File(outputFolder, "source");
                    String className = build.build(srcFolder, outputFolder, true);
                    if (className != null) {
                        success = true;
                        if (task == 2 || task == 3) {
                            Runner runner = new Runner(build, this);
                            if (task == 3) {
                                runner.present(sketchArgs);
                            } else {
                                runner.launch(sketchArgs);
                            }
                            success = !runner.vmReturnedError();
                        }
                    } else {
                        success = false;
                    }
                } else if (task == 4) {
                    if (outputPath == null) {
                        javaMode.handleExportApplication(this.sketch);
                    } else {
                        build = new JavaBuild(this.sketch);
                        build.build(true);
                        if (build != null) {
                            success = build.exportApplication(outputFolder, variant, embedJava);
                        }
                    }
                }
                if (!success) {
                    System.exit(1);
                }
                this.systemOut.println("Finished.");
                System.exit(0);
            }
            catch (SketchException re) {
                this.statusError((Exception)((Object)re));
                System.exit(1);
            }
            catch (IOException e) {
                e.printStackTrace();
                System.exit(1);
            }
        }
    }

    public void statusNotice(String message) {
        this.systemErr.println(message);
    }

    public void statusError(String message) {
        this.systemErr.println(message);
    }

    public void statusError(Exception exception) {
        if (exception instanceof SketchException) {
            SketchException re = (SketchException)((Object)exception);
            int codeIndex = re.getCodeIndex();
            if (codeIndex != -1) {
                String filename = this.sketch.getCode(codeIndex).getFileName();
                int line = re.getCodeLine() + 1;
                int column = re.getCodeColumn() + 1;
                this.systemErr.println(filename + ":" + line + ":" + column + ":" + line + ":" + column + ": " + re.getMessage());
            } else {
                exception.printStackTrace();
            }
        } else {
            exception.printStackTrace();
        }
    }

    void complainAndQuit(String lastWords, boolean schoolEmFirst) {
        if (schoolEmFirst) {
            Commander.printCommandLine(this.systemErr);
        }
        this.systemErr.println(lastWords);
        System.exit(1);
    }

    static void printCommandLine(PrintStream out) {
        out.println();
        out.println("Command line edition for Processing " + Base.getVersionName() + " (Java Mode)");
        out.println();
        out.println("--help               Show this help text. Congratulations.");
        out.println();
        out.println("--sketch=<name>      Specify the sketch folder (required)");
        out.println("--output=<name>      Specify the output folder (optional and");
        out.println("                     cannot be the same as the sketch folder.)");
        out.println();
        out.println("--force              The sketch will not build if the output");
        out.println("                     folder already exists, because the contents");
        out.println("                     will be replaced. This option erases the");
        out.println("                     folder first. Use with extreme caution!");
        out.println();
        out.println("--build              Preprocess and compile a sketch into .class files.");
        out.println("--run                Preprocess, compile, and run a sketch.");
        out.println("--present            Preprocess, compile, and run a sketch in presentation mode.");
        out.println();
        out.println("--export             Export an application.");
        out.println("--variant            Specify the platform and architecture (Export only).");
        out.println("--no-java            Do not embed Java.");
        out.println();
        out.println("Starting with 4.0, the --platform option has been removed");
        out.println("because of the variety of platforms and architectures now available.");
        out.println("Use the --variant option instead, for instance:");
        out.println();
        out.println("variant        platform");
        out.println("-------------  ---------------------------");
        StringDict variants = Platform.getSupportedVariants();
        for (String key : variants.keys()) {
            out.print(key);
            int spaces = 15 - key.length();
            for (int i = 0; i < spaces; ++i) {
                System.out.print(" ");
            }
            System.out.println(variants.get(key));
        }
        out.println();
        out.println("The --build, --run, --present, or --export must be the final parameter");
        out.println("passed to Processing. Arguments passed following one of those four will");
        out.println("be passed through to the sketch itself, and therefore available to the");
        out.println("sketch via the 'args' field. To pass options understood by PApplet.main(),");
        out.println("write a custom main() method so that the preprocessor does not add one.");
        out.println("https://github.com/processing/processing/wiki/Command-Line");
        out.println();
    }

    public void startIndeterminate() {
    }

    public void stopIndeterminate() {
    }

    public void statusHalt() {
    }

    public boolean isHalted() {
        return false;
    }

    public static void main(String[] args) {
        Base.setCommandLine();
        Platform.init();
        new Commander(args);
    }
}

