/*
 * Decompiled with CFR 0.152.
 */
package processing.mode.java;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import processing.mode.java.CompletionGenerator;

public class CompletionCandidate
implements Comparable<CompletionCandidate> {
    private final String elementName;
    private final String label;
    private final String completion;
    private final Object wrappedObject;
    private final int type;
    static final int PREDEF_CLASS = 0;
    static final int PREDEF_FIELD = 1;
    static final int PREDEF_METHOD = 2;
    static final int LOCAL_CLASS = 3;
    static final int LOCAL_METHOD = 4;
    static final int LOCAL_FIELD = 5;
    static final int LOCAL_VAR = 6;

    CompletionCandidate(Method method) {
        this.elementName = method.getName();
        this.label = CompletionCandidate.makeLabel(method);
        this.completion = CompletionCandidate.makeCompletion(method);
        this.type = 2;
        this.wrappedObject = method;
    }

    CompletionCandidate(SingleVariableDeclaration svd) {
        this.completion = svd.getName().toString();
        this.elementName = svd.getName().toString();
        this.type = svd.getParent() instanceof FieldDeclaration ? 5 : 6;
        this.label = svd.getName() + " : " + svd.getType();
        this.wrappedObject = svd;
    }

    CompletionCandidate(VariableDeclarationFragment vdf) {
        this.completion = vdf.getName().toString();
        this.elementName = vdf.getName().toString();
        this.type = vdf.getParent() instanceof FieldDeclaration ? 5 : 6;
        this.label = vdf.getName() + " : " + CompletionGenerator.extracTypeInfo2((ASTNode)vdf);
        this.wrappedObject = vdf;
    }

    CompletionCandidate(MethodDeclaration method) {
        int i;
        this.elementName = method.getName().toString();
        this.type = 4;
        List params = (List)method.getStructuralProperty((StructuralPropertyDescriptor)MethodDeclaration.PARAMETERS_PROPERTY);
        StringBuilder labelBuilder = new StringBuilder(this.elementName);
        labelBuilder.append('(');
        for (i = 0; i < params.size(); ++i) {
            labelBuilder.append(((ASTNode)params.get(i)).toString());
            if (i >= params.size() - 1) continue;
            labelBuilder.append(',');
        }
        labelBuilder.append(')');
        if (method.getReturnType2() != null) {
            labelBuilder.append(" : ");
            labelBuilder.append(method.getReturnType2());
        }
        this.label = labelBuilder.toString();
        StringBuilder compBuilder = new StringBuilder(this.elementName);
        compBuilder.append('(');
        for (i = 0; i < params.size(); ++i) {
            if (i >= params.size() - 1) continue;
            compBuilder.append(',');
        }
        if (params.size() == 1) {
            compBuilder.append(' ');
        }
        compBuilder.append(')');
        this.completion = compBuilder.toString();
        this.wrappedObject = method;
    }

    CompletionCandidate(TypeDeclaration td) {
        this.type = 3;
        this.label = this.elementName = td.getName().toString();
        this.completion = this.elementName;
        this.wrappedObject = td;
    }

    CompletionCandidate(Field f) {
        this.elementName = f.getName();
        this.type = 1;
        this.label = "<html>" + f.getName() + " : " + f.getType().getSimpleName() + " - <font color=#777777>" + f.getDeclaringClass().getSimpleName() + "</font></html>";
        this.completion = this.elementName;
        this.wrappedObject = f;
    }

    CompletionCandidate(String elementName, String label, String completion, int type) {
        this(elementName, label, completion, type, null);
    }

    private CompletionCandidate(String elementName, String label, String completion, int type, Object wrappedObject) {
        this.elementName = elementName;
        this.label = label;
        this.completion = completion;
        this.type = type;
        this.wrappedObject = wrappedObject;
    }

    public String getElementName() {
        return this.elementName;
    }

    public String getCompletionString() {
        return this.completion;
    }

    public int getType() {
        return this.type;
    }

    public String getLabel() {
        return this.label;
    }

    CompletionCandidate withLabelAndCompString(String withLabel, String withCompletion) {
        return new CompletionCandidate(this.elementName, withLabel, withCompletion, this.type, this.wrappedObject);
    }

    CompletionCandidate withRegeneratedCompString() {
        if (this.wrappedObject instanceof MethodDeclaration) {
            MethodDeclaration method = (MethodDeclaration)this.wrappedObject;
            List params = (List)method.getStructuralProperty((StructuralPropertyDescriptor)MethodDeclaration.PARAMETERS_PROPERTY);
            StringBuilder labelBuilder = new StringBuilder(this.elementName);
            labelBuilder.append('(');
            for (int i = 0; i < params.size(); ++i) {
                labelBuilder.append(params.get(i));
                if (i >= params.size() - 1) continue;
                labelBuilder.append(',');
            }
            labelBuilder.append(')');
            if (method.getReturnType2() != null) {
                labelBuilder.append(" : ");
                labelBuilder.append(method.getReturnType2());
            }
            StringBuilder compBuilder = new StringBuilder();
            compBuilder.append(method.getName());
            compBuilder.append('(');
            for (int i = 0; i < params.size(); ++i) {
                if (i >= params.size() - 1) continue;
                compBuilder.append(',');
            }
            if (params.size() == 1) {
                compBuilder.append(' ');
            }
            compBuilder.append(')');
            return this.withLabelAndCompString(labelBuilder.toString(), compBuilder.toString());
        }
        if (this.wrappedObject instanceof Method) {
            Method method = (Method)this.wrappedObject;
            Class<?>[] types = method.getParameterTypes();
            StringBuilder labelBuilder = new StringBuilder();
            labelBuilder.append("<html>");
            labelBuilder.append(method.getName());
            labelBuilder.append('(');
            for (int i = 0; i < types.length; ++i) {
                labelBuilder.append(types[i].getSimpleName());
                if (i >= types.length - 1) continue;
                labelBuilder.append(',');
            }
            labelBuilder.append(')');
            labelBuilder.append(" : ");
            labelBuilder.append(method.getReturnType().getSimpleName());
            labelBuilder.append(" - <font color=#777777>");
            labelBuilder.append(method.getDeclaringClass().getSimpleName());
            labelBuilder.append("</font>");
            labelBuilder.append("</html>");
            StringBuilder compBuilder = new StringBuilder(method.getName());
            compBuilder.append('(');
            for (int i = 0; i < types.length; ++i) {
                if (i >= types.length - 1) continue;
                compBuilder.append(',');
            }
            if (types.length == 1) {
                compBuilder.append(' ');
            }
            compBuilder.append(')');
            return this.withLabelAndCompString(labelBuilder.toString(), compBuilder.toString());
        }
        return this;
    }

    private static String makeLabel(Method method) {
        Class<?>[] types = method.getParameterTypes();
        StringBuilder labelBuilder = new StringBuilder();
        labelBuilder.append("<html>");
        labelBuilder.append(method.getName());
        labelBuilder.append('(');
        for (int i = 0; i < types.length; ++i) {
            labelBuilder.append(types[i].getSimpleName());
            if (i >= types.length - 1) continue;
            labelBuilder.append(',');
        }
        labelBuilder.append(")");
        labelBuilder.append(" : ");
        labelBuilder.append(method.getReturnType().getSimpleName());
        labelBuilder.append(" - <font color=#777777>");
        labelBuilder.append(method.getDeclaringClass().getSimpleName());
        labelBuilder.append("</font>");
        labelBuilder.append("</html>");
        return labelBuilder.toString();
    }

    private static String makeCompletion(Method method) {
        Class<?>[] types = method.getParameterTypes();
        StringBuilder compBuilder = new StringBuilder();
        compBuilder.append(method.getName());
        compBuilder.append('(');
        for (int i = 0; i < types.length; ++i) {
            if (i >= types.length - 1) continue;
            compBuilder.append(',');
        }
        if (types.length == 1) {
            compBuilder.append(' ');
        }
        compBuilder.append(')');
        return compBuilder.toString();
    }

    @Override
    public int compareTo(CompletionCandidate cc) {
        if (this.type != cc.getType()) {
            return cc.getType() - this.type;
        }
        return this.elementName.compareTo(cc.getElementName());
    }

    public String toString() {
        return this.label;
    }
}

