/*
 * Decompiled with CFR 0.152.
 */
package processing.mode.java;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import processing.app.Base;
import processing.app.Library;
import processing.app.Messages;
import processing.app.Mode;
import processing.app.Platform;
import processing.app.Preferences;
import processing.app.Problem;
import processing.app.Sketch;
import processing.app.SketchCode;
import processing.app.SketchException;
import processing.app.Util;
import processing.app.exec.ProcessHelper;
import processing.app.platform.MacPlatform;
import processing.core.PApplet;
import processing.data.StringList;
import processing.data.XML;
import processing.mode.java.Compiler;
import processing.mode.java.ImportStatement;
import processing.mode.java.ProblemFactory;
import processing.mode.java.preproc.PdePreprocessor;
import processing.mode.java.preproc.PreprocessorResult;

public class JavaBuild {
    public static final String PACKAGE_REGEX = "(?:^|\\s|;)package\\s+(\\S+)\\;";
    public static final String MIN_JAVA_VERSION = "17";
    protected Sketch sketch;
    protected Mode mode;
    protected File srcFolder;
    protected File binFolder;
    private boolean foundMain = false;
    private String classPath;
    protected String sketchClassName;
    private String javaLibraryPath;
    private List<Library> importedLibraries;

    public JavaBuild(Sketch sketch) {
        this.sketch = sketch;
        this.mode = sketch.getMode();
    }

    public String build(boolean sizeWarning) throws SketchException {
        return this.build(this.sketch.makeTempFolder(), this.sketch.makeTempFolder(), sizeWarning);
    }

    public String build(File srcFolder, File binFolder, boolean sizeWarning) throws SketchException {
        this.srcFolder = srcFolder;
        this.binFolder = binFolder;
        PreprocessorResult result = this.preprocess(srcFolder, sizeWarning);
        String classNameFound = result.getClassName();
        if (Compiler.compile(this)) {
            this.sketchClassName = classNameFound;
            return classNameFound;
        }
        return null;
    }

    public String getSketchClassName() {
        return this.sketchClassName;
    }

    public PreprocessorResult preprocess(File srcFolder, boolean sizeWarning) throws SketchException {
        PdePreprocessor preprocessor = PdePreprocessor.builderFor(this.sketch.getMainName()).build();
        return this.preprocess(srcFolder, null, preprocessor, sizeWarning);
    }

    public PreprocessorResult preprocess(File srcFolder, String packageName, PdePreprocessor preprocessor, boolean sizeWarning) throws SketchException {
        PreprocessorResult result;
        this.sketch.ensureExistence();
        this.classPath = this.binFolder.getAbsolutePath();
        StringList codeFolderPackages = null;
        if (this.sketch.hasCodeFolder()) {
            File codeFolder = this.sketch.getCodeFolder();
            this.javaLibraryPath = codeFolder.getAbsolutePath();
            String codeFolderClassPath = Util.contentsToClassPath((File)codeFolder);
            this.classPath = this.classPath + File.pathSeparator + codeFolderClassPath;
            codeFolderPackages = Util.packageListFromClassPath((String)codeFolderClassPath);
        } else {
            this.javaLibraryPath = "";
        }
        StringBuilder bigCode = new StringBuilder();
        int bigCount = 0;
        ArrayList<Integer> linesPerTab = new ArrayList<Integer>();
        for (SketchCode sc : this.sketch.getCode()) {
            if (!sc.isExtension("pde")) continue;
            sc.setPreprocOffset(bigCount);
            bigCode.append(sc.getProgram());
            bigCode.append('\n');
            linesPerTab.add(bigCount);
            bigCount += sc.getLineCount();
        }
        linesPerTab.add(bigCount);
        try {
            File outputFolder = packageName == null ? srcFolder : new File(srcFolder, packageName.replace('.', '/'));
            outputFolder.mkdirs();
            File java = new File(outputFolder, this.sketch.getMainName() + ".java");
            try (PrintWriter stream = PApplet.createWriter((File)java);){
                result = preprocessor.write(stream, bigCode.toString(), (Iterable<String>)codeFolderPackages);
            }
        }
        catch (SketchException pe) {
            throw pe;
        }
        catch (Exception ex) {
            System.err.println("Uncaught exception type:" + ex.getClass());
            ex.printStackTrace();
            throw new SketchException(ex.toString());
        }
        if (result.getPreprocessIssues().size() > 0) {
            Problem problem = ProblemFactory.build(result.getPreprocessIssues().get(0), linesPerTab);
            throw new SketchException(problem.getMessage(), problem.getTabIndex(), problem.getLineNumber() - 1, 0);
        }
        this.importedLibraries = new ArrayList<Library>();
        Library core = this.mode.getCoreLibrary();
        if (core != null) {
            this.importedLibraries.add(core);
            this.classPath = this.classPath + core.getClassPath();
            this.javaLibraryPath = this.javaLibraryPath + File.pathSeparator + core.getNativePath();
        }
        for (ImportStatement item : result.getImportStatements()) {
            String entry = item.getPackageName();
            Library library = this.mode.getLibrary(entry);
            if (library != null) {
                if (this.importedLibraries.contains(library)) continue;
                this.importedLibraries.add(library);
                this.classPath = this.classPath + library.getClassPath();
                this.javaLibraryPath = this.javaLibraryPath + File.pathSeparator + library.getNativePath();
                continue;
            }
            boolean found = false;
            if (codeFolderPackages != null) {
                for (String pkg : codeFolderPackages) {
                    if (!pkg.equals(entry)) continue;
                    found = true;
                    break;
                }
            }
            if (this.ignorableImport(entry + ".")) {
                found = true;
            }
            if (found) continue;
            System.err.println("No library found for " + entry);
        }
        for (SketchCode sc : this.sketch.getCode()) {
            if (sc.isExtension("java")) {
                String filename = sc.getFileName();
                try {
                    Object javaCode = sc.getProgram();
                    String[] packageMatch = PApplet.match((String)javaCode, (String)PACKAGE_REGEX);
                    if (packageMatch == null && packageName == null) {
                        sc.copyTo(new File(srcFolder, filename));
                        continue;
                    }
                    if (packageMatch == null) {
                        packageMatch = new String[]{"", packageName};
                        javaCode = "package " + packageName + ";" + (String)javaCode;
                    }
                    File packageFolder = new File(srcFolder, packageMatch[1].replace('.', File.separatorChar));
                    packageFolder.mkdirs();
                    Util.saveFile((String)javaCode, (File)new File(packageFolder, filename));
                    continue;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    String msg = "Problem moving " + filename + " to the build folder";
                    throw new SketchException(msg);
                }
            }
            if (!sc.isExtension("pde")) continue;
            sc.addPreprocOffset(result.getHeaderOffset());
        }
        this.foundMain = preprocessor.hasMain();
        return result;
    }

    protected boolean ignorableImport(String pkg) {
        if (pkg.startsWith("java.")) {
            return true;
        }
        if (pkg.startsWith("javax.")) {
            return true;
        }
        if (pkg.startsWith("javafx.")) {
            return true;
        }
        if (pkg.startsWith("processing.core.")) {
            return true;
        }
        if (pkg.startsWith("processing.data.")) {
            return true;
        }
        if (pkg.startsWith("processing.event.")) {
            return true;
        }
        if (pkg.startsWith("processing.opengl.")) {
            return true;
        }
        if (pkg.startsWith("org.omg")) {
            return true;
        }
        if (pkg.startsWith("org.w3c.dom")) {
            return true;
        }
        return pkg.startsWith("org.xml.sax");
    }

    protected int findErrorFile(int errorLine) {
        for (int i = this.sketch.getCodeCount() - 1; i > 0; --i) {
            SketchCode sc = this.sketch.getCode(i);
            if (!sc.isExtension("pde") || sc.getPreprocOffset() > errorLine) continue;
            return i;
        }
        return 0;
    }

    public File getSrcFolder() {
        return this.srcFolder;
    }

    public File getBinFolder() {
        return this.binFolder;
    }

    public String getSketchPath() {
        return this.sketch.getFolder().getAbsolutePath();
    }

    public String getClassPath() {
        return this.classPath;
    }

    public String getJavaLibraryPath() {
        return this.javaLibraryPath;
    }

    public boolean getFoundMain() {
        return this.foundMain;
    }

    public List<Library> getImportedLibraries() {
        return this.importedLibraries;
    }

    public SketchException placeException(String message, String dotJavaFilename, int dotJavaLine) {
        SketchCode code;
        int i;
        int codeIndex = 0;
        int codeLine = -1;
        for (i = 0; i < this.sketch.getCodeCount(); ++i) {
            code = this.sketch.getCode(i);
            if (!code.isExtension("java") || !dotJavaFilename.equals(code.getFileName())) continue;
            codeIndex = i;
            codeLine = dotJavaLine;
            return new SketchException(message, codeIndex, codeLine);
        }
        if (!dotJavaFilename.equals(this.sketch.getMainName() + ".java")) {
            return null;
        }
        codeIndex = 0;
        for (i = 0; i < this.sketch.getCodeCount(); ++i) {
            code = this.sketch.getCode(i);
            if (!code.isExtension("pde") || code.getPreprocOffset() > dotJavaLine) continue;
            codeIndex = i;
            codeLine = dotJavaLine - code.getPreprocOffset();
        }
        return new SketchException(message, codeIndex, codeLine, -1, false);
    }

    protected boolean exportApplication() throws IOException, SketchException {
        String foundName = this.build(true);
        if (foundName == null) {
            return false;
        }
        if (!this.sketch.getMainName().equals(foundName)) {
            Messages.showWarning((String)"Error during export", (String)("Main tab is named " + this.sketch.getMainName() + " but the\nsketch name in the code was " + foundName), null);
            return false;
        }
        String hostVariant = Platform.getVariant();
        for (String variant : Preferences.get((String)"export.application.variants").split(",")) {
            boolean embedJava = variant.equals(hostVariant) && Preferences.getBoolean((String)"export.application.embed_java");
            File folder = new File(this.sketch.getFolder(), variant);
            if (this.exportApplication(folder, variant, embedJava)) continue;
            return false;
        }
        return true;
    }

    protected boolean exportApplication(File destFolder, String exportVariant, boolean embedJava) throws IOException, SketchException {
        Library javafx;
        for (Library library : this.importedLibraries) {
            if (!library.isUnsupported(exportVariant)) continue;
            Messages.showWarning((String)"Quibbles 'n Bits", (String)("The application will not be exported for\n" + Platform.getSupportedVariants().get(exportVariant) + " because " + library.getName() + "\ndoes not support " + exportVariant + "."), null);
            return true;
        }
        int exportPlatform = Platform.getIndex((String)exportVariant);
        this.mode.prepareExportFolder(destFolder);
        File jarFolder = new File(destFolder, "lib");
        File dotAppFolder = null;
        Object jvmRuntime = "";
        String jdkPath = null;
        if (exportPlatform == 2) {
            dotAppFolder = new File(destFolder, this.sketch.getName() + ".app");
            File contentsOrig = new File(Platform.getJavaHome(), "../../../..");
            if (embedJava) {
                File jdkFolder = new File(Platform.getJavaHome(), "../..");
                String jdkFolderName = jdkFolder.getCanonicalFile().getName();
                jvmRuntime = "<key>JVMRuntime</key>\n    <string>" + jdkFolderName + "</string>";
                jdkPath = new File(dotAppFolder, "Contents/PlugIns/" + jdkFolderName).getAbsolutePath();
            }
            File contentsFolder = new File(dotAppFolder, "Contents");
            contentsFolder.mkdirs();
            jarFolder = new File(contentsFolder, "Java");
            File macosFolder = new File(contentsFolder, "MacOS");
            macosFolder.mkdirs();
            File stubFile = this.mode.getContentFile("application/stub-" + exportVariant);
            File execFile = new File(contentsFolder, "MacOS/" + this.sketch.getMainName());
            Util.copyFile((File)stubFile, (File)execFile);
            if (!execFile.setExecutable(true)) {
                throw new IOException("Could not make " + execFile + " executable.");
            }
            File pkgInfo = new File(contentsFolder, "PkgInfo");
            PrintWriter writer = PApplet.createWriter((File)pkgInfo);
            writer.println("APPL????");
            writer.flush();
            writer.close();
            if (embedJava) {
                Util.copyDirNative((File)new File(contentsOrig, "PlugIns"), (File)new File(contentsFolder, "PlugIns"));
            }
            File resourcesFolder = new File(contentsFolder, "Resources");
            Util.copyDir((File)new File(contentsOrig, "Resources/en.lproj"), (File)new File(resourcesFolder, "en.lproj"));
            Util.copyFile((File)this.mode.getContentFile("application/application.icns"), (File)new File(resourcesFolder, "application.icns"));
        } else if (exportPlatform == 3) {
            if (embedJava) {
                Util.copyDirNative((File)Platform.getJavaHome(), (File)new File(destFolder, "java"));
            }
        } else if (exportPlatform == 1 && embedJava) {
            Util.copyDir((File)Platform.getJavaHome(), (File)new File(destFolder, "java"));
        }
        if (!jarFolder.exists()) {
            jarFolder.mkdirs();
        }
        StringList jarList = new StringList();
        FileOutputStream zipOutputFile = new FileOutputStream(new File(jarFolder, this.sketch.getMainName() + ".jar"));
        ZipOutputStream zos = new ZipOutputStream(zipOutputFile);
        this.addManifest(zos);
        this.addClasses(zos, this.binFolder);
        if (this.sketch.hasDataFolder()) {
            if (exportPlatform == 2) {
                Util.copyDir((File)this.sketch.getDataFolder(), (File)new File(jarFolder, "data"));
            } else {
                Util.copyDir((File)this.sketch.getDataFolder(), (File)new File(destFolder, "data"));
            }
        }
        if (this.sketch.hasCodeFolder()) {
            String includes = Util.contentsToClassPath((File)this.sketch.getCodeFolder());
            String[] codeList = PApplet.splitTokens((String)includes, (String)File.pathSeparator);
            for (int i = 0; i < codeList.length; ++i) {
                if (!codeList[i].toLowerCase().endsWith(".jar") && !codeList[i].toLowerCase().endsWith(".zip")) continue;
                File exportFile = new File(codeList[i]);
                String[] exportFilename = exportFile.getName();
                Util.copyFile((File)exportFile, (File)new File(jarFolder, (String)exportFilename));
                jarList.append((String)exportFilename);
            }
        }
        zos.flush();
        zos.close();
        jarList.append(this.sketch.getMainName() + ".jar");
        for (Library library : this.importedLibraries) {
            for (File exportFile : library.getApplicationExports(exportVariant)) {
                String exportName = exportFile.getName();
                if (!exportFile.exists()) {
                    System.err.println(exportFile.getName() + " is mentioned in export.txt, but it does not exist.");
                    continue;
                }
                if (exportFile.isDirectory()) {
                    Util.copyDir((File)exportFile, (File)new File(jarFolder, exportName));
                    continue;
                }
                if (exportName.toLowerCase().endsWith(".zip") || exportName.toLowerCase().endsWith(".jar")) {
                    Util.copyFile((File)exportFile, (File)new File(jarFolder, exportName));
                    jarList.append(exportName);
                    continue;
                }
                Util.copyFile((File)exportFile, (File)new File(jarFolder, exportName));
            }
        }
        Object exportClassPath = null;
        if (exportPlatform == 2) {
            exportClassPath = "$JAVAROOT/" + jarList.join(":$JAVAROOT/");
        } else if (exportPlatform == 1) {
            exportClassPath = jarList.join(",");
        } else if (exportPlatform == 3) {
            exportClassPath = "$APPDIR:$APPDIR/lib/" + jarList.join(":$APPDIR/lib/");
        }
        StringList runOptions = new StringList();
        if (Preferences.getBoolean((String)"run.options.memory") && !exportVariant.contains("arm")) {
            runOptions.append("-Xms" + Preferences.get((String)"run.options.memory.initial") + "m");
            runOptions.append("-Xmx" + Preferences.get((String)"run.options.memory.maximum") + "m");
        }
        runOptions.append("-Djna.nosys=true");
        if (exportPlatform == 1) {
            runOptions.append("-Djava.library.path=\"%EXEDIR%\\lib\"");
        }
        if ((javafx = this.findJavaFX()) != null) {
            String modulePath = exportPlatform == 2 ? "$APP_ROOT/Contents/Java/modules" : "lib/modules";
            for (String opt : JavaBuild.getArgsJavaFX(modulePath)) {
                runOptions.append(opt);
            }
        }
        if (exportPlatform == 2) {
            StringBuilder runOptionsXML = new StringBuilder();
            for (String opt : runOptions) {
                runOptionsXML.append("      <string>");
                runOptionsXML.append(opt);
                runOptionsXML.append("</string>");
                runOptionsXML.append('\n');
            }
            String PLIST_TEMPLATE = "Info.plist.tmpl";
            File plistTemplate = new File(this.sketch.getFolder(), PLIST_TEMPLATE);
            if (!plistTemplate.exists()) {
                plistTemplate = this.mode.getContentFile("application/" + PLIST_TEMPLATE);
            }
            StringBuilder sb = new StringBuilder(Util.loadFile((File)plistTemplate));
            this.replaceTags(sb, "jvm_runtime", (String)jvmRuntime);
            this.replaceTags(sb, "jvm_version", MIN_JAVA_VERSION);
            this.replaceTags(sb, "jvm_options_list", runOptionsXML.toString());
            this.replaceTags(sb, "sketch", this.sketch.getMainName());
            this.replaceTags(sb, "lsuipresentationmode", Preferences.getBoolean((String)"export.application.present") ? "4" : "0");
            this.replaceTags(sb, "lsarchitecturepriority", exportVariant.substring("macos-".length()));
            File plistFile = new File(dotAppFolder, "Contents/Info.plist");
            PrintWriter pw = PApplet.createWriter((File)plistFile);
            pw.print(sb);
            pw.flush();
            pw.close();
            String appPath = dotAppFolder.getAbsolutePath();
            if (Platform.isMacOS()) {
                if (MacPlatform.isXcodeInstalled()) {
                    ProcessHelper.ffs((String[])new String[]{"codesign", "--force", "--deep", "--sign", "-", appPath});
                } else {
                    System.err.println("Xcode not installed, install it and manually sign this app:");
                    System.err.println("codesign --force --deep --sign - " + appPath);
                }
            }
        } else if (exportPlatform == 1) {
            File buildFile = new File(destFolder, "launch4j-build.xml");
            System.out.println(buildFile);
            File configFile = new File(destFolder, "launch4j-config.xml");
            XML project = new XML("project");
            XML target = project.addChild("target");
            target.setString("name", "windows");
            XML taskdef = target.addChild("taskdef");
            taskdef.setString("name", "launch4j");
            taskdef.setString("classname", "net.sf.launch4j.ant.Launch4jTask");
            String launchPath = this.mode.getContentFile("application/launch4j").getAbsolutePath();
            taskdef.setString("classpath", launchPath + "/launch4j.jar:" + launchPath + "/lib/xstream.jar");
            XML launch4j = target.addChild("launch4j");
            launch4j.setString("configFile", configFile.getAbsolutePath());
            XML config = new XML("launch4jConfig");
            config.addChild("headerType").setContent("gui");
            config.addChild("dontWrapJar").setContent("true");
            config.addChild("downloadUrl").setContent("https://adoptium.net/");
            File exeFile = new File(destFolder, this.sketch.getName() + ".exe");
            config.addChild("outfile").setContent(exeFile.getAbsolutePath());
            File iconFile = this.mode.getContentFile("application/application.ico");
            config.addChild("icon").setContent(iconFile.getAbsolutePath());
            XML clazzPath = config.addChild("classPath");
            clazzPath.addChild("mainClass").setContent(this.sketch.getMainName());
            for (String jarName : jarList) {
                clazzPath.addChild("cp").setContent("lib/" + jarName);
            }
            XML jre = config.addChild("jre");
            if (embedJava) {
                jre.addChild("path").setContent("java;%PATH%");
            } else {
                jre.addChild("path").setContent("%PATH%");
            }
            jre.addChild("minVersion").setContent(MIN_JAVA_VERSION);
            for (String opt : runOptions) {
                jre.addChild("opt").setContent(opt);
            }
            config.save(configFile);
            project.save(buildFile);
            if (!this.buildWindowsLauncher(buildFile, "windows")) {
                return false;
            }
            configFile.delete();
            buildFile.delete();
        } else {
            File shellScript = new File(destFolder, this.sketch.getName());
            SketchCode[] pw = PApplet.createWriter((File)shellScript);
            pw.print("#!/bin/sh\n\n");
            pw.print("APPDIR=$(readlink -f \"$0\")\n");
            pw.print("APPDIR=$(dirname \"$APPDIR\")\n");
            if (embedJava) {
                pw.print("$APPDIR/java/bin/");
            }
            String runOptionsStr = runOptions.join(" ");
            pw.print("java " + runOptionsStr + " -Djava.library.path=\"$APPDIR:$APPDIR/lib\" -cp \"" + (String)exportClassPath + "\" " + this.sketch.getMainName() + " \"$@\"\n");
            pw.flush();
            pw.close();
            String shellPath = shellScript.getAbsolutePath();
            if (!Platform.isWindows()) {
                Runtime.getRuntime().exec(new String[]{"chmod", "+x", shellPath});
            }
        }
        File sourceFolder = new File(destFolder, "source");
        sourceFolder.mkdirs();
        for (SketchCode code : this.sketch.getCode()) {
            try {
                code.copyTo(new File(sourceFolder, code.getFileName()));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        String preprocFilename = this.sketch.getMainName() + ".java";
        File preprocFile = new File(this.srcFolder, preprocFilename);
        if (preprocFile.exists()) {
            Util.copyFile((File)preprocFile, (File)new File(sourceFolder, preprocFilename));
        } else {
            System.err.println("Could not copy source file: " + preprocFile.getAbsolutePath());
        }
        return true;
    }

    private void replaceTags(StringBuilder sb, String replacing, String replacement) {
        int index = 0;
        String tag = "@@" + replacing + "@@";
        while ((index = sb.indexOf(tag)) != -1) {
            sb.replace(index, index + tag.length(), replacement);
        }
    }

    public Library findJavaFX() {
        for (Library library : this.getImportedLibraries()) {
            if (!library.getName().equals("JavaFX")) continue;
            return library;
        }
        return null;
    }

    public static String[] getArgsJavaFX(String modulePath) {
        return new String[]{"--module-path", modulePath, "--add-modules", "javafx.base,javafx.graphics,javafx.swing", "--add-exports", "javafx.graphics/com.sun.javafx.geom=ALL-UNNAMED", "--add-exports", "javafx.graphics/com.sun.glass.ui=ALL-UNNAMED"};
    }

    protected boolean buildWindowsLauncher(File buildFile, String target) {
        Project p = new Project();
        String path = buildFile.getAbsolutePath().replace('\\', '/');
        p.setUserProperty("ant.file", path);
        p.setUserProperty("build.compiler", "extJavac");
        DefaultLogger errorLogger = new DefaultLogger();
        ByteArrayOutputStream errb = new ByteArrayOutputStream();
        PrintStream errp = new PrintStream(errb);
        errorLogger.setErrorPrintStream(errp);
        ByteArrayOutputStream outb = new ByteArrayOutputStream();
        PrintStream outp = new PrintStream(outb);
        errorLogger.setOutputPrintStream(outp);
        errorLogger.setMessageOutputLevel(2);
        p.addBuildListener((BuildListener)errorLogger);
        try {
            p.fireBuildStarted();
            p.init();
            ProjectHelper helper = ProjectHelper.getProjectHelper();
            p.addReference("ant.projectHelper", (Object)helper);
            helper.parse(p, (Object)buildFile);
            p.executeTarget(target);
            return true;
        }
        catch (BuildException e) {
            p.fireBuildFinished((Throwable)e);
            System.out.println(outb);
            System.err.println(errb);
            return false;
        }
    }

    protected void addManifest(ZipOutputStream zos) throws IOException {
        ZipEntry entry = new ZipEntry("META-INF/MANIFEST.MF");
        zos.putNextEntry(entry);
        String contents = "Manifest-Version: 1.0\nCreated-By: Processing " + Base.getVersionName() + "\nMain-Class: " + this.sketch.getMainName() + "\n";
        zos.write(contents.getBytes());
        zos.closeEntry();
    }

    protected void addClasses(ZipOutputStream zos, File dir) throws IOException {
        Object path = dir.getAbsolutePath();
        if (!((String)path).endsWith("/") && !((String)path).endsWith("\\")) {
            path = (String)path + "/";
        }
        this.addClasses(zos, dir, (String)path);
    }

    protected void addClasses(ZipOutputStream zos, File dir, String rootPath) throws IOException {
        File[] files = dir.listFiles((dir1, name) -> name.charAt(0) != '.');
        if (files != null) {
            for (File sub : files) {
                String relativePath = sub.getAbsolutePath().substring(rootPath.length());
                if (sub.isDirectory()) {
                    this.addClasses(zos, sub, rootPath);
                    continue;
                }
                if (!sub.getName().endsWith(".class")) continue;
                ZipEntry entry = new ZipEntry(relativePath);
                zos.putNextEntry(entry);
                PApplet.saveStream((OutputStream)zos, (InputStream)new FileInputStream(sub));
                zos.closeEntry();
            }
        }
    }

    protected void addDataFolder(ZipOutputStream zos) throws IOException {
        if (this.sketch.hasDataFolder()) {
            String[] dataFiles = Util.listFiles((File)this.sketch.getDataFolder(), (boolean)false);
            int offset = this.sketch.getFolder().getAbsolutePath().length() + 1;
            for (String path : dataFiles) {
                File dataFile;
                if (Platform.isWindows()) {
                    path = path.replace('\\', '/');
                }
                if ((dataFile = new File(path)).isDirectory() || dataFile.getName().charAt(0) == '.') continue;
                ZipEntry entry = new ZipEntry(path.substring(offset));
                zos.putNextEntry(entry);
                PApplet.saveStream((OutputStream)zos, (InputStream)new FileInputStream(dataFile));
                zos.closeEntry();
            }
        }
    }

    protected void packClassPathIntoZipFile(String path, ZipOutputStream zos, HashMap<String, Object> zipFileContents) throws IOException {
        String[] pieces;
        for (String piece : pieces = PApplet.split((String)path, (char)File.pathSeparatorChar)) {
            if (piece.length() == 0) continue;
            if (piece.toLowerCase().endsWith(".jar") || piece.toLowerCase().endsWith(".zip")) {
                try {
                    ZipFile file = new ZipFile(piece);
                    Enumeration<? extends ZipEntry> entries = file.entries();
                    while (entries.hasMoreElements()) {
                        int count;
                        String entryName;
                        ZipEntry entry = entries.nextElement();
                        if (entry.isDirectory() || (entryName = entry.getName()).indexOf("META-INF") == 0 || zipFileContents.get(entryName) != null) continue;
                        zipFileContents.put(entryName, new Object());
                        ZipEntry entree = new ZipEntry(entryName);
                        zos.putNextEntry(entree);
                        byte[] buffer = new byte[(int)entry.getSize()];
                        InputStream is = file.getInputStream(entry);
                        int offset = 0;
                        for (int remaining = buffer.length; remaining > 0; remaining -= count) {
                            count = is.read(buffer, offset, remaining);
                            offset += count;
                        }
                        zos.write(buffer);
                        zos.flush();
                        zos.closeEntry();
                    }
                    file.close();
                }
                catch (IOException e) {
                    System.err.println("Error in file " + piece);
                    e.printStackTrace();
                }
                continue;
            }
            File dir = new File(piece);
            if (!dir.exists()) continue;
            JavaBuild.packClassPathIntoZipFileRecursive(dir, null, zos);
        }
    }

    protected static void packClassPathIntoZipFileRecursive(File dir, String sofar, ZipOutputStream zos) throws IOException {
        String[] files = dir.list();
        if (files != null) {
            for (String filename : files) {
                String nowfar;
                if (filename.charAt(0) == '.') continue;
                File sub = new File(dir, filename);
                String string = nowfar = sofar == null ? filename : sofar + "/" + filename;
                if (sub.isDirectory()) {
                    JavaBuild.packClassPathIntoZipFileRecursive(sub, nowfar, zos);
                    continue;
                }
                if (filename.toLowerCase().endsWith(".jar") || filename.toLowerCase().endsWith(".zip") || filename.charAt(0) == '.') continue;
                ZipEntry entry = new ZipEntry(nowfar);
                zos.putNextEntry(entry);
                PApplet.saveStream((OutputStream)zos, (InputStream)new FileInputStream(sub));
                zos.closeEntry();
            }
        } else {
            System.err.println("Could not read from " + dir);
        }
    }
}

