/*
 * Decompiled with CFR 0.152.
 */
package processing.mode.java;

import java.awt.EventQueue;
import java.awt.Point;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.BitSet;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import javax.swing.DefaultListModel;
import processing.app.Messages;
import processing.app.Platform;
import processing.app.syntax.InputHandler;
import processing.app.syntax.PdeTextArea;
import processing.app.syntax.TextAreaDefaults;
import processing.app.ui.Editor;
import processing.mode.java.CompletionCandidate;
import processing.mode.java.CompletionGenerator;
import processing.mode.java.CompletionPanel;
import processing.mode.java.JavaEditor;
import processing.mode.java.JavaInputHandler;
import processing.mode.java.JavaMode;
import processing.mode.java.JavaTextAreaPainter;
import processing.mode.java.PreprocSketch;
import processing.mode.java.tweak.ColorControlBox;
import processing.mode.java.tweak.Handle;

public class JavaTextArea
extends PdeTextArea {
    private CompletionPanel suggestion;
    CompletionGenerator suggestionGenerator;
    volatile boolean suggestionRunning = false;
    volatile boolean suggestionRequested = false;
    protected ComponentListener[] baseCompListeners;
    protected MouseListener[] baseMouseListeners;
    protected MouseMotionListener[] baseMotionListeners;
    protected KeyListener[] baseKeyListeners;
    protected boolean tweakMode;

    public JavaTextArea(TextAreaDefaults defaults, JavaEditor editor) {
        super(defaults, (InputHandler)new JavaInputHandler(editor), (Editor)editor);
        this.suggestionGenerator = new CompletionGenerator((JavaMode)editor.getMode());
        this.tweakMode = false;
    }

    public JavaEditor getJavaEditor() {
        return (JavaEditor)this.editor;
    }

    protected JavaTextAreaPainter createPainter(TextAreaDefaults defaults) {
        return new JavaTextAreaPainter(this, defaults);
    }

    protected JavaTextAreaPainter getJavaPainter() {
        return (JavaTextAreaPainter)this.painter;
    }

    public void processKeyEvent(KeyEvent evt) {
        if (evt.getKeyCode() == 27) {
            if (this.suggestion != null && this.suggestion.isVisible()) {
                Messages.log((String)"ESC key");
                this.hideSuggestion();
                evt.consume();
                return;
            }
        } else if (evt.getKeyCode() == 10 && evt.getID() == 401 && this.suggestion != null && this.suggestion.isVisible() && this.suggestion.insertSelection(20)) {
            evt.consume();
            if (this.suggestion.isVisible()) {
                this.prepareSuggestions(evt);
            }
            return;
        }
        if (evt.getID() == 401) {
            switch (evt.getKeyCode()) {
                case 40: {
                    if (this.suggestion == null || !this.suggestion.isVisible()) break;
                    this.suggestion.moveDown();
                    return;
                }
                case 38: {
                    if (this.suggestion == null || !this.suggestion.isVisible()) break;
                    this.suggestion.moveUp();
                    return;
                }
                case 8: {
                    Messages.log((String)"BK Key");
                    break;
                }
                case 32: {
                    if (this.suggestion == null || !this.suggestion.isVisible()) break;
                    Messages.log((String)"Space bar, hide completion list");
                    this.suggestion.setInvisible();
                }
            }
        }
        super.processKeyEvent(evt);
        if (evt.getID() == 400) {
            this.processCompletionKeys(evt);
        } else if (!Platform.isMacOS() && evt.getID() == 402) {
            this.processCompletionKeys(evt);
        } else if (Platform.isMacOS() && evt.getID() == 402) {
            this.processControlSpace(evt);
        }
    }

    private void processControlSpace(KeyEvent event) {
        if (event.getKeyCode() == 32 && event.isControlDown() && JavaMode.codeCompletionsEnabled) {
            Messages.log((String)("[KeyEvent]" + KeyEvent.getKeyText(event.getKeyCode()) + "  |Prediction started"));
            this.fetchPhrase();
        }
    }

    private void processCompletionKeys(KeyEvent event) {
        char keyChar = event.getKeyChar();
        int keyCode = event.getKeyCode();
        if (keyChar != '\n' && keyChar != '\u001b' && keyChar != '\t' && (event.getID() != 402 || keyCode == 37 || keyCode == 39)) {
            if (keyChar == ')') {
                this.hideSuggestion();
            } else if (keyChar == '.') {
                if (JavaMode.codeCompletionsEnabled) {
                    Messages.log((String)("[KeyEvent]" + KeyEvent.getKeyText(event.getKeyCode()) + "  |Prediction started"));
                    this.fetchPhrase();
                }
            } else if (keyChar == ' ') {
                if (!Platform.isMacOS() && JavaMode.codeCompletionsEnabled && (event.isControlDown() || event.isMetaDown())) {
                    if (JavaMode.codeCompletionsEnabled) {
                        Messages.log((String)("[KeyEvent]" + event.getKeyChar() + "  |Prediction started"));
                        this.fetchPhrase();
                    }
                } else {
                    this.hideSuggestion();
                }
            } else if (JavaMode.codeCompletionsEnabled) {
                this.prepareSuggestions(event);
            }
        }
    }

    private void prepareSuggestions(KeyEvent evt) {
        if (JavaMode.codeCompletionsEnabled && (JavaMode.ccTriggerEnabled || this.suggestion != null && this.suggestion.isVisible())) {
            Messages.log((String)("[KeyEvent]" + evt.getKeyChar() + "  |Prediction started"));
            this.fetchPhrase();
        }
    }

    protected void fetchPhrase() {
        if (this.suggestionRunning) {
            this.suggestionRequested = true;
            return;
        }
        this.suggestionRunning = true;
        this.suggestionRequested = false;
        int caretPosition = this.getCaretPosition();
        if (caretPosition < 0) {
            this.suggestionRunning = false;
            return;
        }
        int caretLineIndex = this.getCaretLine();
        if (caretLineIndex < 0) {
            this.suggestionRunning = false;
            return;
        }
        String lineText = this.getLineText(caretLineIndex);
        if (lineText == null) {
            this.suggestionRunning = false;
            return;
        }
        int caretLinePosition = this.getCaretPosition() - this.getLineStartOffset(caretLineIndex);
        if (caretLinePosition <= 0) {
            this.suggestionRunning = false;
            return;
        }
        if (caretLinePosition > lineText.length()) {
            this.suggestionRunning = false;
            return;
        }
        String text = lineText.substring(0, caretLinePosition);
        int codeIndex = this.editor.getSketch().getCurrentCodeIndex();
        int lineStartOffset = this.editor.getTextArea().getLineStartOffset(caretLineIndex);
        this.getJavaEditor().getPreprocessingService().whenDone(ps -> {
            int lineNumber = ps.tabOffsetToJavaLine(codeIndex, lineStartOffset);
            DefaultListModel<CompletionCandidate> defListModel = null;
            try {
                Messages.log((String)"phrase parse start");
                String phrase = JavaTextArea.parsePhrase(text);
                Messages.log((String)("phrase: " + phrase));
                if (phrase != null) {
                    List<CompletionCandidate> candidates = this.suggestionGenerator.preparePredictions((PreprocSketch)ps, phrase, lineNumber);
                    if (!this.suggestionRequested && candidates != null && !candidates.isEmpty()) {
                        Collections.sort(candidates);
                        defListModel = CompletionGenerator.filterPredictions(candidates);
                        Messages.log((String)("Got: " + candidates.size() + " candidates, " + defListModel.size() + " filtered"));
                    }
                }
                String finalPhrase = phrase;
                DefaultListModel<CompletionCandidate> finalDefListModel = defListModel;
                EventQueue.invokeLater(() -> {
                    this.suggestionRunning = false;
                    if (this.suggestionRequested) {
                        Messages.log((String)"completion invalidated");
                        this.fetchPhrase();
                        return;
                    }
                    Messages.log((String)"completion finishing");
                    if (finalDefListModel != null) {
                        this.showSuggestion(finalDefListModel, finalPhrase);
                    } else {
                        this.hideSuggestion();
                    }
                });
            }
            catch (Exception e) {
                Messages.err((String)"error while preparing suggestions", (Throwable)e);
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String parsePhrase(String lineText) {
        boolean overloading;
        block44: {
            char lastChar;
            block43: {
                overloading = false;
                String trimmedLineText = lineText.trim();
                if (trimmedLineText.length() == 0) {
                    return null;
                }
                lastChar = trimmedLineText.charAt(trimmedLineText.length() - 1);
                if (lastChar != '.') break block43;
                if ((trimmedLineText = trimmedLineText.substring(0, trimmedLineText.length() - 1).trim()).length() == 0) {
                    return null;
                }
                lastChar = trimmedLineText.charAt(trimmedLineText.length() - 1);
                switch (lastChar) {
                    case '\"': 
                    case ')': 
                    case ']': {
                        break block44;
                    }
                    default: {
                        if (!Character.isJavaIdentifierPart(lastChar)) {
                            return null;
                        }
                        break block44;
                    }
                }
            }
            if (lastChar == '(') {
                overloading = true;
            } else if (!Character.isJavaIdentifierPart(lastChar)) {
                return null;
            }
        }
        int currentCharIndex = lineText.length() - 1;
        int commentStart = lineText.indexOf("//");
        if (commentStart >= 0 && currentCharIndex > commentStart) {
            return null;
        }
        BitSet isInLiteral = new BitSet(lineText.length());
        BitSet isInBrackets = new BitSet(lineText.length());
        boolean inString = false;
        boolean inChar = false;
        boolean inEscaped = false;
        for (int i = 0; i < lineText.length(); ++i) {
            block46: {
                block45: {
                    if (inEscaped) break block45;
                    switch (lineText.charAt(i)) {
                        case '\"': {
                            if (!inChar) {
                                inString = !inString;
                                break;
                            }
                            break block46;
                        }
                        case '\'': {
                            if (!inString) {
                                inChar = !inChar;
                                break;
                            }
                            break block46;
                        }
                        case '\\': {
                            if (inString || inChar) {
                                inEscaped = true;
                                break;
                            }
                            break block46;
                        }
                    }
                    break block46;
                }
                inEscaped = false;
            }
            isInLiteral.set(i, inString || inChar);
        }
        if (isInLiteral.get(currentCharIndex)) {
            return null;
        }
        int depth = overloading ? 1 : 0;
        int bracketStart = overloading ? lineText.length() : 0;
        int squareDepth = 0;
        int squareBracketStart = 0;
        block22: for (int i = lineText.length() - 1; i >= 0; --i) {
            if (isInLiteral.get(i)) continue;
            switch (lineText.charAt(i)) {
                case ')': {
                    if (depth == 0) {
                        bracketStart = i;
                    }
                    ++depth;
                    break;
                }
                case '(': {
                    if (--depth == 0) {
                        isInBrackets.set(i, bracketStart);
                        break;
                    }
                    if (depth >= 0) break;
                    break block22;
                }
                case ']': {
                    if (squareDepth == 0) {
                        squareBracketStart = i;
                    }
                    ++squareDepth;
                    break;
                }
                case '[': {
                    if (--squareDepth == 0) {
                        isInBrackets.set(i, squareBracketStart);
                        break;
                    }
                    if (squareDepth < 0) break block22;
                }
            }
        }
        if (depth > 0) {
            isInBrackets.set(0, bracketStart);
        }
        if (squareDepth > 0) {
            isInBrackets.set(0, squareBracketStart);
        }
        int position = currentCharIndex;
        block23: while (position >= 0) {
            char currChar = lineText.charAt(position);
            switch (currChar) {
                case '.': {
                    --position;
                    continue block23;
                }
                case '[': {
                    break block23;
                }
                case ')': 
                case ']': {
                    position = isInBrackets.previousClearBit(position - 1);
                    continue block23;
                }
                case '(': {
                    if (!isInBrackets.get(position)) break block23;
                    --position;
                    continue block23;
                }
                case '\"': {
                    position = isInLiteral.previousClearBit(position - 1);
                    break block23;
                }
                default: {
                    if (Character.isJavaIdentifierPart((int)currChar)) {
                        --position;
                        continue block23;
                    }
                    if (!Character.isWhitespace((int)currChar)) break block23;
                    --position;
                    continue block23;
                }
            }
        }
        String phrase = lineText.substring(++position).trim();
        Messages.log((String)phrase);
        if (phrase.length() != 0 && !Character.isDigit(phrase.charAt(0))) {
            return phrase;
        }
        return null;
    }

    protected void showSuggestion(DefaultListModel<CompletionCandidate> listModel, String subWord) {
        this.hideSuggestion();
        if (listModel.size() != 0) {
            int position = this.getCaretPosition();
            try {
                Point location = new Point(this.offsetToX(this.getCaretLine(), position - this.getLineStartOffset(this.getCaretLine())), this.lineToY(this.getCaretLine()) + this.getPainter().getLineHeight());
                this.suggestion = new CompletionPanel(this.getJavaEditor(), position, subWord, listModel, location);
                this.requestFocusInWindow();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            Messages.log((String)"TextArea: No suggestions to show.");
        }
    }

    public void hideSuggestion() {
        if (this.suggestion != null) {
            this.suggestion.setInvisible();
            this.suggestion = null;
        }
    }

    public void tweakRemoveListeners() {
        if (this.baseCompListeners == null) {
            this.baseCompListeners = this.painter.getComponentListeners();
            this.baseMouseListeners = this.painter.getMouseListeners();
            this.baseMotionListeners = this.painter.getMouseMotionListeners();
            this.baseKeyListeners = this.editor.getKeyListeners();
        }
        ComponentListener[] componentListeners = this.painter.getComponentListeners();
        MouseListener[] mouseListeners = this.painter.getMouseListeners();
        MouseMotionListener[] mouseMotionListeners = this.painter.getMouseMotionListeners();
        KeyListener[] keyListeners = this.editor.getKeyListeners();
        for (ComponentListener componentListener : componentListeners) {
            this.painter.removeComponentListener(componentListener);
        }
        for (EventListener eventListener : mouseListeners) {
            this.painter.removeMouseListener((MouseListener)eventListener);
        }
        for (EventListener eventListener : mouseMotionListeners) {
            this.painter.removeMouseMotionListener((MouseMotionListener)eventListener);
        }
        for (EventListener eventListener : keyListeners) {
            this.editor.removeKeyListener((KeyListener)eventListener);
        }
    }

    public void startTweakMode() {
        if (!this.tweakMode) {
            this.tweakRemoveListeners();
            this.getJavaPainter().startTweakMode();
            this.editable = false;
            this.caretBlinks = false;
            this.setCaretVisible(false);
            this.tweakMode = true;
        }
    }

    public void stopTweakMode() {
        if (this.tweakMode) {
            this.tweakRemoveListeners();
            this.tweakRestoreBaseListeners();
            this.getJavaPainter().stopTweakMode();
            this.editable = true;
            this.caretBlinks = true;
            this.setCaretVisible(true);
            this.tweakMode = false;
        }
    }

    private void tweakRestoreBaseListeners() {
        for (ComponentListener componentListener : this.baseCompListeners) {
            this.painter.addComponentListener(componentListener);
        }
        for (EventListener eventListener : this.baseMouseListeners) {
            this.painter.addMouseListener((MouseListener)eventListener);
        }
        for (EventListener eventListener : this.baseMotionListeners) {
            this.painter.addMouseMotionListener((MouseMotionListener)eventListener);
        }
        for (EventListener eventListener : this.baseKeyListeners) {
            this.editor.addKeyListener((KeyListener)eventListener);
        }
    }

    public void updateInterface(List<List<Handle>> handles, List<List<ColorControlBox>> colorBoxes) {
        this.getJavaPainter().updateTweakInterface(handles, colorBoxes);
    }
}

