/*
 * Decompiled with CFR 0.152.
 */
package processing.mode.java;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.JLabel;
import processing.app.Language;
import processing.app.ui.Editor;
import processing.app.ui.EditorButton;
import processing.app.ui.EditorToolbar;
import processing.mode.java.JavaEditor;
import processing.mode.java.debug.Debugger;

public class JavaToolbar
extends EditorToolbar {
    JavaEditor jeditor;
    EditorButton stepButton;
    EditorButton continueButton;

    public JavaToolbar(Editor editor) {
        super(editor);
        this.jeditor = (JavaEditor)editor;
    }

    private boolean isDebuggerArmed() {
        if (this.jeditor == null) {
            return false;
        }
        return this.jeditor.isDebuggerEnabled();
    }

    public List<EditorButton> createButtons() {
        boolean debug = this.isDebuggerArmed();
        ArrayList<EditorButton> outgoing = new ArrayList<EditorButton>();
        String runText = debug ? Language.text((String)"toolbar.debug") : Language.text((String)"toolbar.run");
        this.runButton = new EditorButton(this, "/lib/toolbar/run", runText, Language.text((String)"toolbar.present")){

            public void actionPerformed(ActionEvent e) {
                JavaToolbar.this.handleRun(e.getModifiers());
            }
        };
        outgoing.add(this.runButton);
        if (debug) {
            this.stepButton = new EditorButton(this, "/lib/toolbar/step", Language.text((String)"menu.debug.step"), Language.text((String)"menu.debug.step_into"), Language.text((String)"menu.debug.step_out")){

                public void actionPerformed(ActionEvent e) {
                    Debugger d = JavaToolbar.this.jeditor.getDebugger();
                    int modifiers = e.getModifiers() & 9;
                    if (modifiers == 0) {
                        d.stepOver();
                    } else if ((modifiers & 1) != 0) {
                        d.stepInto();
                    } else if ((modifiers & 8) != 0) {
                        d.stepOut();
                    }
                }
            };
            outgoing.add(this.stepButton);
            this.continueButton = new EditorButton(this, "/lib/toolbar/continue", Language.text((String)"menu.debug.continue")){

                public void actionPerformed(ActionEvent e) {
                    JavaToolbar.this.jeditor.getDebugger().continueDebug();
                }
            };
            outgoing.add(this.continueButton);
        }
        this.stopButton = new EditorButton(this, "/lib/toolbar/stop", Language.text((String)"toolbar.stop")){

            public void actionPerformed(ActionEvent e) {
                JavaToolbar.this.handleStop();
            }
        };
        outgoing.add(this.stopButton);
        return outgoing;
    }

    public void addModeButtons(Box box, JLabel label) {
        EditorButton debugButton = new EditorButton(this, "/lib/toolbar/debug", Language.text((String)"toolbar.debug")){

            public void actionPerformed(ActionEvent e) {
                JavaToolbar.this.jeditor.toggleDebug();
            }
        };
        if (this.isDebuggerArmed()) {
            debugButton.setSelected(true);
        }
        box.add((Component)debugButton);
        this.addGap(box);
    }

    public void handleRun(int modifiers) {
        boolean shift;
        boolean bl = shift = (modifiers & 1) != 0;
        if (shift) {
            this.jeditor.handlePresent();
        } else {
            this.jeditor.handleRun();
        }
    }

    public void handleStop() {
        this.jeditor.handleStop();
    }

    public void activateContinue() {
        this.continueButton.setSelected(true);
        this.repaint();
    }

    protected void deactivateContinue() {
        this.continueButton.setSelected(false);
        this.repaint();
    }

    protected void activateStep() {
        this.stepButton.setSelected(true);
        this.repaint();
    }

    protected void deactivateStep() {
        this.stepButton.setSelected(false);
        this.repaint();
    }
}

