/*
 * Decompiled with CFR 0.152.
 */
package processing.mode.java.lsp;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.eclipse.lsp4j.CompletionOptions;
import org.eclipse.lsp4j.InitializeParams;
import org.eclipse.lsp4j.InitializeResult;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.TextDocumentSyncKind;
import org.eclipse.lsp4j.jsonrpc.Launcher;
import org.eclipse.lsp4j.launch.LSPLauncher;
import org.eclipse.lsp4j.services.LanguageClient;
import org.eclipse.lsp4j.services.LanguageClientAware;
import org.eclipse.lsp4j.services.LanguageServer;
import org.eclipse.lsp4j.services.TextDocumentService;
import org.eclipse.lsp4j.services.WorkspaceService;
import processing.mode.java.lsp.PdeAdapter;
import processing.mode.java.lsp.PdeTextDocumentService;
import processing.mode.java.lsp.PdeWorkspaceService;

class PdeLanguageServer
implements LanguageServer,
LanguageClientAware {
    Map<File, PdeAdapter> adapters = new HashMap<File, PdeAdapter>();
    LanguageClient client = null;
    PdeTextDocumentService textDocumentService = new PdeTextDocumentService(this);
    PdeWorkspaceService workspaceService = new PdeWorkspaceService(this);

    PdeLanguageServer() {
    }

    public void exit() {
        System.out.println("exit");
    }

    public TextDocumentService getTextDocumentService() {
        return this.textDocumentService;
    }

    public WorkspaceService getWorkspaceService() {
        return this.workspaceService;
    }

    static Optional<String> lowerExtension(File file) {
        String s = file.toString();
        int dot = s.lastIndexOf(46);
        if (dot == -1) {
            return Optional.empty();
        }
        return Optional.of(s.substring(dot + 1).toLowerCase());
    }

    Optional<PdeAdapter> getAdapter(URI uri) {
        return PdeAdapter.uriToPath(uri).filter(file -> {
            String ext = PdeLanguageServer.lowerExtension(file).orElse("");
            return ext.equals("pde") || ext.equals("java");
        }).map(file -> {
            File rootDir = file.getParentFile();
            return this.adapters.computeIfAbsent(rootDir, _k -> new PdeAdapter(rootDir, this.client));
        });
    }

    public CompletableFuture<InitializeResult> initialize(InitializeParams params) {
        PdeAdapter.init();
        System.out.println("initialize");
        ServerCapabilities capabilities = new ServerCapabilities();
        capabilities.setTextDocumentSync(TextDocumentSyncKind.Full);
        CompletionOptions completionOptions = new CompletionOptions();
        completionOptions.setResolveProvider(Boolean.valueOf(true));
        completionOptions.setTriggerCharacters(List.of("."));
        capabilities.setCompletionProvider(completionOptions);
        capabilities.setDocumentFormattingProvider(Boolean.valueOf(true));
        capabilities.setDeclarationProvider(Boolean.valueOf(true));
        capabilities.setReferencesProvider(Boolean.valueOf(true));
        InitializeResult result = new InitializeResult(capabilities);
        return CompletableFuture.completedFuture(result);
    }

    public CompletableFuture<Object> shutdown() {
        System.out.println("shutdown");
        return CompletableFuture.completedFuture(null);
    }

    public void connect(LanguageClient client) {
        this.client = client;
    }

    public static void main(String[] args) {
        InputStream input = System.in;
        PrintStream output = System.out;
        System.setOut(System.err);
        PdeLanguageServer server = new PdeLanguageServer();
        Launcher launcher = LSPLauncher.createServerLauncher((LanguageServer)server, (InputStream)input, (OutputStream)output);
        LanguageClient client = (LanguageClient)launcher.getRemoteProxy();
        server.connect(client);
        launcher.startListening();
    }
}

