/*
 * Decompiled with CFR 0.152.
 */
package processing.mode.java.lsp;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.lsp4j.Location;
import processing.app.SketchCode;
import processing.mode.java.ASTUtils;
import processing.mode.java.PreprocSketch;
import processing.mode.java.SketchInterval;
import processing.mode.java.lsp.PdeAdapter;

public class PdeSymbolFinder {
    public static List<? extends Location> searchDeclaration(PreprocSketch ps, int javaOffset) {
        SimpleName declarationName;
        CompilationUnit root = ps.compilationUnit;
        SimpleName simpleName = ASTUtils.getSimpleNameAt((ASTNode)root, javaOffset, javaOffset);
        if (simpleName == null) {
            System.out.println("no simple name found at location");
            return Collections.emptyList();
        }
        IBinding binding = ASTUtils.resolveBinding(simpleName);
        if (binding == null) {
            System.out.println("binding not resolved");
            return Collections.emptyList();
        }
        String key = binding.getKey();
        ASTNode declarationNode = ps.compilationUnit.findDeclaringNode(key);
        if (declarationNode == null) {
            System.out.println("declaration not found");
            return Collections.emptyList();
        }
        switch (binding.getKind()) {
            case 2: {
                SimpleName simpleName2 = ((TypeDeclaration)declarationNode).getName();
                break;
            }
            case 4: {
                SimpleName simpleName2 = ((MethodDeclaration)declarationNode).getName();
                break;
            }
            case 3: {
                SimpleName simpleName2 = ((VariableDeclaration)declarationNode).getName();
                break;
            }
            default: {
                SimpleName simpleName2 = declarationName = null;
            }
        }
        if (declarationName == null) {
            System.out.println("declaration name not found " + declarationNode);
            return Collections.emptyList();
        }
        if (!declarationName.equals((Object)simpleName)) {
            System.out.println("found declaration, name: " + declarationName);
        } else {
            System.out.println("already at declaration");
        }
        SketchInterval si = ps.mapJavaToSketch((ASTNode)declarationName);
        if (si == SketchInterval.BEFORE_START) {
            System.out.println("declaration is outside of the sketch");
            return Collections.emptyList();
        }
        ArrayList<Location> declarationList = new ArrayList<Location>();
        declarationList.add(PdeSymbolFinder.findLocation(ps, si));
        return declarationList;
    }

    public static List<? extends Location> searchReference(PreprocSketch ps, int javaOffset) {
        CompilationUnit root = ps.compilationUnit;
        SimpleName simpleName = ASTUtils.getSimpleNameAt((ASTNode)root, javaOffset, javaOffset);
        if (simpleName == null) {
            System.out.println("no simple name found at location");
            return Collections.emptyList();
        }
        IBinding binding = ASTUtils.resolveBinding(simpleName);
        if (binding == null) {
            System.out.println("binding not resolved");
            return Collections.emptyList();
        }
        String bindingKey = binding.getKey();
        List referenceIntervals = ASTUtils.findAllOccurrences((ASTNode)ps.compilationUnit, bindingKey).stream().map(ps::mapJavaToSketch).filter(ps::inRange).filter(in -> in.startPdeOffset < in.stopPdeOffset).collect(Collectors.toList());
        ArrayList<Location> referenceList = new ArrayList<Location>();
        for (SketchInterval referenceInterval : referenceIntervals) {
            referenceList.add(PdeSymbolFinder.findLocation(ps, referenceInterval));
        }
        return referenceList;
    }

    private static Location findLocation(PreprocSketch ps, SketchInterval si) {
        SketchCode code = ps.sketch.getCode(si.tabIndex);
        String program = code.getProgram();
        URI uri = PdeAdapter.pathToUri(code.getFile());
        return PdeAdapter.toLocation(program, si.startTabOffset, si.stopTabOffset, uri);
    }
}

