/*
 * Decompiled with CFR 0.152.
 */
package processing.mode.java.preproc;

import java.util.Optional;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import processing.mode.java.SourceUtil;
import processing.mode.java.preproc.PdePreprocessIssue;
import processing.mode.java.preproc.PreprocessIssueMessageSimplifier;

public class PdeIssueEmitter
extends BaseErrorListener {
    private final PdePreprocessIssueListener listener;
    private final Optional<SourceEmitter> sourceMaybe;

    public PdeIssueEmitter(PdePreprocessIssueListener newListener) {
        this.listener = newListener;
        this.sourceMaybe = Optional.empty();
    }

    public PdeIssueEmitter(PdePreprocessIssueListener newListener, SourceEmitter newSourceEmitter) {
        this.listener = newListener;
        this.sourceMaybe = Optional.of(newSourceEmitter);
    }

    public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
        PreprocessIssueMessageSimplifier facade = PreprocessIssueMessageSimplifier.get();
        IssueMessageSimplification simplification = facade.simplify(msg);
        IssueLocation issueLocation = this.sourceMaybe.isPresent() ? IssueLocationFactory.getLineWithOffset(simplification, line, charPositionInLine, this.sourceMaybe.get().getSource()) : new IssueLocation(line, charPositionInLine);
        this.listener.onIssue(new PdePreprocessIssue(issueLocation.getLine(), issueLocation.getCharPosition(), simplification.getMessage()));
    }

    public static interface PdePreprocessIssueListener {
        public void onIssue(PdePreprocessIssue var1);
    }

    public static class IssueMessageSimplification {
        private final String message;
        private final boolean attributeToPriorToken;

        public IssueMessageSimplification(String newMessage) {
            this.message = newMessage;
            this.attributeToPriorToken = false;
        }

        public IssueMessageSimplification(String newMessage, boolean newAttributeToPriorToken) {
            this.message = newMessage;
            this.attributeToPriorToken = newAttributeToPriorToken;
        }

        public String getMessage() {
            return this.message;
        }

        public boolean getAttributeToPriorToken() {
            return this.attributeToPriorToken;
        }
    }

    public static interface SourceEmitter {
        public String getSource();
    }

    public static class IssueLocationFactory {
        public static IssueLocation getLineWithOffset(IssueMessageSimplification simplification, int originalLine, int originalOffset, String source) {
            int linesOffset;
            int startOfMatch;
            boolean shouldAttributeToPrior = simplification.getAttributeToPriorToken();
            boolean bl = shouldAttributeToPrior = shouldAttributeToPrior && originalLine != 0;
            if (!shouldAttributeToPrior) {
                return new IssueLocation(originalLine, originalOffset);
            }
            String priorCode = IssueLocationFactory.getContentsUpToLine(source, originalLine);
            PreprocessIssueMessageSimplifier.PriorTokenFinder finder = new PreprocessIssueMessageSimplifier.PriorTokenFinder();
            int charPos = priorCode.length();
            while (!finder.isDone() && charPos > 0) {
                finder.step(priorCode.charAt(--charPos));
            }
            Optional<Integer> foundStartOfMatchMaybe = finder.getTokenPositionMaybe();
            if (foundStartOfMatchMaybe.isPresent()) {
                startOfMatch = priorCode.length() - foundStartOfMatchMaybe.get();
                String contentsOfMatch = priorCode.substring(startOfMatch);
                linesOffset = SourceUtil.getCount(contentsOfMatch, "\n");
            } else {
                startOfMatch = priorCode.length();
                linesOffset = 0;
            }
            String contentsPriorToMatch = priorCode.substring(0, startOfMatch);
            int newLine = originalLine - linesOffset;
            int lengthIncludingLine = contentsPriorToMatch.length();
            int lengthExcludingLine = contentsPriorToMatch.lastIndexOf(10);
            int lineLength = lengthIncludingLine - lengthExcludingLine;
            int col = lineLength - 1;
            return new IssueLocation(newLine, col);
        }

        private static String getContentsUpToLine(String source, int endLineExclusive) {
            int stringCursor;
            int line = 0;
            int strLength = source.length();
            for (stringCursor = 0; line < endLineExclusive - 1 && stringCursor < strLength; ++stringCursor) {
                if (source.charAt(stringCursor) != '\n') continue;
                ++line;
            }
            return source.substring(0, stringCursor);
        }
    }

    public static class IssueLocation {
        private final int line;
        private final int charPosition;

        public IssueLocation(int newLine, int newCharPosition) {
            this.line = newLine;
            this.charPosition = newCharPosition;
        }

        public int getLine() {
            return this.line;
        }

        public int getCharPosition() {
            return this.charPosition;
        }
    }
}

