/*
 * Decompiled with CFR 0.152.
 */
package processing.mode.java.preproc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import processing.mode.java.ImportStatement;
import processing.mode.java.TextTransform;
import processing.mode.java.preproc.PdePreprocessIssue;
import processing.mode.java.preproc.PdePreprocessor;

public class PreprocessorResult {
    private final int headerOffset;
    private final String className;
    private final List<ImportStatement> importStatements;
    private final PdePreprocessor.Mode programType;
    private final List<TextTransform.Edit> edits;
    private final List<PdePreprocessIssue> preprocessIssues;
    private final String sketchWidth;
    private final String sketchHeight;
    private final String sketchRenderer;

    public static PreprocessorResult reportPreprocessIssues(List<PdePreprocessIssue> newPreprocessIssues) {
        assert (newPreprocessIssues.size() > 0);
        return new PreprocessorResult(newPreprocessIssues);
    }

    public PreprocessorResult(PdePreprocessor.Mode newProgramType, int newHeaderOffset, String newClassName, List<ImportStatement> newImportStatements, List<TextTransform.Edit> newEdits, String newSketchWidth, String newSketchHeight, String newSketchRenderer) {
        if (newClassName == null) {
            throw new RuntimeException("Could not find main class");
        }
        this.headerOffset = newHeaderOffset;
        this.className = newClassName;
        this.importStatements = newImportStatements;
        this.programType = newProgramType;
        this.edits = newEdits;
        this.preprocessIssues = new ArrayList<PdePreprocessIssue>();
        this.sketchWidth = newSketchWidth;
        this.sketchHeight = newSketchHeight;
        this.sketchRenderer = newSketchRenderer;
    }

    public PreprocessorResult(PdePreprocessor.Mode newProgramType, int newHeaderOffset, String newClassName, List<ImportStatement> newImportStatements, List<TextTransform.Edit> newEdits, String newSketchWidth, String newSketchHeight, String newSketchRenderer, List<PdePreprocessIssue> newPreprocessIssues) {
        if (newClassName == null) {
            throw new RuntimeException("Could not find main class");
        }
        this.headerOffset = newHeaderOffset;
        this.className = newClassName;
        this.importStatements = newImportStatements;
        this.programType = newProgramType;
        this.edits = newEdits;
        this.preprocessIssues = newPreprocessIssues;
        this.sketchWidth = newSketchWidth;
        this.sketchHeight = newSketchHeight;
        this.sketchRenderer = newSketchRenderer;
    }

    private PreprocessorResult(List<PdePreprocessIssue> newPreprocessIssues) {
        this.preprocessIssues = Collections.unmodifiableList(newPreprocessIssues);
        this.headerOffset = 0;
        this.className = "unknown";
        this.programType = PdePreprocessor.Mode.STATIC;
        this.edits = new ArrayList<TextTransform.Edit>();
        this.importStatements = new ArrayList<ImportStatement>();
        this.sketchWidth = null;
        this.sketchHeight = null;
        this.sketchRenderer = null;
    }

    public List<PdePreprocessIssue> getPreprocessIssues() {
        return this.preprocessIssues;
    }

    public int getHeaderOffset() {
        return this.headerOffset;
    }

    public String getClassName() {
        return this.className;
    }

    public PdePreprocessor.Mode getProgramType() {
        return this.programType;
    }

    public List<TextTransform.Edit> getEdits() {
        return this.edits;
    }

    public List<ImportStatement> getImportStatements() {
        return this.importStatements;
    }

    public String getSketchWidth() {
        return this.sketchWidth;
    }

    public String getSketchHeight() {
        return this.sketchHeight;
    }

    public String getSketchRenderer() {
        return this.sketchRenderer;
    }
}

