/**
 * Mouse Signals 
 * 
 * Move and click the mouse to generate signals. 
 * The top row is the signal from "mouseX", 
 * the middle row is the signal from "mouseY",
 * and the bottom row is the signal from "mousePressed". 
 */
 
int[] xvals;
int[] yvals;
int[] bvals;

void setup() {
  size(640, 360);
  noSmooth();
  xvals = new int[width];
  yvals = new int[width];
  bvals = new int[width];
}

void draw() {
  background(102);
  
  for (int i = 1; i < width; i++) { 
    xvals[i-1] = xvals[i]; 
    yvals[i-1] = yvals[i];
    bvals[i-1] = bvals[i];
  } 
  // Add the new values to the end of the array 
  xvals[width-1] = mouseX; 
  yvals[width-1] = mouseY;
  
  if (mousePressed == true) {
    bvals[width-1] = 0;
  } else {
    bvals[width-1] = height/3;
  }
  
  fill(255);
  noStroke();
  rect(0, height/3, width, height/3+1);

  for(int i = 1; i < width; i++) {
    // Draw the x-values
    stroke(255);
    point(i, map(xvals[i], 0, width, 0, height/3-1));
    
    // Draw the y-values
    stroke(0);
    point(i, height/3+yvals[i]/3);
    
    // Draw the mouse presses
    stroke(255);
    line(i, (2*height/3) + bvals[i], i, (2*height/3) + bvals[i-1]);
  }
}
