/*
 * Decompiled with CFR 0.152.
 */
package atlantafx.base.controls;

import atlantafx.base.controls.Message;
import atlantafx.base.controls.TileSkinBase;
import atlantafx.base.theme.Styles;
import javafx.beans.value.ObservableValue;
import javafx.css.PseudoClass;
import javafx.event.Event;
import javafx.geometry.Bounds;
import javafx.geometry.HPos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.layout.StackPane;

public class MessageSkin
extends TileSkinBase<Message> {
    protected static final PseudoClass CLOSEABLE = PseudoClass.getPseudoClass((String)"closeable");
    protected final StackPane closeButton = new StackPane();
    protected final StackPane closeButtonIcon = new StackPane();

    public MessageSkin(Message control) {
        super(control);
        this.pseudoClassStateChanged(Styles.STATE_INTERACTIVE, control.getActionHandler() != null);
        this.registerChangeListener((ObservableValue)control.actionHandlerProperty(), o -> this.pseudoClassStateChanged(Styles.STATE_INTERACTIVE, ((Message)this.getSkinnable()).getActionHandler() != null));
        this.container.setOnMouseClicked(e -> {
            if (((Message)this.getSkinnable()).getActionHandler() != null) {
                ((Message)this.getSkinnable()).getActionHandler().run();
            }
        });
        this.closeButton.getStyleClass().add((Object)"close-button");
        this.closeButton.getChildren().setAll((Object[])new Node[]{this.closeButtonIcon});
        this.closeButton.setOnMouseClicked(e -> this.handleClose());
        this.closeButton.setVisible(control.getOnClose() != null);
        this.closeButton.setManaged(control.getOnClose() != null);
        this.closeButtonIcon.getStyleClass().add((Object)"icon");
        this.getChildren().add((Object)this.closeButton);
        this.pseudoClassStateChanged(CLOSEABLE, control.getOnClose() != null);
        this.registerChangeListener((ObservableValue)control.onCloseProperty(), o -> {
            this.closeButton.setVisible(((Message)this.getSkinnable()).getOnClose() != null);
            this.closeButton.setManaged(((Message)this.getSkinnable()).getOnClose() != null);
            this.pseudoClassStateChanged(CLOSEABLE, ((Message)this.getSkinnable()).onCloseProperty() != null);
        });
    }

    protected void handleClose() {
        if (((Message)this.getSkinnable()).getOnClose() != null) {
            ((Message)this.getSkinnable()).getOnClose().handle(new Event(Event.ANY));
        }
    }

    protected void layoutChildren(double x, double y, double w, double h) {
        if (this.closeButton.isManaged()) {
            Bounds lb = this.closeButton.getLayoutBounds();
            this.layoutInArea((Node)this.closeButton, w - lb.getWidth() - 5.0, 5.0, lb.getWidth(), lb.getHeight(), -1.0, HPos.RIGHT, VPos.TOP);
        }
        this.layoutInArea((Node)this.container, x, y, w, h, -1.0, HPos.CENTER, VPos.CENTER);
    }

    @Override
    public void dispose() {
        this.unregisterChangeListeners((ObservableValue)((Message)this.getSkinnable()).actionHandlerProperty());
        this.unregisterChangeListeners((ObservableValue)((Message)this.getSkinnable()).onCloseProperty());
        super.dispose();
    }
}

