/*
 * Decompiled with CFR 0.152.
 */
package atlantafx.base.controls;

import atlantafx.base.controls.Notification;
import atlantafx.base.controls.SlotListener;
import java.util.List;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.Event;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Control;
import javafx.scene.control.SkinBase;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import javafx.scene.text.TextFlow;

public class NotificationSkin
extends SkinBase<Notification> {
    protected final VBox container = new VBox();
    protected final HBox header = new HBox();
    protected final StackPane graphicSlot = new StackPane();
    protected final ChangeListener<Node> graphicSlotListener = new SlotListener((Pane)this.graphicSlot);
    protected final TextFlow messageText = new TextFlow();
    protected final StackPane closeButton = new StackPane();
    protected final StackPane closeButtonIcon = new StackPane();
    protected final StackPane menuButton = new StackPane();
    protected final StackPane menuButtonIcon = new StackPane();
    protected final ContextMenu actionsMenu = new ContextMenu();
    protected final HBox actionsBox = new HBox();
    protected final ButtonBar buttonBar = new ButtonBar();

    protected NotificationSkin(Notification control) {
        super((Control)control);
        this.graphicSlot.getStyleClass().add((Object)"graphic");
        control.graphicProperty().addListener(this.graphicSlotListener);
        this.graphicSlotListener.changed(control.graphicProperty(), null, (Object)control.getGraphic());
        this.messageText.getStyleClass().add((Object)"message");
        HBox.setHgrow((Node)this.messageText, (Priority)Priority.ALWAYS);
        this.setMessageText();
        this.registerChangeListener((ObservableValue)control.messageProperty(), o -> this.setMessageText());
        this.messageText.setMaxWidth(Double.MAX_VALUE);
        this.messageText.setMinHeight(Double.NEGATIVE_INFINITY);
        this.menuButton.getStyleClass().add((Object)"secondary-menu-button");
        this.menuButton.getChildren().setAll((Object[])new Node[]{this.menuButtonIcon});
        this.menuButton.setOnMouseClicked(e -> this.actionsMenu.show((Node)this.menuButton, this.menuButton.localToScreen(this.menuButton.getLayoutBounds()).getMinX(), this.menuButton.localToScreen(this.menuButton.getLayoutBounds()).getMaxY()));
        this.menuButton.setVisible(!((Notification)this.getSkinnable()).getSecondaryActions().isEmpty());
        this.menuButton.setManaged(!((Notification)this.getSkinnable()).getSecondaryActions().isEmpty());
        this.menuButtonIcon.getStyleClass().add((Object)"icon");
        Bindings.bindContent((List)this.actionsMenu.getItems(), ((Notification)this.getSkinnable()).getSecondaryActions());
        this.registerListChangeListener(this.actionsMenu.getItems(), o -> {
            this.menuButton.setVisible(!((Notification)this.getSkinnable()).getSecondaryActions().isEmpty());
            this.menuButton.setManaged(!((Notification)this.getSkinnable()).getSecondaryActions().isEmpty());
        });
        this.closeButton.getStyleClass().add((Object)"close-button");
        this.closeButton.getChildren().setAll((Object[])new Node[]{this.closeButtonIcon});
        this.closeButton.setOnMouseClicked(e -> this.handleClose());
        this.closeButton.setVisible(control.getOnClose() != null);
        this.closeButton.setManaged(control.getOnClose() != null);
        this.closeButtonIcon.getStyleClass().add((Object)"icon");
        this.registerChangeListener((ObservableValue)control.onCloseProperty(), o -> {
            this.closeButton.setVisible(((Notification)this.getSkinnable()).getOnClose() != null);
            this.closeButton.setManaged(((Notification)this.getSkinnable()).getOnClose() != null);
        });
        this.actionsBox.getStyleClass().add((Object)"actions");
        this.actionsBox.getChildren().setAll((Object[])new Node[]{this.menuButton, this.closeButton});
        this.actionsBox.setFillHeight(false);
        HBox.setMargin((Node)this.actionsBox, (Insets)new Insets(-8.0, -8.0, 0.0, 0.0));
        this.graphicSlot.setMinWidth(Double.NEGATIVE_INFINITY);
        this.actionsBox.setMinWidth(Double.NEGATIVE_INFINITY);
        this.header.setFillHeight(false);
        this.header.getStyleClass().add((Object)"header");
        this.header.getChildren().setAll((Object[])new Node[]{this.graphicSlot, this.messageText, this.actionsBox});
        this.header.setAlignment(Pos.TOP_LEFT);
        this.buttonBar.getStyleClass().add((Object)"button-bar");
        this.buttonBar.setVisible(!((Notification)this.getSkinnable()).getPrimaryActions().isEmpty());
        this.buttonBar.setManaged(!((Notification)this.getSkinnable()).getPrimaryActions().isEmpty());
        Bindings.bindContent((List)this.buttonBar.getButtons(), ((Notification)this.getSkinnable()).getPrimaryActions());
        this.registerListChangeListener(this.buttonBar.getButtons(), o -> {
            this.buttonBar.setVisible(!((Notification)this.getSkinnable()).getPrimaryActions().isEmpty());
            this.buttonBar.setManaged(!((Notification)this.getSkinnable()).getPrimaryActions().isEmpty());
        });
        this.container.getChildren().setAll((Object[])new Node[]{this.header, this.buttonBar});
        this.container.getStyleClass().add((Object)"container");
        this.getChildren().setAll((Object[])new Node[]{this.container});
    }

    protected void setMessageText() {
        if (!this.messageText.getChildren().isEmpty()) {
            this.messageText.getChildren().clear();
        }
        if (((Notification)this.getSkinnable()).getMessage() != null && !((Notification)this.getSkinnable()).getMessage().isBlank()) {
            this.messageText.getChildren().setAll((Object[])new Node[]{new Text(((Notification)this.getSkinnable()).getMessage())});
        }
    }

    protected void handleClose() {
        if (((Notification)this.getSkinnable()).getOnClose() != null) {
            ((Notification)this.getSkinnable()).getOnClose().handle(new Event(Event.ANY));
        }
    }

    protected double calcHeight() {
        double messageHeight = this.messageText.getBoundsInLocal().getHeight();
        return Math.max(Math.max(this.graphicSlot.getHeight(), this.actionsBox.getHeight()), messageHeight) + (this.buttonBar.isManaged() ? this.buttonBar.getHeight() + this.container.getSpacing() : 0.0) + this.header.getPadding().getTop() + this.header.getPadding().getBottom() + this.container.getPadding().getTop() + this.container.getPadding().getBottom();
    }

    protected double computeMinHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return this.calcHeight();
    }

    public void dispose() {
        Bindings.unbindContent((Object)this.actionsMenu.getItems(), ((Notification)this.getSkinnable()).getSecondaryActions());
        this.unregisterListChangeListeners(this.actionsMenu.getItems());
        Bindings.unbindContent((Object)this.buttonBar.getButtons(), ((Notification)this.getSkinnable()).getPrimaryActions());
        this.unregisterListChangeListeners(this.buttonBar.getButtons());
        ((Notification)this.getSkinnable()).graphicProperty().removeListener(this.graphicSlotListener);
        this.unregisterChangeListeners((ObservableValue)((Notification)this.getSkinnable()).messageProperty());
        this.unregisterChangeListeners((ObservableValue)((Notification)this.getSkinnable()).onCloseProperty());
        super.dispose();
    }
}

