/*
 * Decompiled with CFR 0.152.
 */
package atlantafx.base.util;

import java.text.DecimalFormat;
import javafx.application.Platform;
import javafx.event.EventHandler;
import javafx.scene.control.Spinner;
import javafx.scene.control.SpinnerValueFactory;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.util.StringConverter;

public class DoubleStringConverter
extends StringConverter<Double> {
    private final DecimalFormat decimalFormat = new DecimalFormat("0.##");
    private Runnable reset;

    public DoubleStringConverter() {
    }

    public DoubleStringConverter(Runnable reset) {
        this.reset = reset;
    }

    public DoubleStringConverter(TextField input, double min, double max) {
        if (input == null) {
            throw new NullPointerException("Input cannot be null!");
        }
        double resetValue = Math.min(Math.max(0.0, min), max);
        this.reset = () -> input.setText(this.decimalFormat.format(resetValue));
        input.textProperty().addListener((ov, oldValue, newValue) -> {
            if (newValue == null || newValue.isEmpty()) {
                return;
            }
            if (min < 0.0 && newValue.endsWith("-")) {
                if (newValue.length() > 1) {
                    Platform.runLater(() -> input.setText("-"));
                }
                return;
            }
            try {
                Double.parseDouble(newValue);
            }
            catch (NumberFormatException e) {
                Platform.runLater(() -> input.setText(oldValue));
            }
        });
        EventHandler oldHandler = input.getOnAction();
        input.setOnAction(t -> {
            double restricted;
            double value = this.fromString(input.getText());
            if (value != (restricted = Math.min(Math.max(value, min), max))) {
                input.setText(this.decimalFormat.format(restricted));
            }
            if (oldHandler != null) {
                oldHandler.handle(t);
            }
        });
    }

    public static DoubleStringConverter createFor(Spinner<Double> spinner) {
        SpinnerValueFactory.DoubleSpinnerValueFactory factory = (SpinnerValueFactory.DoubleSpinnerValueFactory)spinner.getValueFactory();
        DoubleStringConverter converter = new DoubleStringConverter(spinner.getEditor(), factory.getMin(), factory.getMax());
        factory.setConverter((StringConverter)converter);
        spinner.setTooltip(new Tooltip(String.format("Enter a value between %.2f and %.2f", factory.getMin(), factory.getMax())));
        return converter;
    }

    public void setReset(Runnable reset) {
        this.reset = reset;
    }

    public Double fromString(String s) {
        if (s == null || s.isEmpty()) {
            if (this.reset != null) {
                this.reset.run();
            }
            return 0.0;
        }
        try {
            return Double.valueOf(s);
        }
        catch (NumberFormatException e) {
            if (this.reset != null) {
                this.reset.run();
            }
            return 0.0;
        }
    }

    public String toString(Double value) {
        if (value == null) {
            return "0";
        }
        return this.decimalFormat.format(value);
    }
}

