/*
 * Decompiled with CFR 0.152.
 */
package atlantafx.base.util;

import java.util.function.UnaryOperator;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ReadOnlyStringProperty;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.util.StringConverter;

public class PasswordTextFormatter
extends TextFormatter<String> {
    public static final char BULLET = '\u2731';

    protected PasswordTextFormatter(StringConverter<String> valueConverter, UnaryOperator<TextFormatter.Change> filter, TextField field, char bullet) {
        super(valueConverter, null, filter);
        if (valueConverter == null) {
            throw new NullPointerException("StringConverter cannot be null!");
        }
        if (filter == null) {
            throw new NullPointerException("UnaryOperator cannot be null!");
        }
        if (field == null) {
            throw new NullPointerException("TextField cannot be null!");
        }
        PasswordFilter passwordFilter = (PasswordFilter)this.getFilter();
        passwordFilter.setBullet(bullet);
        passwordFilter.setInitialText(field.getText());
        this.revealPasswordProperty().addListener((obs, old, val) -> {
            if (val == null) {
                return;
            }
            field.positionCaret(0);
            field.commitValue();
        });
        Platform.runLater(() -> ((TextField)field).commitValue());
    }

    public ReadOnlyStringProperty passwordProperty() {
        return ((PasswordFilter)this.getFilter()).password.getReadOnlyProperty();
    }

    public String getPassword() {
        return (String)this.passwordProperty().get();
    }

    public BooleanProperty revealPasswordProperty() {
        return ((PasswordFilter)this.getFilter()).revealPassword;
    }

    public boolean getRevealPassword() {
        return this.revealPasswordProperty().get();
    }

    public void setRevealPassword(boolean reveal) {
        this.revealPasswordProperty().set(reveal);
    }

    public static PasswordTextFormatter create(TextField field, char bullet) {
        PasswordFilter filter = new PasswordFilter();
        PasswordStringConverter converter = new PasswordStringConverter(filter);
        PasswordTextFormatter formatter = new PasswordTextFormatter(converter, filter, field, bullet);
        field.setTextFormatter((TextFormatter)formatter);
        return formatter;
    }

    public static PasswordTextFormatter create(TextField textField) {
        return PasswordTextFormatter.create(textField, '\u2731');
    }

    protected static class PasswordFilter
    implements UnaryOperator<TextFormatter.Change> {
        protected final ReadOnlyStringWrapper password = new ReadOnlyStringWrapper("");
        protected final BooleanProperty revealPassword = new SimpleBooleanProperty(false);
        protected final StringBuilder sb = new StringBuilder();
        protected char bullet = (char)10033;

        protected PasswordFilter() {
        }

        @Override
        public TextFormatter.Change apply(TextFormatter.Change change) {
            if (change.isReplaced()) {
                this.sb.replace(change.getRangeStart(), change.getRangeEnd(), change.getText());
            } else if (change.isDeleted()) {
                this.sb.delete(change.getRangeStart(), change.getRangeEnd());
            } else if (change.isAdded()) {
                if (change.getRangeStart() == this.sb.length()) {
                    this.sb.append(change.getText());
                } else {
                    this.sb.insert(change.getRangeStart(), change.getText());
                }
            }
            if (change.getText() != null && !change.getText().isEmpty() && !this.revealPassword.get()) {
                change.setText(this.maskText(change.getText().length()));
            }
            this.password.set(this.sb.toString());
            return change;
        }

        protected void setBullet(char bullet) {
            this.bullet = bullet;
        }

        protected String maskText(int length) {
            return String.valueOf(this.bullet).repeat(length);
        }

        protected void setInitialText(String text) {
            if (text != null && !text.isEmpty()) {
                this.sb.append(text);
                this.password.set(this.sb.toString());
            }
        }
    }

    protected static class PasswordStringConverter
    extends StringConverter<String> {
        protected final PasswordFilter filter;

        public PasswordStringConverter(PasswordFilter filter) {
            this.filter = filter;
        }

        public String toString(String s) {
            return this.getPassword();
        }

        public String fromString(String s) {
            return this.getPassword();
        }

        protected String getPassword() {
            String password = this.filter.password.get();
            return this.filter.revealPassword.get() ? password : this.filter.maskText(password.length());
        }
    }
}

