/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.mvvmfx.utils.notifications;

import de.saxsys.mvvmfx.utils.notifications.NotificationCenter;
import de.saxsys.mvvmfx.utils.notifications.NotificationObserver;
import de.saxsys.mvvmfx.utils.notifications.WeakNotificationObserver;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javafx.application.Platform;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultNotificationCenter
implements NotificationCenter {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultNotificationCenter.class);
    private final ObserverMap globalObservers = new ObserverMap();
    private final ChannelObserverMap channelObserverMap = new ChannelObserverMap();

    @Override
    public void subscribe(String messageName, NotificationObserver observer) {
        if (observer == null) {
            throw new IllegalArgumentException("The observer must not be null.");
        }
        DefaultNotificationCenter.addObserver(messageName, observer, this.globalObservers);
    }

    @Override
    public void unsubscribe(String messageName, NotificationObserver observer) {
        DefaultNotificationCenter.removeObserversForMessageName(messageName, observer, this.globalObservers);
    }

    @Override
    public void unsubscribe(NotificationObserver observer) {
        DefaultNotificationCenter.removeObserverFromObserverMap(observer, this.globalObservers);
    }

    @Override
    public void publish(String messageName, Object ... payload) {
        DefaultNotificationCenter.publish(messageName, payload, this.globalObservers);
    }

    @Override
    public void publish(Object channel, String messageName, Object[] payload) {
        if (this.channelObserverMap.containsKey(channel)) {
            ObserverMap observerMap = (ObserverMap)this.channelObserverMap.get(channel);
            if (this.shouldPublishInThisThread()) {
                DefaultNotificationCenter.publish(messageName, payload, observerMap);
            } else {
                try {
                    Platform.runLater(() -> DefaultNotificationCenter.publish(messageName, payload, observerMap));
                }
                catch (IllegalStateException e) {
                    if (e.getMessage().equals("Toolkit not initialized")) {
                        DefaultNotificationCenter.publish(messageName, payload, observerMap);
                    }
                    throw e;
                }
            }
        }
    }

    private boolean shouldPublishInThisThread() {
        try {
            return Platform.isFxApplicationThread();
        }
        catch (RuntimeException e) {
            if (e.getMessage().equals("No toolkit found")) {
                return true;
            }
            throw e;
        }
    }

    @Override
    public void subscribe(Object channel, String messageName, NotificationObserver observer) {
        if (!this.channelObserverMap.containsKey(channel)) {
            this.channelObserverMap.put(channel, new ObserverMap());
        }
        ObserverMap observerMap = (ObserverMap)this.channelObserverMap.get(channel);
        DefaultNotificationCenter.addObserver(messageName, observer, observerMap);
    }

    @Override
    public void unsubscribe(Object channel, String messageName, NotificationObserver observer) {
        if (this.channelObserverMap.containsKey(channel)) {
            ObserverMap observerMap = (ObserverMap)this.channelObserverMap.get(channel);
            DefaultNotificationCenter.removeObserversForMessageName(messageName, observer, observerMap);
            if (observerMap.isEmpty()) {
                this.channelObserverMap.remove(channel);
            }
        }
    }

    @Override
    public void unsubscribe(Object channel, NotificationObserver observer) {
        if (this.channelObserverMap.containsKey(channel)) {
            ObserverMap observerMap = (ObserverMap)this.channelObserverMap.get(channel);
            DefaultNotificationCenter.removeObserverFromObserverMap(observer, observerMap);
            if (observerMap.isEmpty()) {
                this.channelObserverMap.remove(channel);
            }
        }
    }

    @Override
    public void clear() {
        this.globalObservers.clear();
        this.channelObserverMap.clear();
    }

    private static void publish(String messageName, Object[] payload, ObserverMap observerMap) {
        Collection notificationReceivers = (Collection)observerMap.get(messageName);
        if (notificationReceivers != null) {
            for (NotificationObserver observer : notificationReceivers) {
                observer.receivedNotification(messageName, payload);
            }
        }
    }

    private static void addObserver(String messageName, NotificationObserver observer, ObserverMap observerMap) {
        List observers;
        if (!observerMap.containsKey(messageName)) {
            observerMap.put(messageName, new CopyOnWriteArrayList());
        }
        if ((observers = (List)observerMap.get(messageName)).contains(observer)) {
            LOG.warn("Subscribe the observer [" + observer + "] for the message [" + messageName + "], but the same observer was already added for this message in the past.");
        }
        observers.add(observer);
    }

    private static void removeObserverFromObserverMap(NotificationObserver observer, ObserverMap observerMap) {
        for (String key : observerMap.keySet()) {
            List observers = (List)observerMap.get(key);
            DefaultNotificationCenter.removeObserverFromObserverList(observer, observers);
            if (!observers.isEmpty()) continue;
            observerMap.remove(key);
        }
    }

    private static void removeObserverFromObserverList(NotificationObserver observer, List<NotificationObserver> observerList) {
        observerList.removeIf(actualObserver -> actualObserver.equals(observer));
        observerList.removeIf(actualObserver -> {
            if (actualObserver instanceof WeakNotificationObserver) {
                WeakNotificationObserver weakObserver = (WeakNotificationObserver)actualObserver;
                NotificationObserver wrappedObserver = weakObserver.getWrappedObserver();
                if (wrappedObserver == null) {
                    return true;
                }
                return wrappedObserver.equals(observer);
            }
            return false;
        });
    }

    private static void removeObserversForMessageName(String messageName, NotificationObserver observer, ObserverMap observerMap) {
        if (observerMap.containsKey(messageName)) {
            List observers = (List)observerMap.get(messageName);
            DefaultNotificationCenter.removeObserverFromObserverList(observer, observers);
            if (observers.isEmpty()) {
                observerMap.remove(messageName);
            }
        }
    }

    private class ChannelObserverMap
    extends HashMap<Object, ObserverMap> {
        private ChannelObserverMap() {
        }
    }

    private class ObserverMap
    extends HashMap<String, List<NotificationObserver>> {
        private ObserverMap() {
        }
    }
}

