/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.common.utils.sm.cert;

import com.ruoyi.common.utils.sm.cert.SM2PublicKey;
import com.ruoyi.common.utils.sm.cert.exception.InvalidX500NameException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Iterator;
import java.util.Map;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.X500NameBuilder;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.DefaultDigestAlgorithmIdentifierFinder;
import org.bouncycastle.operator.DefaultSignatureAlgorithmIdentifierFinder;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.bouncycastle.pkcs.jcajce.JcaPKCS10CertificationRequestBuilder;

public class CommonUtil {
    public static X500Name buildX500Name(Map<String, String> names) throws InvalidX500NameException {
        if (names == null || names.size() == 0) {
            throw new InvalidX500NameException("names can not be empty");
        }
        try {
            X500NameBuilder builder = new X500NameBuilder();
            Iterator<Map.Entry<String, String>> itr = names.entrySet().iterator();
            BCStyle x500NameStyle = (BCStyle)BCStyle.INSTANCE;
            while (itr.hasNext()) {
                Map.Entry<String, String> entry = itr.next();
                ASN1ObjectIdentifier oid = x500NameStyle.attrNameToOID(entry.getKey());
                builder.addRDN(oid, entry.getValue());
            }
            return builder.build();
        }
        catch (Exception ex) {
            throw new InvalidX500NameException(ex.getMessage(), ex);
        }
    }

    public static PKCS10CertificationRequest createCSR(X500Name subject, SM2PublicKey pubKey, PrivateKey priKey, String signAlgo) throws OperatorCreationException {
        JcaPKCS10CertificationRequestBuilder csrBuilder = new JcaPKCS10CertificationRequestBuilder(subject, (PublicKey)((Object)pubKey));
        ContentSigner signerBuilder = new JcaContentSignerBuilder(signAlgo).setProvider("BC").build(priKey);
        return csrBuilder.build(signerBuilder);
    }

    public static AlgorithmIdentifier findSignatureAlgorithmIdentifier(String algoName) {
        DefaultSignatureAlgorithmIdentifierFinder sigFinder = new DefaultSignatureAlgorithmIdentifierFinder();
        return sigFinder.find(algoName);
    }

    public static AlgorithmIdentifier findDigestAlgorithmIdentifier(String algoName) {
        DefaultDigestAlgorithmIdentifierFinder digFinder = new DefaultDigestAlgorithmIdentifierFinder();
        return digFinder.find(CommonUtil.findSignatureAlgorithmIdentifier(algoName));
    }
}

