/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.common.utils.sm.cert;

import com.ruoyi.common.utils.sm.cert.CertSNAllocator;
import java.math.BigInteger;
import java.security.SecureRandom;

public class RandomSNAllocator
implements CertSNAllocator {
    private static final int MIN_SERIALNUMBER_SIZE = 65;
    private static final int MAX_SERIALNUMBER_SIZE = 159;
    private static int[] AND_MASKS = new int[]{255, 1, 3, 7, 15, 31, 63, 127};
    private static int[] OR_MASKS = new int[]{128, 1, 2, 4, 8, 16, 32, 64};
    private final SecureRandom random;
    private final int bitLen;

    public RandomSNAllocator() {
        this(65);
    }

    public RandomSNAllocator(int bitLen) {
        if (bitLen < 65 || bitLen > 159) {
            throw new IllegalArgumentException(String.format("%s may not be out of the range [%d, %d]: %d", "bitLen", 65, 159, bitLen));
        }
        this.random = new SecureRandom();
        this.bitLen = bitLen;
    }

    @Override
    public BigInteger nextSerialNumber() {
        byte[] rdnBytes = new byte[(this.bitLen + 7) / 8];
        int ci = this.bitLen % 8;
        this.random.nextBytes(rdnBytes);
        if (ci != 0) {
            rdnBytes[0] = (byte)(rdnBytes[0] & AND_MASKS[ci]);
        }
        rdnBytes[0] = (byte)(rdnBytes[0] | OR_MASKS[ci]);
        return new BigInteger(1, rdnBytes);
    }
}

