/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.common.utils.sm.cert;

import com.ruoyi.common.utils.sm.cert.CertSNAllocator;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.x500.AttributeTypeAndValue;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x500.style.IETFUtils;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.ExtendedKeyUsage;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509ExtensionUtils;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;

public class SM2X509CertMaker {
    public static final String SIGN_ALGO_SM3WITHSM2 = "SM3withSM2";
    private long certExpire;
    private X500Name issuerDN;
    private CertSNAllocator snAllocator;
    private KeyPair issuerKeyPair;

    public SM2X509CertMaker(KeyPair issuerKeyPair, long certExpire, X500Name issuer, CertSNAllocator snAllocator) {
        this.issuerKeyPair = issuerKeyPair;
        this.certExpire = certExpire;
        this.issuerDN = issuer;
        this.snAllocator = snAllocator;
    }

    public X509Certificate makeRootCACert(byte[] csr) throws Exception {
        KeyUsage usage = new KeyUsage(6);
        return this.makeCertificate(CertLevel.RootCA, null, csr, usage, null);
    }

    public X509Certificate makeSubCACert(byte[] csr) throws Exception {
        KeyUsage usage = new KeyUsage(6);
        return this.makeCertificate(CertLevel.SubCA, 0, csr, usage, null);
    }

    public X509Certificate makeSSLEndEntityCert(byte[] csr) throws Exception {
        return this.makeEndEntityCert(csr, new KeyPurposeId[]{KeyPurposeId.id_kp_clientAuth, KeyPurposeId.id_kp_serverAuth});
    }

    public X509Certificate makeEndEntityCert(byte[] csr, KeyPurposeId[] extendedKeyUsages) throws Exception {
        KeyUsage usage = new KeyUsage(184);
        return this.makeCertificate(CertLevel.SubCA, null, csr, usage, extendedKeyUsages);
    }

    private X509Certificate makeCertificate(CertLevel certLevel, Integer pathLenConstrain, byte[] csr, KeyUsage keyUsage, KeyPurposeId[] extendedKeyUsages) throws Exception {
        if (certLevel == CertLevel.EndEntity && keyUsage.hasUsages(4)) {
            throw new IllegalArgumentException("keyusage keyCertSign is not allowed in EndEntity Certificate");
        }
        PKCS10CertificationRequest request = new PKCS10CertificationRequest(csr);
        SubjectPublicKeyInfo subPub = request.getSubjectPublicKeyInfo();
        PrivateKey issPriv = this.issuerKeyPair.getPrivate();
        PublicKey issPub = this.issuerKeyPair.getPublic();
        X500Name subject = request.getSubject();
        String email = null;
        String commonName = null;
        RDN[] rdns = subject.getRDNs();
        ArrayList<RDN> newRdns = new ArrayList<RDN>(rdns.length);
        for (int i = 0; i < rdns.length; ++i) {
            RDN rdn = rdns[i];
            AttributeTypeAndValue atv = rdn.getFirst();
            ASN1ObjectIdentifier type = atv.getType();
            if (BCStyle.EmailAddress.equals((ASN1Primitive)type)) {
                email = IETFUtils.valueToString((ASN1Encodable)atv.getValue());
                continue;
            }
            if (BCStyle.CN.equals((ASN1Primitive)type)) {
                commonName = IETFUtils.valueToString((ASN1Encodable)atv.getValue());
            }
            newRdns.add(rdn);
        }
        LinkedList<GeneralName> subjectAltNames = new LinkedList<GeneralName>();
        if (email != null) {
            subject = new X500Name(newRdns.toArray(new RDN[0]));
            subjectAltNames.add(new GeneralName(1, (ASN1Encodable)new DERIA5String(email, true)));
        }
        boolean selfSignedEECert = false;
        switch (certLevel) {
            case RootCA: {
                if (this.issuerDN.equals((Object)subject)) {
                    subject = this.issuerDN;
                    break;
                }
                throw new IllegalArgumentException("subject != issuer for certLevel " + (Object)((Object)CertLevel.RootCA));
            }
            case SubCA: {
                if (!this.issuerDN.equals((Object)subject)) break;
                throw new IllegalArgumentException("subject MUST not equals issuer for certLevel " + (Object)((Object)certLevel));
            }
            default: {
                if (!this.issuerDN.equals((Object)subject)) break;
                selfSignedEECert = true;
                subject = this.issuerDN;
            }
        }
        BigInteger serialNumber = this.snAllocator.nextSerialNumber();
        Date notBefore = new Date();
        Date notAfter = new Date(notBefore.getTime() + this.certExpire);
        X509v3CertificateBuilder v3CertGen = new X509v3CertificateBuilder(this.issuerDN, serialNumber, notBefore, notAfter, subject, subPub);
        JcaX509ExtensionUtils extUtils = new JcaX509ExtensionUtils();
        v3CertGen.addExtension(Extension.subjectKeyIdentifier, false, (ASN1Encodable)extUtils.createSubjectKeyIdentifier(subPub));
        if (certLevel != CertLevel.RootCA && !selfSignedEECert) {
            v3CertGen.addExtension(Extension.authorityKeyIdentifier, false, (ASN1Encodable)extUtils.createAuthorityKeyIdentifier(SubjectPublicKeyInfo.getInstance((Object)issPub.getEncoded())));
        }
        BasicConstraints basicConstraints = certLevel == CertLevel.EndEntity ? new BasicConstraints(false) : (pathLenConstrain == null ? new BasicConstraints(true) : new BasicConstraints(pathLenConstrain.intValue()));
        v3CertGen.addExtension(Extension.basicConstraints, true, (ASN1Encodable)basicConstraints);
        v3CertGen.addExtension(Extension.keyUsage, true, (ASN1Encodable)keyUsage);
        if (extendedKeyUsages != null) {
            ExtendedKeyUsage xku = new ExtendedKeyUsage(extendedKeyUsages);
            v3CertGen.addExtension(Extension.extendedKeyUsage, false, (ASN1Encodable)xku);
            boolean forSSLServer = false;
            for (KeyPurposeId purposeId : extendedKeyUsages) {
                if (!KeyPurposeId.id_kp_serverAuth.equals((Object)purposeId)) continue;
                forSSLServer = true;
                break;
            }
            if (forSSLServer) {
                if (commonName == null) {
                    throw new IllegalArgumentException("commonName must not be null");
                }
                GeneralName name = new GeneralName(2, (ASN1Encodable)new DERIA5String(commonName, true));
                subjectAltNames.add(name);
            }
        }
        if (!subjectAltNames.isEmpty()) {
            v3CertGen.addExtension(Extension.subjectAlternativeName, false, (ASN1Encodable)new GeneralNames(subjectAltNames.toArray(new GeneralName[0])));
        }
        JcaContentSignerBuilder contentSignerBuilder = this.makeContentSignerBuilder(issPub);
        X509Certificate cert = new JcaX509CertificateConverter().setProvider("BC").getCertificate(v3CertGen.build(contentSignerBuilder.build(issPriv)));
        cert.verify(issPub);
        return cert;
    }

    private JcaContentSignerBuilder makeContentSignerBuilder(PublicKey issPub) throws Exception {
        if (issPub.getAlgorithm().equals("EC")) {
            JcaContentSignerBuilder contentSignerBuilder = new JcaContentSignerBuilder(SIGN_ALGO_SM3WITHSM2);
            contentSignerBuilder.setProvider("BC");
            return contentSignerBuilder;
        }
        throw new Exception("Unsupported PublicKey Algorithm:" + issPub.getAlgorithm());
    }

    private static enum CertLevel {
        RootCA,
        SubCA,
        EndEntity;

    }
}

