/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.writer;

import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.writer.FieldWriterDate;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Date;
import java.util.function.Function;

final class FieldWriterDateFunc<T>
extends FieldWriterDate<T> {
    final Function<T, Date> function;

    FieldWriterDateFunc(String fieldName, int ordinal, long features, String dateTimeFormat, String label, Method method, Function<T, Date> function) {
        super(fieldName, ordinal, features, dateTimeFormat, label, (Type)((Object)Date.class), Date.class, null, method);
        this.function = function;
    }

    @Override
    public Object getFieldValue(T object) {
        return this.function.apply(object);
    }

    @Override
    public void writeValue(JSONWriter jsonWriter, T object) {
        Date value = this.function.apply(object);
        if (value == null) {
            jsonWriter.writeNull();
            return;
        }
        this.writeDate(jsonWriter, false, value.getTime());
    }

    @Override
    public boolean write(JSONWriter jsonWriter, T object) {
        Date value = this.function.apply(object);
        if (value == null) {
            long features = this.features | jsonWriter.getFeatures();
            if ((features & JSONWriter.Feature.WriteNulls.mask) != 0L) {
                this.writeFieldName(jsonWriter);
                jsonWriter.writeNull();
                return true;
            }
            return false;
        }
        this.writeDate(jsonWriter, value.getTime());
        return true;
    }
}

