/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.opencc4j.support.convert.core.impl;

import com.github.houbb.heaven.annotation.ThreadSafe;
import com.github.houbb.heaven.util.util.CollectionUtil;
import com.github.houbb.opencc4j.support.convert.context.UnitConvertContext;
import com.github.houbb.opencc4j.support.convert.core.UnitConvert;
import java.util.List;
import java.util.Map;

@ThreadSafe
public class DefaultUnitConvert
implements UnitConvert {
    @Override
    public String convert(UnitConvertContext context) {
        String unit = context.getUnit();
        Map<String, List<String>> charMap = context.getCharData();
        Map<String, List<String>> phaseMap = context.getPhraseData();
        return this.getPhraseResult(unit, phaseMap, charMap);
    }

    private String getPhraseResult(String original, Map<String, List<String>> phraseMap, Map<String, List<String>> charMap) {
        List<String> phraseList = phraseMap.get(original);
        if (CollectionUtil.isNotEmpty(phraseList)) {
            return phraseList.get(0);
        }
        char[] chars = original.toCharArray();
        StringBuilder stringBuilder = new StringBuilder();
        for (char c : chars) {
            String charStr = Character.toString(c);
            String result = this.getCharResult(charStr, charMap);
            if (result.length() == 1) {
                stringBuilder.append(result);
                continue;
            }
            stringBuilder.append(charStr);
        }
        return stringBuilder.toString();
    }

    private String getCharResult(String original, Map<String, List<String>> charMap) {
        List<String> charList = charMap.get(original);
        if (CollectionUtil.isNotEmpty(charList)) {
            return charList.get(0);
        }
        return original;
    }
}

