//
//  SGAnimImageBtn.h
//  SogouInput
//
//  Created by Yongle on 8/22/13.
//  Copyright (c) 2013 Sogou-inc.com. All rights reserved.
//

#import "SGAnimImageView.h"
#import "SGBitmap.h"

@interface SGAnimImageBtn : SGAnimImageView {
    AnimationFrames *hoverAniFrames;
    AnimationFrames *pressAniFrames;
    AnimationFrames *inactiveAniFrames;
    
    int m_status;
    
    void (^onClickAct)(void);
    void (^hoverAct)(void);
    void (^onExitAct)(void);
    
    SGBitmap *touchPoints;
    NSTrackingArea *_trackingArea;
    
    BOOL _mouseResponsible;
    BOOL _mouseEntered;
}

- (void)setHoverAnimationFrames:(AnimationFrames *)af;
- (void)setOnPressAnimationFrames:(AnimationFrames *)af;
- (void)setInactiveAniFramesAnimationFrames:(AnimationFrames *)af;

- (void)setInactive:(BOOL) b;

- (void)setOnClickAction:(void (^)(void)) onClick;
- (void)setOnMouseOverAction:(void (^)(void)) onClick;
- (void)setOnMouseExitAction:(void (^)(void)) onClick;

- (BOOL)hitCheck:(NSPoint) point;
- (BOOL)mouseHitCheck:(NSEvent *)theEvent;

- (void)setMouseResponsible:(BOOL) b;

@end
