//
//  SGAnimImageView.h
//  GIFTest
//
//  Created by Yongle on 8/1/13.
//  Copyright (c) 2013 yongle. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "AnimationFrames+Draw.h"

@protocol FrameUpdateProtocol <NSObject>

- (BOOL)isVisible;
- (void)drawCurrentFrame;

@end


@interface FrameUpdateTask : NSObject {
    AnimationFrames *_frames;
    AnimFrame *_currFrame;
    id<FrameUpdateProtocol> delegate;
    
    BOOL running;
}

@property(nonatomic, retain) AnimationFrames *frames;

- (void)refreshFrame;
- (void)runWithDelegate:(id) dl;
- (void)stop;

- (BOOL)isRunning;

@end


@interface SGAnimImageView : NSView <FrameUpdateProtocol> {
    AnimationFrames *aniFrames;
    FrameUpdateTask *currTask;
    int currImgScaleType;
    id _tagObj;
}

@property(nonatomic, retain) AnimationFrames *aniFrames;
@property(nonatomic, retain) id tagObj;

- (void)showFrames:(AnimationFrames *)af;

- (NSSize)maxImageSize;
- (NSImage *)firstFrame;

- (void)setAnimationFrames:(AnimationFrames *)af;
- (void)showAnimations;

@end

