#！/bin/bash
# install script
SOGOU_INPUT_APP_PATH="/Library/Input Methods/SogouWBInput.app"
REINSTALL_FLAG="$HOME/Library/Caches/com.sogou.installForWBType"
TMP_PATH="/tmp/characterInfo"
echo ~/Desktop > /tmp/UserName
curUser=`/usr/bin/awk -F "/" '{print $3}' /tmp/UserName`

#--------------前期工作--------------#
#杀掉相关进程
killall SogouWBPreference
killall -9 SogouWBHelper

#标志位
if [ -f "$REINSTALL_FLAG"  ]; then
    rm -rf "$REINSTALL_FLAG"
fi

if [ -d "$SOGOU_INPUT_APP_PATH" ]; then
    echo 1 >> "$REINSTALL_FLAG"
else
	echo 0 >> "$REINSTALL_FLAG"
fi

#清理目录
rm -rf /Library/Input\ Methods/SogouWBInput.app/Contents;

rm -rf ${TMP_PATH}

#--------------安装--------------#
CUR_DIR=$(cd "$(dirname "$0")"; pwd)
if [ -d "$SOGOU_INPUT_APP_PATH" ]; then
	chmod 755 "$SOGOU_INPUT_APP_PATH"
    TMP_SOURCE="$CUR_DIR/SogouWBInput.app/Contents"
    TMP_TARGET="$SOGOU_INPUT_APP_PATH/"
    mv  "$TMP_SOURCE" "$TMP_TARGET"
else
    mv "$CUR_DIR/SogouWBInput.app" "$SOGOU_INPUT_APP_PATH"

fi

#remove extension attribute : com.apple.quarantine
xattr -d -r com.apple.quarantine "$SOGOU_INPUT_APP_PATH"

#--------------修改权限--------------#

chown $curUser:staff ~/Library/Input\ Methods/
cd "$CUR_DIR"
chmod -R 755 ~/Library/Application\ Support/Sogou/WBInputMethod
./SetFile -a l ~/Library
./SetFile -a l ~/Library/Application\ Support
./SetFile -a l ~/Library/Application\ Support/Sogou
./SetFile -a l ~/Library/Application\ Support/Sogou/WBInputMethod
chown -R root:staff "$SOGOU_INPUT_APP_PATH"
chmod -R 775 "$SOGOU_INPUT_APP_PATH"
ver=`uname -r | cut -d. -f1-2`

rm -rf /tmp/UserName

#--------------后期清理--------------#
chmod +rx "/Library/Input Methods"

killall -9 SogouWBInput


cp -f /Library/Input\ Methods/SogouWBInput.app/Contents/Resources/symbolset2.plist ~/Library/Application\ Support/Sogou/WBInputMethod/SogouWB/symbolset2.plist

exit 0
