CREATE TABLE Branding ( ProductID TEXT NOT NULL REFERENCES Suites (ProductID),resource_type TEXT NOT NULL,resource_data TEXT NOT NULL,PRIMARY KEY (ProductID, resource_type) )
CREATE TABLE DependencyData( PayloadID TEXT NOT NULL REFERENCES Payloads (PayloadID),PayloadIDb TEXT ,type TEXT NOT NULL ,product_family TEXT, product_name TEXT, version TEXT, PRIMARY KEY (PayloadID,PayloadIDb,type,product_family,product_name,version))
CREATE TABLE EULA_Files( productID TEXT NOT NULL, langCode TEXT NOT NULL,eula TEXT NOT NULL,PRIMARY KEY (productID, langCode) )
CREATE TABLE PayloadData( PayloadID TEXT NOT NULL REFERENCES Payloads (PayloadID),domain TEXT NOT NULL,key TEXT NOT NULL,value TEXT NOT NULL,PRIMARY KEY (PayloadID, domain, key) )
CREATE TABLE Payloads( PayloadID TEXT NOT NULL, payload_family TEXT NOT NULL,payload_name TEXT NOT NULL, payload_version TEXT NOT NULL,payload_type TEXT NOT NULL,PRIMARY KEY (PayloadID) )
CREATE TABLE SuitePayloads( ProductID TEXT NOT NULL REFERENCES Suites (ProductID),PayloadID TEXT NOT NULL REFERENCES Payloads (PayloadID),PRIMARY KEY (ProductID, PayloadID) )
CREATE TABLE Suites( ProductID TEXT NOT NULL, group_name TEXT NOT NULL, group_family TEXT NOT NULL, display_name TEXT NOT NULL, PRIMARY KEY (ProductID) )
CREATE TABLE EULA_Ref( productID TEXT NOT NULL, langCode TEXT NOT NULL, eula_hash TEXT NOT NULL, PRIMARY KEY (productID, langCode) )
CREATE TABLE EULA_Content(eula_hash TEXT NOT NULL, Content TEXT NOT NULL, PRIMARY KEY (eula_hash))
CREATE TABLE IF NOT EXISTS pcd_meta ( key TEXT NOT NULL, value TEXT NOT NULL, PRIMARY KEY (key) )
INSERT OR REPLACE INTO pcd_meta (key, value) VALUES ('schema_version', 2)
INSERT OR REPLACE INTO pcd_meta (key, value) VALUES ('schema_compatibility_version', 1)
INSERT INTO DependencyData VALUES	("{FA148573-E0E5-400F-8978-D95410035F18}", "{9C414D29-7041-46CF-9A7D-C6373614B233}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FA148573-E0E5-400F-8978-D95410035F18}", "{89846452-DA87-4D2C-944F-170E6616C305}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FA148573-E0E5-400F-8978-D95410035F18}", "{489136FD-C6E1-4631-8583-485B6ACB57DD}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FA148573-E0E5-400F-8978-D95410035F18}", "{CFFC1672-93B3-44BB-AC64-4309F13A4C74}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FA148573-E0E5-400F-8978-D95410035F18}", "{3BE6260A-9819-45EF-B4A9-B7DA6EEEC6A3}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FA148573-E0E5-400F-8978-D95410035F18}", "{C69D5AA8-917B-4467-81C1-7DE4C86A7596}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FA148573-E0E5-400F-8978-D95410035F18}", "{1E7B22B2-7653-4F2B-A913-E40D99AE1EAB}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FA148573-E0E5-400F-8978-D95410035F18}", "{97E0C54E-EB42-4F4B-9213-892DDDFF90D8}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FA148573-E0E5-400F-8978-D95410035F18}", "{D247D3CA-41F7-46FC-A5B1-E502474E867F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FA148573-E0E5-400F-8978-D95410035F18}", "{2EE7B51F-FAAB-4A2D-98C8-D153BE6FDB90}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FA148573-E0E5-400F-8978-D95410035F18}", "{9B88787E-A245-498C-BE74-03A5AD5F1B4B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FA148573-E0E5-400F-8978-D95410035F18}", "{FD20C912-497A-45A8-8FD7-BFF849BFBAA4}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FA148573-E0E5-400F-8978-D95410035F18}", "{8BDF71A3-A455-4484-8A72-58E9B652778F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FA148573-E0E5-400F-8978-D95410035F18}", "{DC3BACD3-D2A1-4639-90D7-0E1D673D584E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FA148573-E0E5-400F-8978-D95410035F18}", "{8A0997A2-25D3-4366-BF25-E1023750BF82}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FA148573-E0E5-400F-8978-D95410035F18}", "{53404690-459B-4DC0-AAC1-7C89E7FCF24F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FA148573-E0E5-400F-8978-D95410035F18}", "{890E857A-8F7D-4131-9FF1-9CA21192007C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FA148573-E0E5-400F-8978-D95410035F18}", "{65E0F6C2-2D75-4A76-BE59-352FED538A1B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FA148573-E0E5-400F-8978-D95410035F18}", "{C80B98CF-F295-4D75-864D-FED8479EF32D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FA148573-E0E5-400F-8978-D95410035F18}", "{B4306D6D-2DFE-46F6-BE05-11F67B36A6AB}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FA148573-E0E5-400F-8978-D95410035F18}", "{93A0F249-C8F8-4F81-A051-0937F6174081}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FA148573-E0E5-400F-8978-D95410035F18}", "{2AEE283B-979B-4230-853C-8CBADE1B8C5E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FA148573-E0E5-400F-8978-D95410035F18}", "{1DE926CC-5B16-4BC9-B260-7BC24F0F2B15}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FA148573-E0E5-400F-8978-D95410035F18}", "{89F85C08-8AF1-4EDE-8049-A7562A69F6DE}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FA148573-E0E5-400F-8978-D95410035F18}", "{71BE6974-3F9E-41F1-9073-57AB62C6A897}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FA148573-E0E5-400F-8978-D95410035F18}", "{749EB018-E680-481D-A798-6DCC4712B809}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FA148573-E0E5-400F-8978-D95410035F18}", "{460FA82E-AC8A-4246-82E1-7B90E7283275}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FA148573-E0E5-400F-8978-D95410035F18}", "{7D224BAC-2351-4673-BBBD-4524B8F3FD3D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FA148573-E0E5-400F-8978-D95410035F18}", "{92D4DAE6-7FCE-4647-85AD-B40BBBDB2F9D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FA148573-E0E5-400F-8978-D95410035F18}", "{1F02C8B8-E1E9-4348-A7E6-D42D19234550}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FA148573-E0E5-400F-8978-D95410035F18}", "{C98B7CD2-5D46-4130-9950-4E4A2C92F662}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FA148573-E0E5-400F-8978-D95410035F18}", "{EC682A9F-9A5E-4EBD-A19A-9E9C7F0206E6}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FA148573-E0E5-400F-8978-D95410035F18}", "{F216F49F-5377-4E53-B85D-6E3AD8CDE42C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FA148573-E0E5-400F-8978-D95410035F18}", "{E747E8AC-9273-4347-ADC0-30DAAC073AE9}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FA148573-E0E5-400F-8978-D95410035F18}", "{A81F8C6F-7446-4108-9CA5-C3D4E6773D5F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FA148573-E0E5-400F-8978-D95410035F18}", "{14771CFB-50D4-4BA8-A7E8-F138F2C227F8}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FA148573-E0E5-400F-8978-D95410035F18}", "{B41B1166-C82F-4DDD-8EB6-03175296A204}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FA148573-E0E5-400F-8978-D95410035F18}", "{F408183C-7F88-4A35-82D7-80945F834B12}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FA148573-E0E5-400F-8978-D95410035F18}", "{BF3254DF-032D-446C-8F70-EEA85B4812EE}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FA148573-E0E5-400F-8978-D95410035F18}", "{DF19AC32-4BB3-48FA-95C0-265DC5FB1A98}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FA148573-E0E5-400F-8978-D95410035F18}", "{3FECBFED-E5CC-453B-99B6-7A99C10D6E8F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FA148573-E0E5-400F-8978-D95410035F18}", "{69E21969-90E5-41B1-9FB6-A428AA82CD25}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FA148573-E0E5-400F-8978-D95410035F18}", "{B35F0A7E-73C6-48D8-97C9-9406BA84BF59}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FA148573-E0E5-400F-8978-D95410035F18}", "{72F6D500-5169-4D4B-8E71-27FFCE8D5EFE}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FA148573-E0E5-400F-8978-D95410035F18}", "{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "patch", "Shared Technology", "Photoshop Camera Raw 7", "")
INSERT INTO PayloadData VALUES("{FA148573-E0E5-400F-8978-D95410035F18}", "0" , "ValidationInfo", '<ValidationInfo payloadID="{FA148573-E0E5-400F-8978-D95410035F18}"><File><InstallPath>[INSTALLDIR]\Plug-Ins\CS6\File Formats\Camera Raw.8bi</InstallPath><SignatureType>DigitalSignature</SignatureType><SignatureInfo>Adobe Systems Incorporated{|}VeriSign Class 3 Code Signing 2010 CA{|}VeriSign Class 3 Public Primary Certification Authority - G5{|}Class 3 Public Primary Certification Authority</SignatureInfo></File></ValidationInfo>')
INSERT INTO PayloadData VALUES("{FA148573-E0E5-400F-8978-D95410035F18}", "0" , "ValidationSig", "hh6519DFLiEYlxGrt7rZHPm/FzGDdFX0/JOnLzJ6jaNCmxvSSNDbS6qh7qM02/1eJ/LAp2UPOSYOzkPrV/rRsRTKitBao4LnlaMqu+K1r/WdP0YY8mjQ7BZeFGgPC9OCzvthK/du5Aq9AcboU2g75eDYziWpHeXQm/jtHNShXVQCNj3+cpaexG8NUqpO2FMZf+vPQ96H7XS4c1gDVmdLY1TxeHbKlpz0nV6yrvoiOUNYwTkXuQGHpyBc4Jp/9wwOjzyKY8hsIwuhLvS7ZJSjpYOpI/kQkd5G49+HlSlV+U5q2rdBkmaOG/1kMghUNAAGsxZx/f0KZGYC/tixmPp9epBMoxs5gOV04JAanW83/dUqVDlOSczvOcteBUhppRnuaExTIguR1kPjATg+ehj9eVPTu3jAvzWZG/NLBch5BtXaSUbBpWKBsT4o8+VyDha2k3kZ4aXg6rnd3SkIvfbuP8vmc92Q5KFmm/tSp6BZtzm2Tx33tno1dTGmu5MN47pR")
INSERT INTO Payloads VALUES	("{FA148573-E0E5-400F-8978-D95410035F18}", "Shared Technology", "Photoshop Camera Raw 7_7.1_AdobeCameraRaw7.0All", "7.1", "patch")
INSERT INTO PayloadData VALUES("{FA148573-E0E5-400F-8978-D95410035F18}", "0" , "PayloadInfo", '<PayloadInfo version="6.0.98.0"><BuildInfo>
    <Property name="Created">2012-05-16 10:46:01.333000</Property>
    <Property name="TargetName">AdobeCameraRaw7.0All-160512104601</Property>
    <Property name="ProcessorFamily">All</Property>
  </BuildInfo><InstallerProperties>
    <Property name="payloadType">SQLite</Property>
    <Property name="AdobeCode">{FA148573-E0E5-400F-8978-D95410035F18}</Property>
    <Property name="ProductName">Photoshop Camera Raw 7</Property>
    <Property name="ProductVersion">7.1</Property>
  </InstallerProperties><InstallDir>
    <Platform isFixed="0" name="Default" folderName="">[AdobeCommon]</Platform>
  </InstallDir><Languages languageIndependent="1"/><Satisfies>
    <ProductInfo>
      <Family>Shared Technology</Family>
      <ProductName>Photoshop Camera Raw 7_7.1_AdobeCameraRaw7.0All</ProductName>
      <ProductVersion>7.1</ProductVersion>
    </ProductInfo>
  </Satisfies><Upgrades>
    <AdobeCode>{9C414D29-7041-46CF-9A7D-C6373614B233}</AdobeCode>
    <AdobeCode>{89846452-DA87-4D2C-944F-170E6616C305}</AdobeCode>
    <AdobeCode>{489136FD-C6E1-4631-8583-485B6ACB57DD}</AdobeCode>
    <AdobeCode>{CFFC1672-93B3-44BB-AC64-4309F13A4C74}</AdobeCode>
    <AdobeCode>{3BE6260A-9819-45EF-B4A9-B7DA6EEEC6A3}</AdobeCode>
    <AdobeCode>{C69D5AA8-917B-4467-81C1-7DE4C86A7596}</AdobeCode>
    <AdobeCode>{1E7B22B2-7653-4F2B-A913-E40D99AE1EAB}</AdobeCode>
    <AdobeCode>{97E0C54E-EB42-4F4B-9213-892DDDFF90D8}</AdobeCode>
    <AdobeCode>{D247D3CA-41F7-46FC-A5B1-E502474E867F}</AdobeCode>
    <AdobeCode>{2EE7B51F-FAAB-4A2D-98C8-D153BE6FDB90}</AdobeCode>
    <AdobeCode>{9B88787E-A245-498C-BE74-03A5AD5F1B4B}</AdobeCode>
    <AdobeCode>{FD20C912-497A-45A8-8FD7-BFF849BFBAA4}</AdobeCode>
    <AdobeCode>{8BDF71A3-A455-4484-8A72-58E9B652778F}</AdobeCode>
    <AdobeCode>{DC3BACD3-D2A1-4639-90D7-0E1D673D584E}</AdobeCode>
    <AdobeCode>{8A0997A2-25D3-4366-BF25-E1023750BF82}</AdobeCode>
    <AdobeCode>{53404690-459B-4DC0-AAC1-7C89E7FCF24F}</AdobeCode>
    <AdobeCode>{890E857A-8F7D-4131-9FF1-9CA21192007C}</AdobeCode>
    <AdobeCode>{65E0F6C2-2D75-4A76-BE59-352FED538A1B}</AdobeCode>
    <AdobeCode>{C80B98CF-F295-4D75-864D-FED8479EF32D}</AdobeCode>
    <AdobeCode>{B4306D6D-2DFE-46F6-BE05-11F67B36A6AB}</AdobeCode>
    <AdobeCode>{93A0F249-C8F8-4F81-A051-0937F6174081}</AdobeCode>
    <AdobeCode>{2AEE283B-979B-4230-853C-8CBADE1B8C5E}</AdobeCode>
    <AdobeCode>{1DE926CC-5B16-4BC9-B260-7BC24F0F2B15}</AdobeCode>
    <AdobeCode>{89F85C08-8AF1-4EDE-8049-A7562A69F6DE}</AdobeCode>
    <AdobeCode>{71BE6974-3F9E-41F1-9073-57AB62C6A897}</AdobeCode>
    <AdobeCode>{749EB018-E680-481D-A798-6DCC4712B809}</AdobeCode>
    <AdobeCode>{460FA82E-AC8A-4246-82E1-7B90E7283275}</AdobeCode>
    <AdobeCode>{7D224BAC-2351-4673-BBBD-4524B8F3FD3D}</AdobeCode>
    <AdobeCode>{92D4DAE6-7FCE-4647-85AD-B40BBBDB2F9D}</AdobeCode>
    <AdobeCode>{1F02C8B8-E1E9-4348-A7E6-D42D19234550}</AdobeCode>
    <AdobeCode>{C98B7CD2-5D46-4130-9950-4E4A2C92F662}</AdobeCode>
    <AdobeCode>{EC682A9F-9A5E-4EBD-A19A-9E9C7F0206E6}</AdobeCode>
    <AdobeCode>{F216F49F-5377-4E53-B85D-6E3AD8CDE42C}</AdobeCode>
    <AdobeCode>{E747E8AC-9273-4347-ADC0-30DAAC073AE9}</AdobeCode>
    <AdobeCode>{A81F8C6F-7446-4108-9CA5-C3D4E6773D5F}</AdobeCode>
    <AdobeCode>{14771CFB-50D4-4BA8-A7E8-F138F2C227F8}</AdobeCode>
    <AdobeCode>{B41B1166-C82F-4DDD-8EB6-03175296A204}</AdobeCode>
    <AdobeCode>{F408183C-7F88-4A35-82D7-80945F834B12}</AdobeCode>
    <AdobeCode>{BF3254DF-032D-446C-8F70-EEA85B4812EE}</AdobeCode>
    <AdobeCode>{DF19AC32-4BB3-48FA-95C0-265DC5FB1A98}</AdobeCode>
    <AdobeCode>{3FECBFED-E5CC-453B-99B6-7A99C10D6E8F}</AdobeCode>
    <AdobeCode>{69E21969-90E5-41B1-9FB6-A428AA82CD25}</AdobeCode>
    <AdobeCode>{B35F0A7E-73C6-48D8-97C9-9406BA84BF59}</AdobeCode>
    <AdobeCode>{72F6D500-5169-4D4B-8E71-27FFCE8D5EFE}</AdobeCode>
  </Upgrades><Channel enable="1" id="PhotoshopCameraRaw7-7.0">
        <DisplayName>Photoshop Camera Raw 7</DisplayName>
      </Channel><Update id="7.1.74">
        
        
      &lt;DisplayName default="en_US"&gt;
        &lt;en_US&gt;Photoshop Camera Raw 7.1&lt;/en_US&gt;
		&lt;fr_FR&gt;Mise à jour 7.1 de Photoshop Camera Raw&lt;/fr_FR&gt;
		&lt;de_DE&gt;Photoshop Camera Raw 7.1-Update&lt;/de_DE&gt;
		&lt;it_IT&gt;Aggiornamento di Photoshop Camera Raw 7.1&lt;/it_IT&gt;
		&lt;ja_JP&gt;Photoshop Camera Raw 7.1 アップデート&lt;/ja_JP&gt;
		&lt;es_ES&gt;Actualización Photoshop Camera Raw 7.1&lt;/es_ES&gt;
		&lt;sv_SE&gt;Uppdatering till Photoshop Camera Raw 7.1&lt;/sv_SE&gt;
		&lt;zh_CN&gt;Photoshop Camera Raw 7.1 更新&lt;/zh_CN&gt;
		&lt;zh_TW&gt;Photoshop Camera Raw 7.1 更新&lt;/zh_TW&gt;
		&lt;nl_NL&gt;Photoshop Camera Raw 7.1-update&lt;/nl_NL&gt;
		&lt;ko_KR&gt;Photoshop Camera Raw 7.1 업데이트&lt;/ko_KR&gt;
		&lt;nb_NO&gt;Oppdatering for Photoshop Camera Raw 7.1&lt;/nb_NO&gt;
		&lt;da_DK&gt;Photoshop Camera Raw 7.1-opdatering&lt;/da_DK&gt;
		&lt;fi_FI&gt;Photoshop Camera Raw 7.1 -päivitys&lt;/fi_FI&gt;
		&lt;pl_PL&gt;Photoshop Camera Raw 7.1 – aktualizacja&lt;/pl_PL&gt;
		&lt;cs_CZ&gt;Aktualizace Photoshop Camera Raw 7.1&lt;/cs_CZ&gt;
		&lt;ro_RO&gt;Actualizare Photoshop Camera Raw 7.1&lt;/ro_RO&gt;
		&lt;hu_HU&gt;Photoshop Camera Raw 7.1 frissítés&lt;/hu_HU&gt;
		&lt;ru_RU&gt;Обновление Photoshop Camera Raw 7.1&lt;/ru_RU&gt;
		&lt;pt_BR&gt;Atualização do Photoshop Camera Raw 7.1&lt;/pt_BR&gt;
		&lt;uk_UA&gt;Оновлення Photoshop Camera Raw 7.1&lt;/uk_UA&gt;
		&lt;tr_TR&gt;Photoshop Camera Raw 7.1 Güncellemesi&lt;/tr_TR&gt;
    &lt;/DisplayName&gt;&lt;Description default="en_US"&gt;
        &lt;en_US&gt;Update to the Camera Raw plug-in that ships with Photoshop CS6.  Adds raw support for new camera models.&lt;/en_US&gt;
		&lt;fr_FR&gt;Mise à jour du module externe Camera Raw fourni avec Photoshop CS6.  Ajoute la prise en charge des fichiers Raw pour les nouveaux modèles d'appareils photo.&lt;/fr_FR&gt;
		&lt;de_DE&gt;Update für das Camera Raw-Zusatzmodul, das im Lieferumfang von Photoshop CS6 enthalten ist.  Zusätzliche Unterstützung für Raw-Dateien aus neuen Kameramodellen&lt;/de_DE&gt;
		&lt;it_IT&gt;Eseguite l'aggiornamento del plug-in di Camera Raw in dotazione con Photoshop CS6.  Consente il supporto per i file raw per nuovi modelli di fotocamere&lt;/it_IT&gt;
		&lt;ja_JP&gt;Photoshop CS6 に同梱されている Camera Raw プラグインに更新します。  新しいカメラモデル対応の Raw サポートが追加されます。&lt;/ja_JP&gt;
		&lt;es_ES&gt;Actualización para el plugin Camera Raw suministrado con Photoshop CS6.  Permite la compatibilidad con los archivos RAW de los nuevos modelos de cámara.&lt;/es_ES&gt;
		&lt;sv_SE&gt;Uppdatera plugin-programmet Camera Raw som levereras med Photoshop CS6.  Lägger till stöd för raw-format för nya kameramodeller.&lt;/sv_SE&gt;
		&lt;zh_CN&gt;Photoshop CS6 随附的 Camera Raw 插件的更新。针对新相机型号增加 raw 文件格式支持&lt;/zh_CN&gt;
		&lt;zh_TW&gt;更新 Photoshop CS6 隨附的 Camera Raw 增效模組。  新增對新相機機型的原生支援&lt;/zh_TW&gt;
		&lt;nl_NL&gt;Update voor de Camera Raw-plug-in die bij Photoshop CS6 wordt geleverd.  Voegt RAW-ondersteuning toe voor nieuwe cameramodellen&lt;/nl_NL&gt;
		&lt;cs_CZ&gt;Aktualizace zásuvného modulu Camera Raw, dodávaného s aplikací Photoshop CS6.  Přidává podporu formátu raw u nových modelů fotoaparátů&lt;/cs_CZ&gt;
		&lt;nb_NO&gt;Oppdatering for tilleggsmodulen Camera Raw som leveres med Photoshop CS6.  Legger til ekte støtte for nye kameramodeller&lt;/nb_NO&gt;
		&lt;da_DK&gt;Opdatering til Camera Raw-ekstramodulet, der leveres sammen med Photoshop CS6.  Føjer Raw-understøttelse til nye kameramodeller&lt;/da_DK&gt;
		&lt;fi_FI&gt;Photoshop CS6:n mukana toimitettavan Camera Raw -laajennuksen päivitys.  Lisää raw-tuen uusille kameramalleille.&lt;/fi_FI&gt;
		&lt;pl_PL&gt;Aktualizacja wtyczki Camera Raw, która jest dołączona do programu Photoshop CS6.  Dodaje obsługę RAW dla nowych modeli aparatów&lt;/pl_PL&gt;
		&lt;ko_KR&gt;Photoshop CS6와 함께 제공된 Camera Raw 플러그인을 업데이트합니다.  새 카메라 모델의 raw 파일 지원 추가&lt;/ko_KR&gt;
		&lt;ro_RO&gt;Actualizaţi la plugin-ul Camera Raw livrat cu Photoshop CS6.  Acesta adaugă compatibilitate cu formate brute de la noi modele de camere foto&lt;/ro_RO&gt;
		&lt;hu_HU&gt;A Photoshop CS6 verzióhoz tartozó Camera Raw bővítmény frissítése.  Biztosítja a raw-formátum támogatását újabb fényképezőgép-típusok esetében is&lt;/hu_HU&gt;
		&lt;ru_RU&gt;Обновление внешнего модуля Camera Raw, который входит в комплект поставки Photoshop CS6.  Добавлена поддержка формата raw для новых моделей камер&lt;/ru_RU&gt;
		&lt;pt_BR&gt;Atualização do plug-in do Camera Raw fornecido com o Photoshop CS6.  Inclusão de suporte adicional para novos modelos de câmeras&lt;/pt_BR&gt;
		&lt;uk_UA&gt;Оновлення для модуля Camera Raw, що постачається з пакетом Photoshop CS6.  Додано підтримку формату raw для нових моделей фотокамер.&lt;/uk_UA&gt;
		&lt;tr_TR&gt;Photoshop CS6 ile birlikte verilen Camera Raw eklentisine güncelleyin.  Yeni fotoğraf makinesi modelleri için raw desteği sağlar.&lt;/tr_TR&gt;
    &lt;/Description&gt;</Update><Extends type="patch">
    <ParentProductInfo>
      <Family>Shared Technology</Family>
      <ProductName>Photoshop Camera Raw 7</ProductName>
      <AdobeCode>{CFC3110A-491C-4DBF-A97D-66C567600A2F}</AdobeCode>
    </ParentProductInfo>
  </Extends><InstallDestinationMetadata relocatableSize="43189512" sysDriveSize="0"><Destination>
      <Root>[INSTALLDIR]</Root>
      <TotalSize>43190034</TotalSize>
      <MaxPathComponent>/Plug-Ins/CS6/File Formats\Camera Raw.8bi</MaxPathComponent>
    </Destination>
    <Assets>
      <Asset flag="1" name="Assets1_1" size="43189512"/>
    </Assets>
  </InstallDestinationMetadata><ConflictingProcesses>
    <Win32>
      <Process processType="Adobe" blocking="1">^[Pp][Hh][Oo][Tt][Oo][Ss][Hh][Oo][Pp].[Ee][Xx][Ee]$</Process>
      <Process processType="Adobe" blocking="1">^[Bb][Rr][Ii][Dd][Gg][Ee].[Ee][Xx][Ee]$</Process>
      <Process processType="Adobe" blocking="1">^[Ee][Ll][Ee][Mm][Ee][Nn][Tt][Ss][Aa][Uu][Tt][Oo][Aa][Nn][Aa][Ll][Yy][Zz][Ee][Rr].[Ee][Xx][Ee]$</Process>
      <Process processType="Adobe" blocking="1">^[Pp][Hh][Oo][Tt][Oo][Ss][Hh][Oo][Pp] [Ee][Ll][Ee][Mm][Ee][Nn][Tt][Ss] 10.0.[Ee][Xx][Ee]$</Process>
      <Process processType="Adobe" blocking="1">^[Aa][Ff][Tt][Ee][Rr][Ff][Xx].[Ee][Xx][Ee]$</Process>
      <Process processType="Adobe" blocking="1">^[Aa][Dd][Oo][Bb][Ee] [Pp][Rr][Ee][Mm][Ii][Ee][Rr][Ee] [Ee][Ll][Ee][Mm][Ee][Nn][Tt][Ss] 9.[Ee][Xx][Ee]$</Process>
      <Process processType="Adobe" blocking="1">^[Pp][Hh][Oo][Tt][Oo][Dd][Oo][Ww][Nn][Ll][Oo][Aa][Dd][Ee][Rr].[Ee][Xx][Ee]$</Process>
      <Process processType="Adobe" blocking="1">^[Ll][Ii][Gg][Hh][Tt][Rr][Oo][Oo][Mm].[Ee][Xx][Ee]$</Process>
      <Process processType="Adobe" blocking="1">^[Pp][Hh][Oo][Tt][Oo][Ss][Hh][Oo][Pp] [Ee][Ll][Ee][Mm][Ee][Nn][Tt][Ss] 9.0.[Ee][Xx][Ee]$</Process>
      <Process processType="Adobe" blocking="1">^[Pp][Hh][Oo][Tt][Oo][Ss][Hh][Oo][Pp][Ee][Ll][Ee][Mm][Ee][Nn][Tt][Ss][Oo][Rr][Gg][Aa][Nn][Ii][Zz][Ee][Rr].[Ee][Xx][Ee]$</Process>
      <Process processType="Adobe" blocking="1">^[Aa][Dd][Oo][Bb][Ee] [Dd][Nn][Gg] [Cc][Oo][Nn][Vv][Ee][Rr][Tt][Ee][Rr].[Ee][Xx][Ee]$</Process>
      <Process processType="Adobe" blocking="1">^[Pp][Hh][Oo][Tt][Oo][Ss][Hh][Oo][Pp][Ee][Ll][Ee][Mm][Ee][Nn][Tt][Ss][Ee][Dd][Ii][Tt][Oo][Rr].[Ee][Xx][Ee]$</Process>
      <Process processType="Adobe" blocking="1">^[Aa][Dd][Oo][Bb][Ee] [Pp][Rr][Ee][Mm][Ii][Ee][Rr][Ee] [Ee][Ll][Ee][Mm][Ee][Nn][Tt][Ss] 10.[Ee][Xx][Ee]$</Process>
      <Process processType="Adobe" blocking="1">^[Aa][Dd][Oo][Bb][Ee] [Pp][Rr][Ee][Mm][Ii][Ee][Rr][Ee] [Ee][Ll][Ee][Mm][Ee][Nn][Tt][Ss].[Ee][Xx][Ee]$</Process>
    </Win32>
  </ConflictingProcesses><AddRemoveInfo>
    <DisplayVersion>
      <Value lang="ar_AE">7.1</Value>
      <Value lang="be_BY">7.1</Value>
      <Value lang="bg_BG">7.1</Value>
      <Value lang="ca_ES">7.1</Value>
      <Value lang="cs_CZ">7.1</Value>
      <Value lang="da_DK">7.1</Value>
      <Value lang="de_DE">7.1</Value>
      <Value lang="el_GR">7.1</Value>
      <Value lang="en_GB">7.1</Value>
      <Value lang="en_MX">7.1</Value>
      <Value lang="en_US">7.1</Value>
      <Value lang="en_XC">7.1</Value>
      <Value lang="en_XM">7.1</Value>
      <Value lang="es_ES">7.1</Value>
      <Value lang="es_MX">7.1</Value>
      <Value lang="es_QM">7.1</Value>
      <Value lang="et_EE">7.1</Value>
      <Value lang="fi_FI">7.1</Value>
      <Value lang="fr_CA">7.1</Value>
      <Value lang="fr_FR">7.1</Value>
      <Value lang="fr_MX">7.1</Value>
      <Value lang="fr_XM">7.1</Value>
      <Value lang="he_IL">7.1</Value>
      <Value lang="hi_IN">7.1</Value>
      <Value lang="hr_HR">7.1</Value>
      <Value lang="hu_HU">7.1</Value>
      <Value lang="is_IS">7.1</Value>
      <Value lang="it_IT">7.1</Value>
      <Value lang="ja_JP">7.1</Value>
      <Value lang="ko_KR">7.1</Value>
      <Value lang="lt_LT">7.1</Value>
      <Value lang="lv_LV">7.1</Value>
      <Value lang="mk_MK">7.1</Value>
      <Value lang="nb_NO">7.1</Value>
      <Value lang="nl_NL">7.1</Value>
      <Value lang="nn_NO">7.1</Value>
      <Value lang="no_NO">7.1</Value>
      <Value lang="pl_PL">7.1</Value>
      <Value lang="pt_BR">7.1</Value>
      <Value lang="ro_RO">7.1</Value>
      <Value lang="ru_RU">7.1</Value>
      <Value lang="sh_YU">7.1</Value>
      <Value lang="sk_SK">7.1</Value>
      <Value lang="sl_SI">7.1</Value>
      <Value lang="sq_AL">7.1</Value>
      <Value lang="sv_SE">7.1</Value>
      <Value lang="th_TH">7.1</Value>
      <Value lang="tr_TR">7.1</Value>
      <Value lang="uk_UA">7.1</Value>
      <Value lang="vi_VN">7.1</Value>
      <Value lang="zh_CN">7.1</Value>
      <Value lang="zh_TW">7.1</Value>
      <Value lang="en_AE">7.1</Value>
      <Value lang="en_IL">7.1</Value>
      <Value lang="fr_MA">7.1</Value>
    </DisplayVersion>
    <DisplayName>
      <Value lang="ar_AE">Photoshop Camera Raw 7</Value>
      <Value lang="be_BY">Photoshop Camera Raw 7</Value>
      <Value lang="bg_BG">Photoshop Camera Raw 7</Value>
      <Value lang="ca_ES">Photoshop Camera Raw 7</Value>
      <Value lang="cs_CZ">Photoshop Camera Raw 7</Value>
      <Value lang="da_DK">Photoshop Camera Raw 7</Value>
      <Value lang="de_DE">Photoshop Camera Raw 7</Value>
      <Value lang="el_GR">Photoshop Camera Raw 7</Value>
      <Value lang="en_GB">Photoshop Camera Raw 7</Value>
      <Value lang="en_MX">Photoshop Camera Raw 7</Value>
      <Value lang="en_US">Photoshop Camera Raw 7</Value>
      <Value lang="en_XC">Photoshop Camera Raw 7</Value>
      <Value lang="en_XM">Photoshop Camera Raw 7</Value>
      <Value lang="es_ES">Photoshop Camera Raw 7</Value>
      <Value lang="es_MX">Photoshop Camera Raw 7</Value>
      <Value lang="es_QM">Photoshop Camera Raw 7</Value>
      <Value lang="et_EE">Photoshop Camera Raw 7</Value>
      <Value lang="fi_FI">Photoshop Camera Raw 7</Value>
      <Value lang="fr_CA">Photoshop Camera Raw 7</Value>
      <Value lang="fr_FR">Photoshop Camera Raw 7</Value>
      <Value lang="fr_MX">Photoshop Camera Raw 7</Value>
      <Value lang="fr_XM">Photoshop Camera Raw 7</Value>
      <Value lang="he_IL">Photoshop Camera Raw 7</Value>
      <Value lang="hi_IN">Photoshop Camera Raw 7</Value>
      <Value lang="hr_HR">Photoshop Camera Raw 7</Value>
      <Value lang="hu_HU">Photoshop Camera Raw 7</Value>
      <Value lang="is_IS">Photoshop Camera Raw 7</Value>
      <Value lang="it_IT">Photoshop Camera Raw 7</Value>
      <Value lang="ja_JP">Photoshop Camera Raw 7</Value>
      <Value lang="ko_KR">Photoshop Camera Raw 7</Value>
      <Value lang="lt_LT">Photoshop Camera Raw 7</Value>
      <Value lang="lv_LV">Photoshop Camera Raw 7</Value>
      <Value lang="mk_MK">Photoshop Camera Raw 7</Value>
      <Value lang="nb_NO">Photoshop Camera Raw 7</Value>
      <Value lang="nl_NL">Photoshop Camera Raw 7</Value>
      <Value lang="nn_NO">Photoshop Camera Raw 7</Value>
      <Value lang="no_NO">Photoshop Camera Raw 7</Value>
      <Value lang="pl_PL">Photoshop Camera Raw 7</Value>
      <Value lang="pt_BR">Photoshop Camera Raw 7</Value>
      <Value lang="ro_RO">Photoshop Camera Raw 7</Value>
      <Value lang="ru_RU">Photoshop Camera Raw 7</Value>
      <Value lang="sh_YU">Photoshop Camera Raw 7</Value>
      <Value lang="sk_SK">Photoshop Camera Raw 7</Value>
      <Value lang="sl_SI">Photoshop Camera Raw 7</Value>
      <Value lang="sq_AL">Photoshop Camera Raw 7</Value>
      <Value lang="sv_SE">Photoshop Camera Raw 7</Value>
      <Value lang="th_TH">Photoshop Camera Raw 7</Value>
      <Value lang="tr_TR">Photoshop Camera Raw 7</Value>
      <Value lang="uk_UA">Photoshop Camera Raw 7</Value>
      <Value lang="vi_VN">Photoshop Camera Raw 7</Value>
      <Value lang="zh_CN">Photoshop Camera Raw 7</Value>
      <Value lang="zh_TW">Photoshop Camera Raw 7</Value>
      <Value lang="en_AE">Photoshop Camera Raw 7</Value>
      <Value lang="en_IL">Photoshop Camera Raw 7</Value>
      <Value lang="fr_MA">Photoshop Camera Raw 7</Value>
    </DisplayName>
  </AddRemoveInfo><UserPreferences>0</UserPreferences></PayloadInfo>')
INSERT INTO PayloadData VALUES("{FA148573-E0E5-400F-8978-D95410035F18}", "0" , "WorkflowVersion", "CS6")
INSERT INTO PayloadData VALUES("{FA148573-E0E5-400F-8978-D95410035F18}", "0" , "DEVersion", "6.0")
INSERT INTO PayloadData VALUES("{FA148573-E0E5-400F-8978-D95410035F18}", "0", "ChannelID", "PhotoshopCameraRaw7-7.0")
INSERT INTO PayloadData VALUES("{FA148573-E0E5-400F-8978-D95410035F18}", "0", "ChannelInfo", '<Channel enable="1" id="PhotoshopCameraRaw7-7.0">
        <DisplayName>Photoshop Camera Raw 7</DisplayName>
      </Channel>')
INSERT INTO PayloadData VALUES("{FA148573-E0E5-400F-8978-D95410035F18}", "0", "UpdateID", "7.1.74")
INSERT INTO PayloadData VALUES("{FA148573-E0E5-400F-8978-D95410035F18}", "0", "UpdateInfo", '<Update id="7.1.74">
        
        
      &lt;DisplayName default="en_US"&gt;
        &lt;en_US&gt;Photoshop Camera Raw 7.1&lt;/en_US&gt;
		&lt;fr_FR&gt;Mise à jour 7.1 de Photoshop Camera Raw&lt;/fr_FR&gt;
		&lt;de_DE&gt;Photoshop Camera Raw 7.1-Update&lt;/de_DE&gt;
		&lt;it_IT&gt;Aggiornamento di Photoshop Camera Raw 7.1&lt;/it_IT&gt;
		&lt;ja_JP&gt;Photoshop Camera Raw 7.1 アップデート&lt;/ja_JP&gt;
		&lt;es_ES&gt;Actualización Photoshop Camera Raw 7.1&lt;/es_ES&gt;
		&lt;sv_SE&gt;Uppdatering till Photoshop Camera Raw 7.1&lt;/sv_SE&gt;
		&lt;zh_CN&gt;Photoshop Camera Raw 7.1 更新&lt;/zh_CN&gt;
		&lt;zh_TW&gt;Photoshop Camera Raw 7.1 更新&lt;/zh_TW&gt;
		&lt;nl_NL&gt;Photoshop Camera Raw 7.1-update&lt;/nl_NL&gt;
		&lt;ko_KR&gt;Photoshop Camera Raw 7.1 업데이트&lt;/ko_KR&gt;
		&lt;nb_NO&gt;Oppdatering for Photoshop Camera Raw 7.1&lt;/nb_NO&gt;
		&lt;da_DK&gt;Photoshop Camera Raw 7.1-opdatering&lt;/da_DK&gt;
		&lt;fi_FI&gt;Photoshop Camera Raw 7.1 -päivitys&lt;/fi_FI&gt;
		&lt;pl_PL&gt;Photoshop Camera Raw 7.1 – aktualizacja&lt;/pl_PL&gt;
		&lt;cs_CZ&gt;Aktualizace Photoshop Camera Raw 7.1&lt;/cs_CZ&gt;
		&lt;ro_RO&gt;Actualizare Photoshop Camera Raw 7.1&lt;/ro_RO&gt;
		&lt;hu_HU&gt;Photoshop Camera Raw 7.1 frissítés&lt;/hu_HU&gt;
		&lt;ru_RU&gt;Обновление Photoshop Camera Raw 7.1&lt;/ru_RU&gt;
		&lt;pt_BR&gt;Atualização do Photoshop Camera Raw 7.1&lt;/pt_BR&gt;
		&lt;uk_UA&gt;Оновлення Photoshop Camera Raw 7.1&lt;/uk_UA&gt;
		&lt;tr_TR&gt;Photoshop Camera Raw 7.1 Güncellemesi&lt;/tr_TR&gt;
    &lt;/DisplayName&gt;&lt;Description default="en_US"&gt;
        &lt;en_US&gt;Update to the Camera Raw plug-in that ships with Photoshop CS6.  Adds raw support for new camera models.&lt;/en_US&gt;
		&lt;fr_FR&gt;Mise à jour du module externe Camera Raw fourni avec Photoshop CS6.  Ajoute la prise en charge des fichiers Raw pour les nouveaux modèles d'appareils photo.&lt;/fr_FR&gt;
		&lt;de_DE&gt;Update für das Camera Raw-Zusatzmodul, das im Lieferumfang von Photoshop CS6 enthalten ist.  Zusätzliche Unterstützung für Raw-Dateien aus neuen Kameramodellen&lt;/de_DE&gt;
		&lt;it_IT&gt;Eseguite l'aggiornamento del plug-in di Camera Raw in dotazione con Photoshop CS6.  Consente il supporto per i file raw per nuovi modelli di fotocamere&lt;/it_IT&gt;
		&lt;ja_JP&gt;Photoshop CS6 に同梱されている Camera Raw プラグインに更新します。  新しいカメラモデル対応の Raw サポートが追加されます。&lt;/ja_JP&gt;
		&lt;es_ES&gt;Actualización para el plugin Camera Raw suministrado con Photoshop CS6.  Permite la compatibilidad con los archivos RAW de los nuevos modelos de cámara.&lt;/es_ES&gt;
		&lt;sv_SE&gt;Uppdatera plugin-programmet Camera Raw som levereras med Photoshop CS6.  Lägger till stöd för raw-format för nya kameramodeller.&lt;/sv_SE&gt;
		&lt;zh_CN&gt;Photoshop CS6 随附的 Camera Raw 插件的更新。针对新相机型号增加 raw 文件格式支持&lt;/zh_CN&gt;
		&lt;zh_TW&gt;更新 Photoshop CS6 隨附的 Camera Raw 增效模組。  新增對新相機機型的原生支援&lt;/zh_TW&gt;
		&lt;nl_NL&gt;Update voor de Camera Raw-plug-in die bij Photoshop CS6 wordt geleverd.  Voegt RAW-ondersteuning toe voor nieuwe cameramodellen&lt;/nl_NL&gt;
		&lt;cs_CZ&gt;Aktualizace zásuvného modulu Camera Raw, dodávaného s aplikací Photoshop CS6.  Přidává podporu formátu raw u nových modelů fotoaparátů&lt;/cs_CZ&gt;
		&lt;nb_NO&gt;Oppdatering for tilleggsmodulen Camera Raw som leveres med Photoshop CS6.  Legger til ekte støtte for nye kameramodeller&lt;/nb_NO&gt;
		&lt;da_DK&gt;Opdatering til Camera Raw-ekstramodulet, der leveres sammen med Photoshop CS6.  Føjer Raw-understøttelse til nye kameramodeller&lt;/da_DK&gt;
		&lt;fi_FI&gt;Photoshop CS6:n mukana toimitettavan Camera Raw -laajennuksen päivitys.  Lisää raw-tuen uusille kameramalleille.&lt;/fi_FI&gt;
		&lt;pl_PL&gt;Aktualizacja wtyczki Camera Raw, która jest dołączona do programu Photoshop CS6.  Dodaje obsługę RAW dla nowych modeli aparatów&lt;/pl_PL&gt;
		&lt;ko_KR&gt;Photoshop CS6와 함께 제공된 Camera Raw 플러그인을 업데이트합니다.  새 카메라 모델의 raw 파일 지원 추가&lt;/ko_KR&gt;
		&lt;ro_RO&gt;Actualizaţi la plugin-ul Camera Raw livrat cu Photoshop CS6.  Acesta adaugă compatibilitate cu formate brute de la noi modele de camere foto&lt;/ro_RO&gt;
		&lt;hu_HU&gt;A Photoshop CS6 verzióhoz tartozó Camera Raw bővítmény frissítése.  Biztosítja a raw-formátum támogatását újabb fényképezőgép-típusok esetében is&lt;/hu_HU&gt;
		&lt;ru_RU&gt;Обновление внешнего модуля Camera Raw, который входит в комплект поставки Photoshop CS6.  Добавлена поддержка формата raw для новых моделей камер&lt;/ru_RU&gt;
		&lt;pt_BR&gt;Atualização do plug-in do Camera Raw fornecido com o Photoshop CS6.  Inclusão de suporte adicional para novos modelos de câmeras&lt;/pt_BR&gt;
		&lt;uk_UA&gt;Оновлення для модуля Camera Raw, що постачається з пакетом Photoshop CS6.  Додано підтримку формату raw для нових моделей фотокамер.&lt;/uk_UA&gt;
		&lt;tr_TR&gt;Photoshop CS6 ile birlikte verilen Camera Raw eklentisine güncelleyin.  Yeni fotoğraf makinesi modelleri için raw desteği sağlar.&lt;/tr_TR&gt;
    &lt;/Description&gt;</Update>')
