CONTAINER MoRigidBodyTag
{
	NAME name;
	INCLUDE Tbase;

	GROUP RIGID_BODY_GROUP_DYNAMICS
	{
		DEFAULT 1;

		BOOL RIGID_BODY_ENABLED {}
		BOOL RIGID_BODY_DYNAMIC {}

		SEPARATOR {LINE;}

		LONG RIGID_BODY_TRIGGER {CYCLE {RIGID_BODY_TRIGGER_IMMEDIATELY; RIGID_BODY_TRIGGER_AT_PEAK; RIGID_BODY_TRIGGER_ON_COLLISION;};}

		BOOL RIGID_BODY_USE_INITIAL_VELOCITY {}
		
		GROUP RIGID_BODY_GROUP_INITIAL_VELOCITY
		{
			VECTOR RIGID_BODY_INITIAL_LINEAR_VELOCITY {UNIT METER;}
			VECTOR RIGID_BODY_INITIAL_ANGULAR_VELOCITY {UNIT DEGREE;}
			BOOL RIGID_BODY_LOCAL_INITIAL_VELOCITY {ANIM OFF;}
		}

		SEPARATOR {LINE;}

		BOOL RIGID_BODY_DYNAMIC_TRANSITION {}
		BASETIME RIGID_BODY_TRANSITION_TIME {}

		GROUP RIGID_BODY_GROUP_DEACTIVATION
		{
			DEFAULT 0;

			REAL RIGID_BODY_SLEEPING_LINEAR_VELOCITY {MIN 0.0; UNIT METER;}
			REAL RIGID_BODY_SLEEPING_ANGULAR_VELOCITY {MIN 0.0; UNIT DEGREE;}
		}
	}

	GROUP RIGID_BODY_GROUP_COLLISION
	{
		DEFAULT 1;

		BOOL RIGID_BODY_HIERARCHY {ANIM OFF;}
		LONG RIGID_BODY_SPLIT_CACHE {CYCLE {RIGID_BODY_SPLIT_CACHE_OFF; RIGID_BODY_SPLIT_CACHE_TOP_LEVEL; RIGID_BODY_SPLIT_CACHE_SECOND_LEVEL; RIGID_BODY_SPLIT_CACHE_ON;};}

		LONG RIGID_BODY_SHAPE {CYCLE {RIGID_BODY_SHAPE_DEFAULT; RIGID_BODY_SHAPE_BOX; RIGID_BODY_SHAPE_ELLIPSOID; RIGID_BODY_SHAPE_CONVEX_HULL; RIGID_BODY_SHAPE_STATIC_MESH; RIGID_BODY_SHAPE_NO_SHAPE;};}
		GROUP
		{
			COLUMNS 2;
			BOOL RIGID_BODY_SPECIFIC_MARGIN {ANIM OFF;}
			REAL RIGID_BODY_MARGIN {MIN 0.0; UNIT METER;}
		}

		SEPARATOR {LINE;}

		REAL RIGID_BODY_RESTITUTION {MIN 0.0; STEP 0.05;}
		REAL RIGID_BODY_FRICTION {MIN 0.0; STEP 0.05;}
		REAL RIGID_BODY_COLLISION_NOISE {MIN 0.0; MAX 10.0; STEP 0.1;}
	}

	GROUP RIGID_BODY_GROUP_MASS
	{
		DEFAULT 0;

		GROUP
		{
			COLUMNS 3;
			LONG RIGID_BODY_MASS_SWITCH {CYCLE {RIGID_BODY_MASS_SWITCH_DEFAULT; RIGID_BODY_MASS_SWITCH_DENSITY; RIGID_BODY_MASS_SWITCH_MASS;}; ANIM OFF;}
			REAL RIGID_BODY_DENSITY {MINEX; MIN 0.0;}
			REAL RIGID_BODY_MASS {MINEX; MIN 0.0;}
		}
		REAL RIGID_BODY_INERTIA_FACTOR {MIN 1; MAX 10000; UNIT PERCENT;}

		SEPARATOR {LINE;}

		GROUP
		{
			COLUMNS 2;
			BOOL RIGID_BODY_USE_CENTER_OF_MASS {ANIM OFF;}
			VECTOR RIGID_BODY_CENTER_OF_MASS {UNIT METER;}
		}
	}

	GROUP RIGID_BODY_GROUP_FORCE
	{
		DEFAULT 0;

		LONG RIGID_BODY_FOLLOW_ANIMATION {CYCLE {RIGID_BODY_FOLLOW_ANIMATION_OFF; RIGID_BODY_FOLLOW_ANIMATION_LINEAR; RIGID_BODY_FOLLOW_ANIMATION_BOTH;};}
		REAL RIGID_BODY_FOLLOW_STRENGTH {MIN 0.0; MAX 100.0;}

		SEPARATOR {LINE;}

		REAL RIGID_BODY_LINEAR_DAMPING {MIN 0.0; UNIT PERCENT; STEP 1.0;}
		REAL RIGID_BODY_ANGULAR_DAMPING {MIN 0.0; UNIT PERCENT; STEP 1.0;}

		SEPARATOR {LINE;}

		LONG RIGID_BODY_FORCE_MODE {CYCLE {RIGID_BODY_FORCE_MODE_INCLUDE; RIGID_BODY_FORCE_MODE_EXCLUDE;}}
		IN_EXCLUDE RIGID_BODY_FORCE_INCLUDE_LIST {NUM_FLAGS 0; INIT_STATE 0; SEND_SELCHNGMSG 1; ACCEPT {Obase;};}
	}

}
