#include "operatingsystem.h"
#include "c4d_basebitmap.h"
#include "c4d_memory.h"
#include "c4d_file.h"
#include "c4d_general.h"
#include "c4d_basecontainer.h"
#include "c4d_filterplugin.h"
#include "lib_iconcollection.h"

BaseBitmapLink *BaseBitmapLink::Alloc(void)
{
	return C4DOS.Bm->BBL_Alloc();
}

void BaseBitmapLink::Free(BaseBitmapLink *&bll)
{
	C4DOS.Bm->BBL_Free(bll);
	bll=NULL;
}

BaseBitmap *BaseBitmapLink::Get() const
{
	return C4DOS.Bm->BBL_Get((BaseBitmapLink*)this);
}

void BaseBitmapLink::Set(BaseBitmap *bmp)
{
	C4DOS.Bm->BBL_Set(this,bmp);
}

BaseBitmap *BaseBitmap::Alloc(void)
{
	return C4DOS.Bm->Alloc();
}

void BaseBitmap::Free(BaseBitmap *&bm)
{
	C4DOS.Bm->Free(bm);
	bm=NULL;
}

void MultipassBitmap::Free(MultipassBitmap *&bm)
{
	C4DOS.Bm->Free(bm);
	bm=NULL;
}

LONG BaseBitmap::GetColorMode(void) const
{
	return C4DOS.Bm->MPB_GetParameter((const MultipassBitmap*)this,MPB_COLORMODE).GetLong();
}

BaseBitmap *BaseBitmap::GetClone(void) const
{
	return C4DOS.Bm->GetClone(this);
}

Bool BaseBitmap::CopyTo(BaseBitmap *dst) const
{
	return C4DOS.Bm->CopyTo(this,dst);
}

Bool BaseBitmap::CopyPartTo(BaseBitmap *dst, LONG x, LONG y, LONG w, LONG h) const
{
	return C4DOS.Bm->CopyPartTo(this,dst,x,y,w,h);
}

BaseBitmap *BaseBitmap::GetClonePart(LONG x, LONG y, LONG w, LONG h) const
{
	return C4DOS.Bm->GetClonePart(this,x,y,w,h);
}

void BaseBitmap::FlushAll(void)
{
	C4DOS.Bm->FlushAll(this);
}
		
LONG BaseBitmap::Init(LONG x, LONG y, LONG depth, LONG flags)
{
	return C4DOS.Bm->Init1(this,x,y,depth,flags);
}

LONG BaseBitmap::Init(const Filename &name, LONG frame, Bool *ismovie)
{
	return C4DOS.Bm->Init2(this,&name,frame,ismovie);
}

LONG BaseBitmap::Init(BaseBitmap *&res, const Filename &name, LONG frame, Bool *ismovie, BitmapLoaderPlugin **loaderplugin)
{
	return C4DOS.Bm->Init3(res,name,frame,ismovie,loaderplugin);
}

LONG BaseBitmap::Save(const Filename &name, LONG format, BaseContainer *data, LONG savebits) const
{
	return C4DOS.Bm->Save(this,&name,format,data,savebits);
}

void BaseBitmap::GetLine(LONG y, void *data) const
{
	C4DOS.Bm->GetLine(this,y,data);
}

void BaseBitmap::SetLine(LONG y, void *data, LONG depth)
{
	C4DOS.Bm->SetLine(this,y,data,depth);
}

void BaseBitmap::SetCMAP(LONG i, LONG r, LONG g, LONG b)
{
	C4DOS.Bm->SetCMAP(this,i,r,g,b);
}

void BaseBitmap::ScaleBicubic(BaseBitmap *dest, LONG src_xmin, LONG src_ymin, LONG src_xmax, LONG src_ymax, LONG dst_xmin, LONG dst_ymin, LONG dst_xmax, LONG dst_ymax) const
{
	C4DOS.Bm->ScaleBicubic(this,dest,src_xmin,src_ymin,src_xmax,src_ymax,dst_xmin,dst_ymin,dst_xmax,dst_ymax);
}

void BaseBitmap::ScaleIt(BaseBitmap *dst, LONG intens, Bool sample, Bool nprop) const
{
	C4DOS.Bm->ScaleIt(this,dst,intens,sample,nprop);
}

void BaseBitmap::Clear(LONG r, LONG g, LONG b)
{
	C4DOS.Bm->Clear(this,0,0,GetBw()-1,GetBh()-1,r,g,b);
}

void BaseBitmap::Clear(LONG x1, LONG y1, LONG x2, LONG y2, LONG r, LONG g, LONG b)
{
	C4DOS.Bm->Clear(this,x1,y1,x2,y2,r,g,b);
}

AlphaBitmap *BaseBitmap::AddChannel(Bool internal, Bool straight)
{
	return C4DOS.Bm->AddChannel(this,internal,straight);
}

void BaseBitmap::RemoveChannel(AlphaBitmap *channel)
{
	C4DOS.Bm->RemoveChannel(this,channel);
}

const AlphaBitmap *BaseBitmap::GetInternalChannel(void) const
{
	return C4DOS.Bm->GetInternalChannel(((BaseBitmap*)this));
}

AlphaBitmap *BaseBitmap::GetInternalChannel(void)
{
	return C4DOS.Bm->GetInternalChannel(this);
}

LONG BaseBitmap::GetChannelCount(void) const
{
	return C4DOS.Bm->GetChannelCount(this);
}

AlphaBitmap *BaseBitmap::GetChannelNum(LONG num)
{
	return C4DOS.Bm->GetChannelNum(this,num);
}

const AlphaBitmap *BaseBitmap::GetChannelNum(LONG num) const
{
	return C4DOS.Bm->GetChannelNum(((BaseBitmap*)this),num);
}

Bool BaseBitmap::SetData(LONG id,const GeData &data)
{
	return C4DOS.Bm->SetBaseBitmapData(this,id,data);
}

GeData BaseBitmap::GetData(LONG id, const GeData &t_default) const
{
	return C4DOS.Bm->GetBaseBitmapData(this,id,t_default);
}

Bool BaseBitmap::IsMultipassBitmap(void) const
{
	return C4DOS.Bm->IsMultipassBitmap(this);
}

MovieLoader *MovieLoader::Alloc( void )
{
	return gNew MovieLoader();
}

void MovieLoader::Free( MovieLoader *&ml )
{
	gDelete( ml );
}

MovieLoader::MovieLoader( void )
{
	InitData();
}

MovieLoader::~MovieLoader( void )
{
	FreeData();
}

void	MovieLoader::InitData( void )
{
	plugin = NULL;
	bm = NULL;
	is_movie = FALSE;
	frame_cnt = 0;
	fps = 0.0;
	frame_idx = -2;
	result = IMAGE_OK;
}

void	MovieLoader::FreeData( void )
{
	if ( plugin )
	{
		plugin->BmLoadAnimated( &plugin_data, BITMAPLOADER_FREE, NULL, 0 );
		plugin = NULL;
	}

	if ( bm )
		BaseBitmap::Free( bm );
}
	
LONG  MovieLoader::Open( const Filename &fn )
{
#ifdef _DEBUG
	if ( plugin )
		GeBoom();																								// call Close() before reusing a MovieLoader
	if ( bm )
		GeBoom();
	FreeData();																								// release a previously used bitmap/plugin
	InitData();																								// back to start
#endif

	result = BaseBitmap::Init( bm, fn, frame_idx, &is_movie, &plugin );
	if (( result != IMAGE_OK ) || ( plugin == NULL ))
	{
		if (( plugin == NULL ) && ( result == IMAGE_OK ))				// this shouldn't happen
			result = IMAGE_WRONGTYPE;

		plugin = NULL;
		BaseBitmap::Free( bm );
		return result;
	}

	if ( is_movie )
	{
		if ( GeGetMovieInfo( fn,&frame_cnt, &fps ) == FALSE )
		{
			frame_cnt = 0;
			fps = 0.0;
			GeBoom();																							// don't return an error here - examine the problem
		}

		plugin_data.moviename = fn;
		result = plugin->BmLoadAnimated( &plugin_data, BITMAPLOADER_INIT, NULL, 0 );
		if ( result != IMAGE_OK )
		{
			FreeData();
			return result;
		}
		frame_idx = -2;																					// nothing loaded yet
	}

	return result;
}

void	MovieLoader::Close( void )
{
	FreeData();
	InitData();																								// back to start
}

//----------------------------------------------------------------------------------------
// Read a frame and return the bitmap pointer
// Function result:		BaseBitmap (MovieLoader is the owner) or NULL (check _result)
// new_frame_idx:			frame index
// _result:						used to return the result code (IMAGE_OK or error code)
//----------------------------------------------------------------------------------------
BaseBitmap	*MovieLoader::Read( LONG new_frame_idx, LONG *_result )
{
	if ( is_movie == FALSE )
		return bm;																							// always return the image initally loaded at the init call

	if ( new_frame_idx == frame_idx )													// frame already loaded?
		return bm;

	result = plugin->BmLoadAnimated( &plugin_data, BITMAPLOADER_LOAD, bm, new_frame_idx );	// read the requested frame
	if ( result == IMAGE_OK )
	{
		frame_idx = new_frame_idx;
		return bm;
	}
	
	frame_idx = -2;																						// loading a new frame failed, content of bm is unknown
	if ( _result )
		*_result = result;
	return NULL;
}

//----------------------------------------------------------------------------------------
// Get movie/bitmap info
// Function result:		number of frames (0: Open failed)
// _fps:							used to return frame rate
//----------------------------------------------------------------------------------------
LONG	MovieLoader::GetInfo( Real *_fps )
{
	if ( _fps )
		*_fps = fps;

	if ( is_movie )
		return frame_cnt;
	
	if ( result == IMAGE_OK )
		return 1;

	return 0;																									// Open failed
}

MovieSaver *MovieSaver::Alloc(void)
{
	return C4DOS.Ms->Alloc();
}

void MovieSaver::Free(MovieSaver *&ms)
{
	C4DOS.Ms->Free(ms);
	ms=NULL;
}

LONG MovieSaver::Open(const Filename &name, BaseBitmap *bm, LONG fps, LONG id, BaseContainer *data, LONG savebits, BaseSound *sound)
{
	return C4DOS.Ms->Open(this,&name,bm,fps,id,data,savebits,sound);
}

LONG MovieSaver::Write(BaseBitmap *bm)
{
	return C4DOS.Ms->Write(this,bm);
}

void MovieSaver::Close(void)
{
	C4DOS.Ms->Close(this);
}

Bool MovieSaver::Choose(LONG id, BaseContainer *bc)
{
	return C4DOS.Ms->Choose(this,id,bc);
}

#define CallBmLoader(fnc) (((BitmapLoaderData*)(((BITMAPLOADERPLUGIN*)GetPluginStructure())->adr))->*((BITMAPLOADERPLUGIN*)GetPluginStructure())->fnc)
#define CallBmSaver(fnc)  (((BitmapSaverData*)(((BITMAPSAVERPLUGIN*)GetPluginStructure())->adr))->*((BITMAPSAVERPLUGIN*)GetPluginStructure())->fnc)

Bool BitmapLoaderPlugin::BmIdentify(const Filename &name, UCHAR *probe, LONG size)
{
	return CallBmLoader(Identify)(name,probe,size);
}

LONG BitmapLoaderPlugin::BmLoad(const Filename &name, BaseBitmap *bm, LONG frame)
{
	return CallBmLoader(Load)(name,bm,frame);
}

LONG BitmapLoaderPlugin::BmGetSaver(void)
{
	if (!((BITMAPLOADERPLUGIN*)GetPluginStructure())->GetSaver) return 0;
	return CallBmLoader(GetSaver)();
}

Bool BitmapLoaderPlugin::BmGetInformation(const Filename &name, LONG *frames, Real *fps)
{
	if (!((BITMAPLOADERPLUGIN*)GetPluginStructure())->GetInformation) return FALSE;
	return CallBmLoader(GetInformation)(name,frames,fps);
}

LONG BitmapLoaderPlugin::BmLoadAnimated(BitmapLoaderAnimatedData *bd, LONG action, BaseBitmap *bm, LONG frame)
{
	if (!((BITMAPLOADERPLUGIN*)GetPluginStructure())->LoadAnimated) return FALSE;
	return CallBmLoader(LoadAnimated)(bd, action, bm, frame);
}

LONG BitmapLoaderPlugin::BmExtractSound(BitmapLoaderAnimatedData *bd, BaseSound *snd)
{
	if (!((BITMAPLOADERPLUGIN*)GetPluginStructure())->ExtractSound) return FALSE;
	return CallBmLoader(ExtractSound)(bd, snd);
}

void BitmapSaverPlugin::BmGetDetails(LONG *alpha, String *suffix)
{
	if (alpha)
	{
		BaseContainer bc;
		*alpha = CallBmSaver(GetMaxAlphas)(&bc);
	}
	
	if (suffix)
	{
		*suffix=String();
		String *str=((BITMAPSAVERPLUGIN*)GetPluginStructure())->suffix;
		if (str) *suffix=*str;
	}
}

Bool BitmapSaverPlugin::BmEdit(BaseContainer *data)
{
	return CallBmSaver(Edit)(data);
}

LONG BitmapSaverPlugin::BmSave(const Filename &name, BaseBitmap *bm, BaseContainer *data, LONG savebits)
{
	return CallBmSaver(Save)(name,bm,data,savebits);
}

LONG BitmapSaverPlugin::BmOpen(PluginMovieData *&md, const Filename &name, BaseBitmap *bm, BaseContainer *data, LONG savebits, LONG fps)
{
	if (!((BITMAPSAVERPLUGIN*)GetPluginStructure())->Open) return IMAGE_NOMEM;
	return CallBmSaver(Open)(md,name,bm,data,savebits,fps);
}

LONG BitmapSaverPlugin::BmWrite(PluginMovieData *md, BaseBitmap *bm)
{
	if (!((BITMAPSAVERPLUGIN*)GetPluginStructure())->Write) return IMAGE_NOMEM;
	return CallBmSaver(Write)(md,bm);
}

void BitmapSaverPlugin::BmClose(PluginMovieData *&md)
{
	if (!((BITMAPSAVERPLUGIN*)GetPluginStructure())->Close) return;
	CallBmSaver(Close)(md);
}

BaseBitmap *InitResourceBitmap(LONG resource_id)
{
	IconData dat;
	if (!GetIcon(resource_id,&dat) || !dat.bmp) return NULL;

	return dat.bmp->GetClonePart(dat.x,dat.y,dat.w,dat.h);
}

Bool MultipassBitmap::GetLayers(GeTempDynArray<BaseBitmap> &list, LONG flags)
{
	list.FlushThis();
	if (!IsMultipassBitmap())
	{
		// must never happen. if this is the case the pointer is not a multipassbmp the call must be catched outside!
		GeBoom();
		return FALSE;
	}
	LONG count;
	BaseBitmap **arr=NULL;

	if (!C4DOS.Bm->MPB_GetLayers(this,flags,arr,count)) return FALSE;

	LONG i;
	for (i=0;i<count;i++)
	{
		if (!arr[i]) continue;
		list.Append(arr[i]);
	}
	GeFree(arr);
	return TRUE;
}

Bool MultipassBitmap::GetLayers(GeTempDynArray<MultipassBitmap> &list, LONG flags)
{
	list.FlushThis();
	if (!IsMultipassBitmap())
	{
		// must never happen. if this is the case the pointer is not a multipassbmp the call must be catched outside!
		GeBoom();
		return FALSE;
	}
	LONG count;
	BaseBitmap **arr=NULL;

	if (!C4DOS.Bm->MPB_GetLayers(this,flags,arr,count)) return FALSE;
	if (!arr) return FALSE;

	LONG i;
	for (i=0;i<count;i++)
	{
		if (!arr[i] || !arr[i]->IsMultipassBitmap()) continue;
		list.Append((MultipassBitmap*)arr[i]);
	}
	GeFree(arr);
	return TRUE;
}
