#include "c4d_basesound.h"
#include "c4d_file.h"
#include "operatingsystem.h"

BaseSound *BaseSound::GetClone(void)
{
	return C4DOS.Bu->GetClone(this);
}

Bool BaseSound::CopyTo(BaseSound *dest)
{
	return C4DOS.Bu->CopyTo(this,dest);
}

Bool BaseSound::Init(LONG samples, LONG fmode, Bool stereo, Bool b16)
{
	return C4DOS.Bu->Init(this,samples,fmode,stereo,b16);
}

void BaseSound::FlushAll(void)
{
	C4DOS.Bu->FlushAll(this);
}

Bool BaseSound::Load(const Filename &fn)
{
	return C4DOS.Bu->Load(this,&fn);
}

Bool BaseSound::Save(const Filename &fn)
{
	return C4DOS.Bu->Save(this,&fn);
}

CHAR *BaseSound::GetSoundInfo(Bool *stereo, Bool *b16, LONG *frequency, LONG *samples, BaseTime *length)
{
	return C4DOS.Bu->GetSoundInfo(this,stereo,b16,frequency,samples,length);
}

Bool BaseSound::ReadIt(HyperFile *hf, LONG level)
{
	return C4DOS.Bu->ReadIt(this,hf,level);
}

Bool BaseSound::WriteIt(HyperFile *hf)
{
	return C4DOS.Bu->WriteIt(this,hf);
}


CHAR *BaseSound::GetRAW(void)
{
	return C4DOS.Bu->GetRAW(this);
}

BaseSound *BaseSound::GetClonePart(const BaseTime &start,	const BaseTime &stop,	Bool reverse)
{
	return C4DOS.Bu->GetClonePart(this,start,stop,reverse);
}

void BaseSound::GetSample(LONG i, SData *data)
{
	C4DOS.Bu->GetSample(this,i,data);
}

void BaseSound::SetSample(LONG i, const SData &data)
{
	C4DOS.Bu->SetSample(this,i,(SData*)&data);
}

BaseBitmap *BaseSound::GetBitmap(LONG width, LONG height, const BaseTime &start, const BaseTime &stop)
{
	return C4DOS.Bu->GetBitmap(this,width,height,start,stop);
}

BaseBitmap *BaseSound::GetBitmap(LONG width, LONG height, const BaseTime &start, const BaseTime &stop, const Vector &draw_col, const Vector &back_col)
{
	return C4DOS.Bu->GetBitmap2(this,width,height,start,stop,draw_col,back_col);
}

GeListHead  *BaseSound::GetMarkerRoot(void)
{
	return C4DOS.Bu->GetMarkerRoot(this);
}

BaseSound *BaseSound::Alloc(void)
{
	return C4DOS.Bu->Alloc();
}

void BaseSound::Free(BaseSound *&bs)
{
	C4DOS.Bu->Free(bs);
	bs=NULL;
}
