#include "customgui_bitmapbutton.h"
#include "c4d_string.h"
#include "c4d_gui.h"
#include "lib_iconcollection.h"


BitmapButtonLib *lib_bitmapbutton = NULL;


static BitmapButtonLib *CheckPrefsLib(LONG offset)
{
	return (BitmapButtonLib*)CheckLib(CUSTOMGUI_BITMAPBUTTON,offset,(C4DLibrary**)&lib_bitmapbutton);
}

Bool BitmapButtonCustomGui::SetImage(BaseBitmap *bmp,Bool copybmp,Bool secondstate)
{
	BitmapButtonLib *lib = CheckPrefsLib(LIBOFFSET(BitmapButtonLib,SetImageA));
	if (!lib || !lib->SetImageA) return FALSE;

	return (((iBitmapButtonCustomGui*)this)->*lib->SetImageA)(bmp,copybmp,secondstate);
}

Bool BitmapButtonCustomGui::SetImage(IconData *bmp,Bool secondstate)
{
	BitmapButtonLib *lib = CheckPrefsLib(LIBOFFSET(BitmapButtonLib,SetImageA));
	if (!lib || !lib->SetImageC) return FALSE;

	return (((iBitmapButtonCustomGui*)this)->*lib->SetImageC)(bmp,secondstate);
}

Bool BitmapButtonCustomGui::SetImage(LONG icon_id,Bool secondstate)
{
	BitmapButtonLib *lib = CheckPrefsLib(LIBOFFSET(BitmapButtonLib,SetImageA));
	if (!lib || !lib->SetImageC) return FALSE;

	IconData dat;
	if (!GetIcon(icon_id,&dat)) return FALSE;

	return (((iBitmapButtonCustomGui*)this)->*lib->SetImageC)(&dat,secondstate);
}

Bool BitmapButtonCustomGui::SetImage(const Filename &name,Bool secondstate)
{
	BitmapButtonLib *lib = CheckPrefsLib(LIBOFFSET(BitmapButtonLib,SetImageA));
	if (!lib || !lib->SetImageB) return FALSE;

	return (((iBitmapButtonCustomGui*)this)->*lib->SetImageB)(name,secondstate);
}

void BitmapButtonCustomGui::SetToggleState(Bool set)
{
	BitmapButtonLib *lib = CheckPrefsLib(LIBOFFSET(BitmapButtonLib,SetToggleState));
	if (!lib || !lib->SetToggleState) return;

	(((iBitmapButtonCustomGui*)this)->*lib->SetToggleState)(set);
}

void BitmapButtonCustomGui::SetDragArray(const AtomArray *array)
{
	BitmapButtonLib *lib = CheckPrefsLib(LIBOFFSET(BitmapButtonLib,SetDragArray));
	if (!lib || !lib->SetDragArray) return;

	(((iBitmapButtonCustomGui*)this)->*lib->SetDragArray)(array);
}

void BitmapButtonCustomGui::SetCommandDragId(LONG cmdid)
{
	BitmapButtonLib *lib = CheckPrefsLib(LIBOFFSET(BitmapButtonLib,SetCommandDragId));
	if (!lib || !lib->SetCommandDragId) return;

	(((iBitmapButtonCustomGui*)this)->*lib->SetCommandDragId)(cmdid);
}

void BitmapButtonCustomGui::SetCallback(const BitmapButtonCallback &cb)
{
	BitmapButtonLib *lib = CheckPrefsLib(LIBOFFSET(BitmapButtonLib,SetCallback));
	if (!lib || !lib->SetCallback) return;

	(((iBitmapButtonCustomGui*)this)->*lib->SetCallback)(cb);
}

