#ifndef _CUSTOMGUI_LAYERSET_H_
#define _CUSTOMGUI_LAYERSET_H_

#include "c4d_library.h"
#include "c4d_basecontainer.h"
#include "c4d_gui.h"
#include "c4d_customdatatype.h"
#include "customgui_base.h"

#ifdef __API_INTERN__
	#include "ge_string.h"
	#include "ge_file.h"
#else
	#include "c4d_string.h"
	#include "c4d_file.h"
#endif

#define CUSTOMGUI_LAYERSET			200000043
#define CUSTOMDATATYPE_LAYERSET 200000044

enum LAYERSETMODE
{
	LAYERSETMODE_LAYERS,
	LAYERSETMODE_LAYERMASKS,
	LAYERSETMODE_ALPHAS,
	LAYERSETMODE_LAYERALPHA,
	LAYERSETMODE_DISABLED
};

class LayerSetSelection : public CustomDataType
{
	private:
		LayerSetSelection();
		~LayerSetSelection();

	public:

		Bool Content() const { return C4DOS.Pa->LSL_Content(this); }
		Bool IsLayerEnabled(const String &name) const { return C4DOS.Pa->LSL_IsLayerEnabled(this,name); }
		Bool FindLayerSet(const String &name) const { return C4DOS.Pa->LSL_FindLayerSet(this,name); }

		String GetName() const { return C4DOS.Pa->LSL_GetName(this); }

		LONG GetMode() const { return C4DOS.Pa->LSL_GetMode(this); }
		void SetMode(LONG t_mode) { C4DOS.Pa->LSL_SetMode(this,t_mode); }

		void RemoveLayer(const String &layer) { C4DOS.Pa->LSL_RemoveLayer(this,layer); }
		void AddLayer(const String &layer) { C4DOS.Pa->LSL_AddLayer(this,layer); }
		void FlushLayers() { C4DOS.Pa->LSL_FlushLayers(this); }

		void SetPreviewMode(LONG s) { C4DOS.Pa->LSL_SetPreviewMode(this,s); }
		LONG GetPreviewMode(void) { return C4DOS.Pa->LSL_GetPreviewMode(this); }

		const LayerSetSelection& operator = (const LayerSetSelection &layerset);
		Bool operator == (const LayerSetSelection &layerset) const { return C4DOS.Pa->LSL_operator_cmp(this,layerset); }

		void CopyTo(LayerSetSelection &dst) const { C4DOS.Pa->LSL_CopyTo(this,dst); }

		static LayerSetSelection* Alloc() { return C4DOS.Pa->LSL_Alloc(); }
		static void Free(LayerSetSelection *layerset) { C4DOS.Pa->LSL_Free(layerset); }
};

#ifndef __API_INTERN__
class LayerSetHelper
{
	private:
		LayerSetHelper();
		~LayerSetHelper();
	public:
		Bool Init(const Filename &fn, const LayerSetSelection *selection) { return C4DOS.Pa->LSH_Init(this,fn,selection); }
		Bool EditLayerSet(const String &dialogtitle, LayerSetSelection *layerset, LayerSetSelection *layerseta) { return C4DOS.Pa->LSH_EditLayerSet(this,dialogtitle,layerset,layerseta); }
		Bool MergeLayerSet(const LayerSetSelection &selection, BaseBitmap *bmp, Bool preview) { return C4DOS.Pa->LSH_MergeLayerSet(this,selection,bmp,preview); }

		static LayerSetHelper* Alloc() { return C4DOS.Pa->LSH_Alloc(); }
		static void Free(LayerSetHelper *lsh) { C4DOS.Pa->LSH_Free(lsh); }
};

inline Bool CalculateLockListResolution(BaseDocument *doc, const Filename &filename, LONG *xres, LONG *yres)
{
	return C4DOS.Pa->CLL_CalculateResolution(doc,filename,xres,yres);
}

inline Bool CalculateLockListFilename(BaseDocument *doc, Filename &fn, LayerSetSelection *lsl)
{
	return C4DOS.Pa->CLL_CalculateFilename(doc,fn,lsl);
}
#endif

class LayerSetCustomGui : public BaseCustomGui<CUSTOMGUI_LAYERSET>
{
		LayerSetCustomGui();
		~LayerSetCustomGui();
};

// INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF

#ifndef _INTERNAL_DEF_
	class iLayerSetCustomGui
	{
	};
#else
	class iLayerSetCustomGui;
#endif

struct CustomGuiLayerSetLib : public BaseCustomGuiLib
{
};

#endif
