/////////////////////////////////////////////////////////////
// CINEMA 4D SDK                                           //
/////////////////////////////////////////////////////////////
// (c) 1989-2006 MAXON Computer GmbH, all rights reserved  //
/////////////////////////////////////////////////////////////

//----------------------------------------------------
//Falloff controller system
#ifndef _C4D_FALLOFFPLUGIN_H_
#define _C4D_FALLOFFPLUGIN_H_

#include "c4d.h"
#include "c4d_falloffdata.h"

struct FALLOFFPLUGIN : public STATICPLUGIN
{	
	FalloffDataAllocator				*allocator;

	Bool					(FalloffData::*Init							)(FalloffDataData &falldata,BaseContainer *bc);
	Bool					(FalloffData::*InitFalloff			)(BaseContainer *bc, FalloffDataData &falldata);
	void					(FalloffData::*Sample						)(const Vector &p, const FalloffDataData &data, Real *res);
	void					(FalloffData::*FreeFalloff			)(FalloffDataData &falldata);
	Bool					(FalloffData::*CheckDirty				)(BaseContainer *bc);
	Bool					(FalloffData::*GetDVisible			)(DescID &id,BaseContainer *bc,BaseContainer *desc_bc);
	LONG					(FalloffData::*GetHandleCount		)(BaseContainer *bc, const FalloffDataData &data);
	Vector				(FalloffData::*GetHandle				)(BaseContainer *bc, LONG i, const FalloffDataData &data);
	void					(FalloffData::*SetHandle				)(BaseContainer *bc, LONG i, Vector p, const FalloffDataData &data);
	Bool					(FalloffData::*Draw							)(const FalloffDataData &data, LONG drawpass, BaseDraw *bd, BaseDrawHelp *bh);
	Bool					(FalloffData::*Message					)(LONG type,BaseContainer *bc,void *m_data);

	void*					reserved[(32-11)*C4DPL_MEMBERMULTIPLIER-1];
};

class iC4D_Falloff;

struct FalloffControlLib : public C4DLibrary
{
	BaseContainer*			(iC4D_Falloff::*GetContainerInstance		)();
	void								(iC4D_Falloff::*SetDirty								)();
	LONG								(iC4D_Falloff::*GetDirty								)(BaseContainer *bc);
	void								(iC4D_Falloff::*SetMg										)(Matrix mg);
	Matrix							(iC4D_Falloff::*GetMg										)();
	void								(iC4D_Falloff::*SetData									)(FalloffDataData falldata);
	FalloffDataData			(iC4D_Falloff::*GetData									)();
	Bool								(iC4D_Falloff::*SetMode									)(LONG type,BaseContainer *bc);
	LONG								(iC4D_Falloff::*GetMode									)();
	void								(iC4D_Falloff::*SetTime									)(BaseTime time,BaseContainer *bc);
	Bool								(iC4D_Falloff::*InitFalloff							)(BaseContainer *bc,BaseDocument *doc, BaseObject *op);
	void								(iC4D_Falloff::*Sample									)(const Vector &p,Real *result,Bool usespline,Real weight);
	Bool								(iC4D_Falloff::*AddFalloffToDescription	)(Description *description,BaseContainer *bc);
	Bool								(iC4D_Falloff::*Message									)(LONG id,BaseContainer *bc,void *m_data);
	LONG								(iC4D_Falloff::*GetHandleCount					)(BaseContainer *bc);
	Vector							(iC4D_Falloff::*GetHandle								)(LONG i, BaseContainer *bc);
	void								(iC4D_Falloff::*SetHandle								)(LONG i, Vector p, BaseContainer *bc);
	Bool								(iC4D_Falloff::*Draw										)(BaseDraw *bd, BaseDrawHelp *bh, LONG flags,BaseContainer *bc);
	Bool								(iC4D_Falloff::*CopyTo									)(iC4D_Falloff *dest);
	iC4D_Falloff*				(*Alloc)(void);
	void								(*Free)(iC4D_Falloff *&node);
	void								(iC4D_Falloff::*MultiSample							)(const Vector *p,Real *result,LONG count,Bool usespline,Real weight);
};

#endif