#include "c4d_memory.h"
#include "c4d_general.h"
#include "c4d_basebitmap.h"
#include "c4d_filterplugin.h"
#include "c4d_resource.h"
#include "operatingsystem.h"

LONG BitmapLoaderData::GetSaver(void)
{
	return 0;
}

LONG BitmapLoaderData::ExtractSound(BitmapLoaderAnimatedData *bd, BaseSound *snd)
{
	return IMAGE_NOTEXISTING;
}

LONG BitmapLoaderData::LoadAnimated(BitmapLoaderAnimatedData *bd, LONG action, BaseBitmap *bm, LONG frame)
{
	return IMAGE_OK;
}

Bool BitmapLoaderData::GetInformation(const Filename &name, LONG *frames, Real *fps) 
{ 
	return FALSE; 
}

Bool BitmapSaverData::Edit(BaseContainer *data)
{
	return TRUE;
}

LONG BitmapSaverData::GetMaxAlphas(BaseContainer *data)
{
	return 0;
}

LONG BitmapSaverData::Write(PluginMovieData *md, BaseBitmap *bm)
{
	return IMAGE_NOMEM;
}

LONG BitmapSaverData::Save(const Filename &name, BaseBitmap *bm, BaseContainer *data, LONG savebits)
{
	return IMAGE_NOMEM;
}

LONG BitmapSaverData::Open(PluginMovieData *&md, const Filename &name, BaseBitmap *bm, BaseContainer *data, LONG savebits, LONG fps)
{
	return 0;
}

void BitmapSaverData::Close(PluginMovieData *&md)
{
	md=NULL;
}

LONG BitmapSaverData::AddSound(PluginMovieData *md, BaseSound *snd)
{
	return IMAGE_NOMEM;
}

Bool RegisterBitmapLoaderPlugin(LONG id, const String &str, LONG info, BitmapLoaderData *dat)
{
	if (!dat) return FALSE;

	BITMAPLOADERPLUGIN np;
	ClearMem(&np,sizeof(np));

	np.Destructor			= &BaseData::Destructor;
	np.info						= info;
	np.adr						= dat;
	np.Identify				= &BitmapLoaderData::Identify;
	np.Load						= &BitmapLoaderData::Load;
	np.GetSaver				= &BitmapLoaderData::GetSaver;
	np.GetInformation	=	&BitmapLoaderData::GetInformation;
	np.LoadAnimated   = &BitmapLoaderData::LoadAnimated;
	np.ExtractSound   = &BitmapLoaderData::ExtractSound;
	return GeRegisterPlugin(C4DPL_BITMAPLOADER,id,str,&np,sizeof(np));
}

Bool RegisterBitmapSaverPlugin(LONG id, const String &str, LONG info, BitmapSaverData *dat, const String &suffix)
{
	if (!dat) return FALSE;

	BITMAPSAVERPLUGIN np;
	ClearMem(&np,sizeof(np));
	np.Destructor		= &BaseData::Destructor;
	np.info					= info;
	np.adr					= dat;
	np.suffix				= (String*)&suffix;
	np.Save					= &BitmapSaverData::Save;
	np.GetMaxAlphas = &BitmapSaverData::GetMaxAlphas;
	np.Edit					= &BitmapSaverData::Edit;
	np.Open					= &BitmapSaverData::Open;
	np.Write				= &BitmapSaverData::Write;
	np.Close				= &BitmapSaverData::Close;
	np.AddSound     = &BitmapSaverData::AddSound;
	return GeRegisterPlugin(C4DPL_BITMAPSAVER,id,str,&np,sizeof(np));
}

Bool RegisterSceneLoaderPlugin(LONG id, const String &str, LONG info, DataAllocator *g, const String &description, void *emulation)
{
	if (description.Content() && !RegisterDescription(id,description)) return FALSE;

	SCENELOADERPLUGIN np;
	ClearMem(&np,sizeof(np));
	FillNodePlugin(&np,info,g,NULL,0,emulation);
	np.Identify		= &SceneLoaderData::Identify;
	np.Load				= &SceneLoaderData::Load;
	return GeRegisterPlugin(C4DPL_SCENELOADER,id,str,&np,sizeof(np));
}

Bool RegisterSceneSaverPlugin(LONG id, const String &str, LONG info, DataAllocator *g, const String &description, const String &suffix, void *emulation)
{
	if (description.Content() && !RegisterDescription(id,description)) return FALSE;

	SCENESAVERPLUGIN np;
	ClearMem(&np,sizeof(np));
	FillNodePlugin(&np,info,g,NULL,0,emulation);
	np.suffix			= (String*)&suffix;
	np.Save				= &SceneSaverData::Save;
	return GeRegisterPlugin(C4DPL_SCENESAVER,id,str,&np,sizeof(np));
}
