
#ifndef __API_INTERN__
	#include "c4d_library.h"
	#include "c4d_memory.h"
	#include "c4d_general.h"
#else
	#include "c4d_library.h"
	#include "ge_registry.h"
#endif










Bool InstallLibrary(LONG id, C4DLibrary *lib,LONG version, LONG size)
{
	lib->version = version;
	lib->size    = size;
	return GeRegistryAdd(id, RE_LIBRARY, lib);
}

Bool UninstallLibrary(C4DLibrary *lib,LONG version, LONG size)
{
	return TRUE;
}

C4DLibrary *CheckLib(LONG id, VLONG offset, C4DLibrary **store)
{
	if (store && *store) return *store;
	Registry *reg = GeRegistryFind(id, RE_LIBRARY);
	if (!reg) return NULL;
#ifndef __API_INTERN__
	C4DLibrary *lib = (C4DLibrary*)reg->GetData();
#else
	C4DLibrary *lib = (C4DLibrary*)reg->data;
#endif
	if (!lib) return NULL;
	if (store) *store = lib;
	// not the right version
	if (offset>lib->size) return NULL;

	return lib;
}




