#include "c4d_library.h"
#include "lib_aes.h"

AESLib* lib_aes = NULL;

static AESLib *CheckLibNoise(LONG offset)
{
	return (AESLib*)CheckLib(AES_LIB, offset, (C4DLibrary**)&lib_aes);
}

#define AESLibCall(b) 		AESLib *lib = CheckLibNoise(LIBOFFSET(AESLib, b)); \
	if (!lib || !lib->b) return; \
	(((RijndaelCipher*)this)->*lib->b)

#define AESLibCallR(a,b)  AESLib *lib = CheckLibNoise(LIBOFFSET(AESLib, b)); \
	if (!lib || !lib->b) return a; \
	return (((RijndaelCipher*)this)->*lib->b)

AES* AES::Alloc()
{
	AESLib *lib = CheckLibNoise(LIBOFFSET(AESLib, RijndaelCipher_Alloc)); if (!lib) return NULL;
	return (AES*)lib->RijndaelCipher_Alloc();	
}

void AES::Free(AES *&p)
{
	if (!p) return;
	AESLib *lib = CheckLibNoise(LIBOFFSET(AESLib, RijndaelCipher_Free)); if (!lib) return;
	RijndaelCipher* i = (RijndaelCipher*)p;
	lib->RijndaelCipher_Free(i);
	p = NULL;
}

VLONG AES::CalcEncryptedDataSize(LONG lBlockLength, VLONG lDataLength)
{
	AESLib *lib = CheckLibNoise(LIBOFFSET(AESLib, RijndaelCipher_CalcEncryptedDataSize)); 
	if (!lib) return 0;
	return lib->RijndaelCipher_CalcEncryptedDataSize(lBlockLength, lDataLength);
}

Bool AES::Init(LONG lBlockLength, LONG lKeyLength)
{
	AESLibCallR(FALSE, Init)(lBlockLength, lKeyLength);
}

Bool AES::Encrypt(void* pData, VLONG lDataLength, const void* pKey)
{
	AESLibCallR(FALSE, Encrypt)(pData, lDataLength, pKey);
}

Bool AES::Decrypt(void* pData, VLONG lDataLength, const void* pKey)
{
	AESLibCallR(FALSE, Decrypt)(pData, lDataLength, pKey);
}

void AES::SetProgresCallback(PFNRIJINDAEL_CIPHER_PROGRESS fn, void* pData)
{
	AESLibCall(SetProgresCallback)(fn, pData);
}
