#include "c4d_library.h"
#include "lib_dwgobjects.h"

DWGObjectsLib* lib_dwg = NULL;

static DWGObjectsLib *CheckLibI(LONG offset)
{
	return (DWGObjectsLib*)CheckLib(DWGOBJECTS_LIB, offset, (C4DLibrary**)&lib_dwg);
}

#define DWGObjectsLibCall(b) 		DWGObjectsLib *lib = CheckLibI(LIBOFFSET(DWGObjectsLib, b)); \
	if (!lib || !lib->b) return; \
	(((RijndaelCipher*)this)->*lib->b)

#define DWGObjectsLibCallR(a,b)  DWGObjectsLib *lib = CheckLibI(LIBOFFSET(DWGObjectsLib, b)); \
	if (!lib || !lib->b) return a; \
	return (((RijndaelCipher*)this)->*lib->b)


xBaseCurveData* xBaseCurveClass::AllocCurve(LONG type)
{
	DWGObjectsLib *lib = CheckLibI(LIBOFFSET(DWGObjectsLib, AllocCurve)); if (!lib) return NULL;
	return (this->*lib->AllocCurve)(type);
}

Bool xBaseCurveClass::Update(GeListNode *node)
{
	DWGObjectsLib *lib = CheckLibI(LIBOFFSET(DWGObjectsLib, Update)); if (!lib) return FALSE;
	return (this->*lib->Update)(node);
}

LONG xBaseCurveClass::GetSubDivision()
{
	DWGObjectsLib *lib = CheckLibI(LIBOFFSET(DWGObjectsLib, GetSubDivision)); if (!lib) return 0;
	return (this->*lib->GetSubDivision)();
}

void xBaseCurveClass::SetSubDivision(LONG subdiv)
{
	DWGObjectsLib *lib = CheckLibI(LIBOFFSET(DWGObjectsLib, SetSubDivision)); if (!lib) return;
	(this->*lib->SetSubDivision)(subdiv);
}

void xBaseGeometryData::Initialize(GeListNode *node)
{
	DWGObjectsLib *lib = CheckLibI(LIBOFFSET(DWGObjectsLib, Initialize)); if (!lib) return;
	(this->*lib->Initialize)(node);
}

void xLineCurveData::SetStartPoint(const Vector &v)
{
	DWGObjectsLib *lib = CheckLibI(LIBOFFSET(DWGObjectsLib, SetStartPoint)); if (!lib) return;
	(this->*lib->SetStartPoint)(v);
}

void xLineCurveData::SetEndPoint(const Vector &v)
{
	DWGObjectsLib *lib = CheckLibI(LIBOFFSET(DWGObjectsLib, SetEndPoint)); if (!lib) return;
	(this->*lib->SetEndPoint)(v);
}

void xCircularCurveData::SetCenter(Real x, Real y)
{
	DWGObjectsLib *lib = CheckLibI(LIBOFFSET(DWGObjectsLib, SetCenter)); if (!lib) return;
	(this->*lib->SetCenter)(x,y);
}

void xCircularCurveData::SetZValue(Real z)
{
	DWGObjectsLib *lib = CheckLibI(LIBOFFSET(DWGObjectsLib, SetZValue)); if (!lib) return;
	(this->*lib->SetZValue)(z);
}

void xCircularCurveData::SetStartPoint(Real x, Real y)
{
	DWGObjectsLib *lib = CheckLibI(LIBOFFSET(DWGObjectsLib, SetStartPoint2)); if (!lib) return;
	(this->*lib->SetStartPoint2)(x,y);
}

void xCircularCurveData::SetEndPoint(Real x, Real y)
{
	DWGObjectsLib *lib = CheckLibI(LIBOFFSET(DWGObjectsLib, SetEndPoint2)); if (!lib) return;
	(this->*lib->SetEndPoint2)(x,y);
}

void xCircularCurveData::SetIsClockWise(Bool value)
{
	DWGObjectsLib *lib = CheckLibI(LIBOFFSET(DWGObjectsLib, SetIsClockWise)); if (!lib) return;
	(this->*lib->SetIsClockWise)(value);
}

void xConicCurveData::SetZValue(Real z)
{
	DWGObjectsLib *lib = CheckLibI(LIBOFFSET(DWGObjectsLib, SetZValue2)); if (!lib) return;
	(this->*lib->SetZValue2)(z);
}

void xConicCurveData::SetStartPoint(Real x, Real y)
{
	DWGObjectsLib *lib = CheckLibI(LIBOFFSET(DWGObjectsLib, SetStartPoint3)); if (!lib) return;
	(this->*lib->SetStartPoint3)(x,y);
}

void xConicCurveData::SetEndPoint(Real x, Real y)
{
	DWGObjectsLib *lib = CheckLibI(LIBOFFSET(DWGObjectsLib, SetEndPoint3)); if (!lib) return;
	(this->*lib->SetEndPoint3)(x,y);
}

void xConicCurveData::SetCoefficients(const ConicCurveCoeffcients &coeff)
{
	DWGObjectsLib *lib = CheckLibI(LIBOFFSET(DWGObjectsLib, SetCoefficients1)); if (!lib) return;
	(this->*lib->SetCoefficients1)(coeff);
}

void xConicCurveData::SetCoefficients(Real a, Real b, Real c, Real d, Real e, Real f)
{
	DWGObjectsLib *lib = CheckLibI(LIBOFFSET(DWGObjectsLib, SetCoefficients2)); if (!lib) return;
	(this->*lib->SetCoefficients2)(a,b,c,d,e,f);
}

void xNurbsKnots::SetPeriodic(Bool state)
{
	DWGObjectsLib *lib = CheckLibI(LIBOFFSET(DWGObjectsLib, SetPeriodic)); if (!lib) return;
	(this->*lib->SetPeriodic)(state);
}

void xNurbsKnots::Set(LONG i, Real value)
{
	DWGObjectsLib *lib = CheckLibI(LIBOFFSET(DWGObjectsLib, Set)); if (!lib) return;
	(this->*lib->Set)(i,value);
}

Real xNurbsKnots::GetMinValue(void)
{
	DWGObjectsLib *lib = CheckLibI(LIBOFFSET(DWGObjectsLib, GetMinValue)); if (!lib) return 0.0;
	return (this->*lib->GetMinValue)();
}

Real xNurbsKnots::GetMaxValue(void)
{
	DWGObjectsLib *lib = CheckLibI(LIBOFFSET(DWGObjectsLib, GetMaxValue)); if (!lib) return 0.0;
	return (this->*lib->GetMaxValue)();
}

Bool xNurbsCurveData::ResizeObject(LONG count, LONG degree)
{
	DWGObjectsLib *lib = CheckLibI(LIBOFFSET(DWGObjectsLib, ResizeObject4)); if (!lib) return FALSE;
	return (this->*lib->ResizeObject4)(count,degree);
}

void xNurbsCurveData::SetClosed(Bool value)
{
	DWGObjectsLib *lib = CheckLibI(LIBOFFSET(DWGObjectsLib, SetClosed)); if (!lib) return;
	(this->*lib->SetClosed)(value);
}

void xNurbsCurveData::SetPoint(LONG index, const Vector& position, const Real& weight)
{
	DWGObjectsLib *lib = CheckLibI(LIBOFFSET(DWGObjectsLib, SetPoint)); if (!lib) return;
	(this->*lib->SetPoint)(index,position,weight);
}

xNurbsKnots* xNurbsCurveData::GetKnots()
{
	DWGObjectsLib *lib = CheckLibI(LIBOFFSET(DWGObjectsLib, GetKnots2)); if (!lib) return NULL;
	return (this->*lib->GetKnots2)();
}

void xNurbsCurveData::SetParameterRange(Real min, Real max)
{
	DWGObjectsLib *lib = CheckLibI(LIBOFFSET(DWGObjectsLib, SetParameterRange)); if (!lib) return;
	(this->*lib->SetParameterRange)(min,max);
}

xBaseSurfaceData*	xBaseSurfaceClass::AllocSurface(LONG type)
{
	DWGObjectsLib *lib = CheckLibI(LIBOFFSET(DWGObjectsLib, AllocSurface)); if (!lib) return NULL;
	return (this->*lib->AllocSurface)(type);
}

Bool xBaseSurfaceClass::Update(GeListNode *node)
{
	DWGObjectsLib *lib = CheckLibI(LIBOFFSET(DWGObjectsLib, Update2)); if (!lib) return FALSE;
	return (this->*lib->Update2)(node);
}

void xBaseSurfaceClass::SetSubU(LONG subu)
{
	DWGObjectsLib *lib = CheckLibI(LIBOFFSET(DWGObjectsLib, SetSubU)); if (!lib) return;
	(this->*lib->SetSubU)(subu);
}

void xBaseSurfaceClass::SetSubV(LONG subv)
{
	DWGObjectsLib *lib = CheckLibI(LIBOFFSET(DWGObjectsLib, SetSubV)); if (!lib) return;
	(this->*lib->SetSubV)(subv);
}

void xExtrudeSurfaceData::SetDirection(const Vector &v)
{
	DWGObjectsLib *lib = CheckLibI(LIBOFFSET(DWGObjectsLib, SetDirection)); if (!lib) return;
	(this->*lib->SetDirection)(v);
}

void xBaseCurveClass::SetOutput(LONG output)
{
	DWGObjectsLib *lib = CheckLibI(LIBOFFSET(DWGObjectsLib, SetOutput)); if (!lib) return;
	(this->*lib->SetOutput)(output);
}

void xBaseCurveData::SetPlanar(Bool planar)
{
	DWGObjectsLib *lib = CheckLibI(LIBOFFSET(DWGObjectsLib, SetPlanar)); if (!lib) return;
	(this->*lib->SetPlanar)(planar);
}

void xLineCurveData::SetLimit(Real v)
{
	DWGObjectsLib *lib = CheckLibI(LIBOFFSET(DWGObjectsLib, SetLimit)); if (!lib) return;
	(this->*lib->SetLimit)(v);
}

void xLineCurveData::SetLineType(LineCurveTypeEnum type)
{
	DWGObjectsLib *lib = CheckLibI(LIBOFFSET(DWGObjectsLib, SetLineType)); if (!lib) return;
	(this->*lib->SetLineType)(type);
}

Real xCircularCurveData::GetParameterMax(GeListNode *node)
{
	DWGObjectsLib *lib = CheckLibI(LIBOFFSET(DWGObjectsLib, GetParameterMax)); if (!lib) return 0.0;
	return (this->*lib->GetParameterMax)(node);
}

Real xCircularCurveData::GetParameterMin(GeListNode *node)
{
	DWGObjectsLib *lib = CheckLibI(LIBOFFSET(DWGObjectsLib, GetParameterMin)); if (!lib) return 0.0;
	return (this->*lib->GetParameterMin)(node);
}

Real xNurbsKnots::Get(LONG i)
{
	DWGObjectsLib *lib = CheckLibI(LIBOFFSET(DWGObjectsLib, Get)); if (!lib) return 0.0;
	return (this->*lib->Get)(i);
}

void xBaseCurvePoint::SetPosition(const Vector &vector)
{
	DWGObjectsLib *lib = CheckLibI(LIBOFFSET(DWGObjectsLib, SetPosition)); if (!lib) return;
	(this->*lib->SetPosition)(vector);
}

static Vector dummyvector;

const Vector &xBaseCurvePoint::GetPosition()
{
	DWGObjectsLib *lib = CheckLibI(LIBOFFSET(DWGObjectsLib, GetPosition)); if (!lib) return dummyvector;
	return (this->*lib->GetPosition)();
}

void xNurbsCurvePoint::SetWeight(Real w)
{
	DWGObjectsLib *lib = CheckLibI(LIBOFFSET(DWGObjectsLib, SetWeight)); if (!lib) return;
	(this->*lib->SetWeight)(w);
}

Real xNurbsCurvePoint::GetWeight()
{
	DWGObjectsLib *lib = CheckLibI(LIBOFFSET(DWGObjectsLib, GetWeight)); if (!lib) return 0.0;
	return (this->*lib->GetWeight)();
}

void xNurbsCurveData::SetPolynomial(Bool value)
{
	DWGObjectsLib *lib = CheckLibI(LIBOFFSET(DWGObjectsLib, SetPolynomial3)); if (!lib) return;
	(this->*lib->SetPolynomial3)(value);
}

xNurbsCurvePoint* xNurbsCurveData::GetPoint(LONG index)
{
	DWGObjectsLib *lib = CheckLibI(LIBOFFSET(DWGObjectsLib, GetPoint)); if (!lib) return NULL;
	return (this->*lib->GetPoint)(index);
}

void xBaseSurfaceClass::SetOutput(LONG output)
{
	DWGObjectsLib *lib = CheckLibI(LIBOFFSET(DWGObjectsLib, SetOutput2)); if (!lib) return;
	(this->*lib->SetOutput2)(output);
}

void xBaseSurfaceClass::SetNormalsActive(Bool normals_active)
{
	DWGObjectsLib *lib = CheckLibI(LIBOFFSET(DWGObjectsLib, SetNormalsActive)); if (!lib) return;
	(this->*lib->SetNormalsActive)(normals_active);
}

void xBaseSurfaceClass::SetNormalsSwap(Bool normals_swap)
{
	DWGObjectsLib *lib = CheckLibI(LIBOFFSET(DWGObjectsLib, SetNormalsSwap)); if (!lib) return;
	(this->*lib->SetNormalsSwap)(normals_swap);
}

void xPlaneSurfaceData::SetCoefficients(Real a, Real b, Real c, Real d)
{
	DWGObjectsLib *lib = CheckLibI(LIBOFFSET(DWGObjectsLib, SetCoefficients)); if (!lib) return;
	(this->*lib->SetCoefficients)(a,b,c,d);
}

void xPlaneSurfaceData::SetDisplayPosition(const Vector &v)
{
	DWGObjectsLib *lib = CheckLibI(LIBOFFSET(DWGObjectsLib, SetDisplayPosition)); if (!lib) return;
	(this->*lib->SetDisplayPosition)(v);
}

void xPlaneSurfaceData::SetDisplaySize(Real s)
{
	DWGObjectsLib *lib = CheckLibI(LIBOFFSET(DWGObjectsLib, SetDisplaySize)); if (!lib) return;
	(this->*lib->SetDisplaySize)(s);
}

void xPlaneSurfaceData::SetLimit(Real v)
{
	DWGObjectsLib *lib = CheckLibI(LIBOFFSET(DWGObjectsLib, SetLimit2)); if (!lib) return;
	(this->*lib->SetLimit2)(v);
}

void xPlaneSurfaceData::SetPlaneType(PlaneSurfaceTypeEnum type)
{
	DWGObjectsLib *lib = CheckLibI(LIBOFFSET(DWGObjectsLib, SetPlaneType)); if (!lib) return;
	(this->*lib->SetPlaneType)(type);
}

void xPolynomCurvePoint::SetCoeff(LONG number, const Vector &vector)
{
	DWGObjectsLib *lib = CheckLibI(LIBOFFSET(DWGObjectsLib, SetCoeff)); if (!lib) return;
	(this->*lib->SetCoeff)(number,vector);
}

Bool xPolynomCurveData::ResizeObject(LONG count, LONG degree)
{
	DWGObjectsLib *lib = CheckLibI(LIBOFFSET(DWGObjectsLib, ResizeObject2)); if (!lib) return FALSE;
	return (this->*lib->ResizeObject2)(count,degree);
}

Real* xPolynomCurveData::GetBreakPoint(LONG index)
{
	DWGObjectsLib *lib = CheckLibI(LIBOFFSET(DWGObjectsLib, GetBreakPoint)); if (!lib) return NULL;
	return (this->*lib->GetBreakPoint)(index);
}

xPolynomCurvePoint* xPolynomCurveData::GetPoint(LONG index)
{
	DWGObjectsLib *lib = CheckLibI(LIBOFFSET(DWGObjectsLib, GetPoint2)); if (!lib) return NULL;
	return (this->*lib->GetPoint2)(index);
}

LONG xPolynomCurveData::GetPointCount(GeListNode *node)
{
	DWGObjectsLib *lib = CheckLibI(LIBOFFSET(DWGObjectsLib, GetPointCount2)); if (!lib) return 0;
	return (this->*lib->GetPointCount2)(node);
}

void xPolynomCurveData::InitClosed()
{
	DWGObjectsLib *lib = CheckLibI(LIBOFFSET(DWGObjectsLib, InitClosed)); if (!lib) return;
	(this->*lib->InitClosed)();
}

void xPolynomSurfacePoint::SetUVCoeff(LONG uindex, LONG vindex, const Vector &vector)
{
	DWGObjectsLib *lib = CheckLibI(LIBOFFSET(DWGObjectsLib, SetUVCoeff)); if (!lib) return;
	(this->*lib->SetUVCoeff)(uindex,vindex,vector);
}

Bool xPolynomSurfaceData::ResizeObject(LONG ucount, LONG vcount, LONG udegree, LONG vdegree)
{
	DWGObjectsLib *lib = CheckLibI(LIBOFFSET(DWGObjectsLib, ResizeObject3)); if (!lib) return FALSE;
	return (this->*lib->ResizeObject3)(ucount,vcount,udegree,vdegree);
}

Real* xPolynomSurfaceData::GetUBreakPoint(LONG index)
{
	DWGObjectsLib *lib = CheckLibI(LIBOFFSET(DWGObjectsLib, GetUBreakPoint)); if (!lib) return NULL;
	return (this->*lib->GetUBreakPoint)(index);
}

Real* xPolynomSurfaceData::GetVBreakPoint(LONG index)
{
	DWGObjectsLib *lib = CheckLibI(LIBOFFSET(DWGObjectsLib, GetVBreakPoint)); if (!lib) return NULL;
	return (this->*lib->GetVBreakPoint)(index);
}

xPolynomSurfacePoint*	xPolynomSurfaceData::GetPoint(LONG uindex, LONG vindex)
{
	DWGObjectsLib *lib = CheckLibI(LIBOFFSET(DWGObjectsLib, GetPoint3)); if (!lib) return NULL;
	return (this->*lib->GetPoint3)(uindex,vindex);
}

LONG xPolynomSurfaceData::GetPointCount(GeListNode *node)
{
	DWGObjectsLib *lib = CheckLibI(LIBOFFSET(DWGObjectsLib, GetPointCount3)); if (!lib) return 0;
	return (this->*lib->GetPointCount3)(node);
}

void xPolynomSurfaceData::InitClosed()
{
	DWGObjectsLib *lib = CheckLibI(LIBOFFSET(DWGObjectsLib, InitClosed3)); if (!lib) return;
	(this->*lib->InitClosed3)();
}

void xRotateSurfaceData::SetStartAngle(Real angle)
{
	DWGObjectsLib *lib = CheckLibI(LIBOFFSET(DWGObjectsLib, SetStartAngle)); if (!lib) return;
	(this->*lib->SetStartAngle)(angle);
}

void xRotateSurfaceData::SetEndAngle(Real angle)
{
	DWGObjectsLib *lib = CheckLibI(LIBOFFSET(DWGObjectsLib, SetEndAngle)); if (!lib) return;
	(this->*lib->SetEndAngle)(angle);
}

void xRotateSurfaceData::SetInvert(Bool state)
{
	DWGObjectsLib *lib = CheckLibI(LIBOFFSET(DWGObjectsLib, SetInvert)); if (!lib) return;
	(this->*lib->SetInvert)(state);
}

void xUVPairFF::SetPeriodicU(Bool u)
{
	DWGObjectsLib *lib = CheckLibI(LIBOFFSET(DWGObjectsLib, SetPeriodicU)); if (!lib) return;
	(this->*lib->SetPeriodicU)(u);
}

void xUVPairFF::SetPeriodicV(Bool v)
{
	DWGObjectsLib *lib = CheckLibI(LIBOFFSET(DWGObjectsLib, SetPeriodicV)); if (!lib) return;
	(this->*lib->SetPeriodicV)(v);
}

void xUVPairFF::SetU(LONG idx, Real u)
{
	DWGObjectsLib *lib = CheckLibI(LIBOFFSET(DWGObjectsLib, SetU)); if (!lib) return;
	(this->*lib->SetU)(idx,u);
}

void xUVPairFF::SetV(LONG idx, Real v)
{
	DWGObjectsLib *lib = CheckLibI(LIBOFFSET(DWGObjectsLib, SetV)); if (!lib) return;
	(this->*lib->SetV)(idx,v);
}

Real xUVPairFF::GetU(LONG idx)
{
	DWGObjectsLib *lib = CheckLibI(LIBOFFSET(DWGObjectsLib, GetU)); if (!lib) return 0.0;
	return (this->*lib->GetU)(idx);
}

Real xUVPairFF::GetV(LONG idx)
{
	DWGObjectsLib *lib = CheckLibI(LIBOFFSET(DWGObjectsLib, GetV)); if (!lib) return 0.0;
	return (this->*lib->GetV)(idx);
}

xUVPairFF* xNurbsSurfaceData::GetKnots()
{
	DWGObjectsLib *lib = CheckLibI(LIBOFFSET(DWGObjectsLib, GetKnots)); if (!lib) return NULL;
	return (this->*lib->GetKnots)();
}

void xNurbsSurfaceData::SetPolynomial(Bool p)
{
	DWGObjectsLib *lib = CheckLibI(LIBOFFSET(DWGObjectsLib, SetPolynomial2)); if (!lib) return;
	(this->*lib->SetPolynomial2)(p);
}

void xNurbsSurfaceData::SetUClosed(Bool c)
{
	DWGObjectsLib *lib = CheckLibI(LIBOFFSET(DWGObjectsLib, SetUClosed)); if (!lib) return;
	(this->*lib->SetUClosed)(c);
}

void xNurbsSurfaceData::SetVClosed(Bool c)
{
	DWGObjectsLib *lib = CheckLibI(LIBOFFSET(DWGObjectsLib, SetVClosed)); if (!lib) return;
	(this->*lib->SetVClosed)(c);
}

Bool xNurbsSurfaceData::ResizeObject(LONG ucount, LONG vcount, LONG udegree, LONG vdegree)
{
	DWGObjectsLib *lib = CheckLibI(LIBOFFSET(DWGObjectsLib, ResizeObject5)); if (!lib) return FALSE;
	return (this->*lib->ResizeObject5)(ucount,vcount,udegree,vdegree);
}

void xNurbsSurfaceData::SetUParameterRange(Real min, Real max)
{
	DWGObjectsLib *lib = CheckLibI(LIBOFFSET(DWGObjectsLib, SetUParameterRange)); if (!lib) return;
	(this->*lib->SetUParameterRange)(min,max);
}

void xNurbsSurfaceData::SetVParameterRange(Real min, Real max)
{
	DWGObjectsLib *lib = CheckLibI(LIBOFFSET(DWGObjectsLib, SetVParameterRange)); if (!lib) return;
	(this->*lib->SetVParameterRange)(min,max);
}

LONG xNurbsSurfaceData::GetUPointCount(GeListNode *node)
{
	DWGObjectsLib *lib = CheckLibI(LIBOFFSET(DWGObjectsLib, GetUPointCount2)); if (!lib) return 0;
	return (this->*lib->GetUPointCount2)(node);
}

LONG xNurbsSurfaceData::GetVPointCount(GeListNode *node)
{
	DWGObjectsLib *lib = CheckLibI(LIBOFFSET(DWGObjectsLib, GetVPointCount2)); if (!lib) return 0;
	return (this->*lib->GetVPointCount2)(node);
}

xNurbsCurvePoint* xNurbsSurfaceData::GetPoint(LONG uindex, LONG vindex)
{
	DWGObjectsLib *lib = CheckLibI(LIBOFFSET(DWGObjectsLib, GetPoint4)); if (!lib) return NULL;
	return (this->*lib->GetPoint4)(uindex,vindex);
}

xMappedCurveData* xMappedCurveClass::AllocMapped(LONG type)
{
	DWGObjectsLib *lib = CheckLibI(LIBOFFSET(DWGObjectsLib, AllocMapped)); if (!lib) return NULL;
	return (this->*lib->AllocMapped)(type);
}

Bool xMappedCurveClass::Update(GeListNode *node)
{
	DWGObjectsLib *lib = CheckLibI(LIBOFFSET(DWGObjectsLib, Update3)); if (!lib) return FALSE;
	return (this->*lib->Update3)(node);
}

void xStandardMappedCurveData::SetSegmented(Bool value)
{
	DWGObjectsLib *lib = CheckLibI(LIBOFFSET(DWGObjectsLib, SetSegmented)); if (!lib) return;
	(this->*lib->SetSegmented)(value);
}

void xSegmentMappedCurveData::SetReversed(Bool value)
{
	DWGObjectsLib *lib = CheckLibI(LIBOFFSET(DWGObjectsLib, SetReversed)); if (!lib) return;
	(this->*lib->SetReversed)(value);
}

xTrimmedSurfaceData* xTrimmedSurfaceClass::AllocTrimmed(LONG type)
{
	DWGObjectsLib *lib = CheckLibI(LIBOFFSET(DWGObjectsLib, AllocTrimmed)); if (!lib) return NULL;
	return (this->*lib->AllocTrimmed)(type);
}

void xTrimmedSurfaceClass::SetPrecision(Real precision)
{
	DWGObjectsLib *lib = CheckLibI(LIBOFFSET(DWGObjectsLib, SetPrecision4)); if (!lib) return;
	(this->*lib->SetPrecision4)(precision);
}

Bool xTrimmedSurfaceClass::Update(GeListNode *node)
{
	DWGObjectsLib *lib = CheckLibI(LIBOFFSET(DWGObjectsLib, Update4)); if (!lib) return FALSE;
	return (this->*lib->Update4)(node);
}

void xStandardTrimmedSurfaceData::SetFirstOuter(Bool value)
{
	DWGObjectsLib *lib = CheckLibI(LIBOFFSET(DWGObjectsLib, SetFirstOuter)); if (!lib) return;
	(this->*lib->SetFirstOuter)(value);
}



Bool xConvertToPolygons(BaseObject *oroot, BaseObject *destination, LONG flags)
{
	DWGObjectsLib *lib = CheckLibI(LIBOFFSET(DWGObjectsLib, xConvertToPolygons)); if (!lib) return FALSE;
	return (*lib->xConvertToPolygons)(oroot,destination,flags);
}

Bool xConvertToPolygonGroups(BaseObject *oroot, BaseObject *destination, LONG flags)
{
	DWGObjectsLib *lib = CheckLibI(LIBOFFSET(DWGObjectsLib, xConvertToPolygonGroups)); if (!lib) return FALSE;
	return (*lib->xConvertToPolygonGroups)(oroot,destination,flags);
}

Bool xCenterAxis(BaseObject *oroot)
{
	DWGObjectsLib *lib = CheckLibI(LIBOFFSET(DWGObjectsLib, xCenterAxis)); if (!lib) return FALSE;
	return (*lib->xCenterAxis)(oroot);
}

Bool xFilterModelSpaceCurves(BaseObject *oroot)
{
	DWGObjectsLib *lib = CheckLibI(LIBOFFSET(DWGObjectsLib, xFilterModelSpaceCurves)); if (!lib) return FALSE;
	return (*lib->xFilterModelSpaceCurves)(oroot);
}
